/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PathSelectDialog.h
 *    TODO Add description.
 *
 * @author ronny
 * @date   2011/09/20
 */

#ifndef _MIRA_PATHSELECTDIALOG_H_
#define _MIRA_PATHSELECTDIALOG_H_

#include <ui_PathSelectDialog.h>

#include <QDialog>
#include <QTableWidgetItem>
#include <QMenu>
#include <QMessageBox>

#include <core/MIRAPackage.h>
#include <core/Repository.h>
#include <utils/PathFinder.h>

using namespace std;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class PathSelectDialog : public QDialog,
							protected Ui::PathSelectDialog
{
	Q_OBJECT

public:
	PathSelectDialog( PathVector const& paths, QWidget* parent ) :
		QDialog( parent )
	{
		Ui::PathSelectDialog::setupUi(this);
	
		foreach( Path const& path, paths ) {
			QListWidgetItem* item = new QListWidgetItem( QString::fromStdString( path.string() ) );
			item->setSizeHint( QSize(0,30) );
			pathList->addItem( item );
		}
		connect( pathList, SIGNAL( doubleClicked( QModelIndex const& ) ),
			this, SLOT( accept() ) );
	}
	
	void select( Path path )
	{
		select( path.string() );
	}
	
	void select( std::string path )
	{
		QList<QListWidgetItem*> matches = pathList->findItems( QString::fromStdString( path ), Qt::MatchExactly );
		if ( matches.size() == 1 )
			pathList->setCurrentItem( matches[0] );
	}

	~PathSelectDialog()
	{

	}
	
public slots:
	
	virtual void accept()
	{
		if ( pathList->currentItem() ) {
			mSelectedPath = pathList->currentItem()->text().toStdString();
			QDialog::accept();
		}
	}
	
public:
	std::string mSelectedPath;
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
