#!/bin/bash

###############################################################################

if [ $# != 2 ]; then
	echo "Usage: $0 export.mpe miraProjectPath"
	exit
fi

###############################################################################

confirm()
{
	echo -n "$1 ? (n) "
	read ans
	case "$ans" in
	y|Y|yes|YES|Yes) return 0 ;;
	*) return 1 ;;
	esac
}

###############################################################################

p=`xml_grep --text_only '/root/database/Packages/subPackages/item/name' $1`

echo "Packages from $1 :"
for pp in $p ; do echo "    $pp"; done
echo ""

if confirm "Import this packages to $2 " ; then
	mirapackage --debug -P $2 -I $p
fi

