/*
 * Copyright (C) 2017 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file EditorPartAction.h
 *    Description.
 *
 * @author Christof Schröter
 * @date   2017/05/14
 */

#ifndef _MIRA_MIRACENTER_CREATEVIEWDIALOG_H_
#define _MIRA_MIRACENTER_CREATEVIEWDIALOG_H_

#include<QPushButton>

#include <factory/Class.h>
#include <widgets/SelectionListDialog.h>
#include <rcp/WorkbenchPart.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class CreateViewDialog : public SelectionListDialog<ClassProxy>
{
	Q_OBJECT

	typedef SelectionListDialog<ClassProxy> Base;

public:
	CreateViewDialog(QWidget* parent=0)  : Base(parent)
	{
		mRestoreButton = mButtonBox->addButton("Restore Last Closed", QDialogButtonBox::ActionRole);
		mRestoreButton->setCheckable(true);
		mRestoreButton->setEnabled(false);

		connect(mTreeWidget, SIGNAL(itemSelectionChanged()),
		        this, SLOT(selectionChanged()));
	}

	virtual ~CreateViewDialog() {}

public:

	bool restoreIsChecked() { return mRestoreButton->isEnabled() && mRestoreButton->isChecked(); }  

	void populateViewList()
	{
		// query all view classes from the class factory:
		typedef std::map<std::string, ClassProxy > ClassMap;
		ClassMap viewClasses = WorkbenchPart::CLASS().getDerivedClasses( );

		foreach(ClassMap::value_type i, viewClasses)
		{
			if(i.second.isAbstract())
				continue;

			std::string name = i.second.getMetaInfo("Name");
			if(name.empty())
				name = i.first; // use class name, if no meta name was specified

			std::string category = i.second.getMetaInfo("Category");
			if(category.empty())
				category = "General"; // use default category


			QStringList labels;
			labels << name.c_str() << i.second.getMetaInfo("Description").c_str();
			addItem(category.c_str(), labels, i.second);
		}
	}

	void setMemorizedClasses(const std::list<std::string>& classes)
	{
		mPartMemoryClasses = classes;
	}

protected slots:

	void selectionChanged()
	{
		std::list<std::pair<QString, ClassProxy>> selected = selectedItems();
		foreach (auto s, selected) {
			auto it = std::find(mPartMemoryClasses.begin(),
			                    mPartMemoryClasses.end(),
			                    s.second.getIdentifier());
			if (it != mPartMemoryClasses.end()) {
				mRestoreButton->setEnabled(true);
				return;
			}
		}
		mRestoreButton->setEnabled(false);
	}

protected:

	QPushButton* mRestoreButton;
	std::list<std::string> mPartMemoryClasses;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
