/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RPCView.h
 *    TODO Add description.
 *
 * @author tim
 * @date   15.05.2011
 */

#ifndef _MIRA_RPCVIEW_H_
#define _MIRA_RPCVIEW_H_

#include <serialization/adapters/std/map>
#include <fw/Framework.h>
#include <rcp/ViewPart.h>
#include <widgets/TextEditAutoCompletion.h>
#include <QPushButton>
#include <QLineEdit>
#include <QTextEdit>
#include <QTreeWidget>
#include <QTableWidget>
#include <QTimer>
#include <serialization/adapters/Qt/QStringList>

namespace mira
{

///////////////////////////////////////////////////////////////////////////////

class RPCView : public ViewPart
{
MIRA_META_OBJECT(RPCView,
				("Name", "RPC View")
				("Description", "View for browsing RPC calls and executing them"))
Q_OBJECT
public:
	RPCView();

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("Method", method, "");
		r.member("Params", params, "");
		r.member("History", history, "");
		r.member("CustomEntries", customEntries, "");
		r.property("ShowHidden", showHidden, "Should hidden services be displayed", false);
	}

	virtual Qt::DockWidgetArea getDefaultDockArea() const {
		return Qt::BottomDockWidgetArea;
	}

protected slots:

	void onShowHidden(bool show);

protected:

	virtual QWidget* createPartControl();

public:

	std::string method;
	std::string params;
	std::map<std::string, std::string> customEntries;
	QStringList history;
	bool showHidden;

private:

	class UI;
	UI* ui;
};

class RPCView::UI : public QWidget
{
	Q_OBJECT
public:

	UI(RPCView* parent);

	void updateServices();

public slots:

	void onCall();
	void onMethodClicked(QTreeWidgetItem* item, int c);
	void onShowContextMenu(const QPoint& p);
	void onRemoveCustomMethod();
	void onCallCustomMethod();

protected:

	virtual void timerEvent(QTimerEvent *e);
	std::string generateRequest(const std::string& service, const std::string& params);
	int findButton(int column);
	void addCustomMethod(const std::string& service, const std::string& params);
	void addCustomMethod(QTreeWidgetItem* item);

public:

	RPCView* rpcView;
	QTreeWidget* serviceList;
	QLineEdit* serviceName;
	QCompleter* completer;
	TextEditAutoCompletion* serviceParams;
	QPushButton* callBtn;
	QTextEdit* answer;

	QTableWidget* customServices;
	QTextEdit* customAnswer;
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
