/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LibrariesListView.h
 *    Shows a list of all registered libraries.
 *
 * @author Christof Schröter
 * @date   2020/10/05
 */

#ifndef _MIRA_LIBRARIESLISTVIEW_H_
#define _MIRA_LIBRARIESLISTVIEW_H_

#include <QTreeWidget>
#include <QTimerEvent>

#include <serialization/adapters/Qt/QAction>

#include <rcp/EditorPart.h>

#include <fw/ServiceSelectorBox.h>
#include <widgets/TreeViewFilter.h>

#include <factory/LibraryRegistry.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class LibrariesListView : public mira::EditorPart
{
	Q_OBJECT;
	MIRA_META_OBJECT(LibrariesListView,
	                ("Category", "Information")
	                ("Name", "Libraries List")
	                ("Description", "Shows list of all registered libraries and their status."))

public:
	LibrariesListView();
	virtual ~LibrariesListView();

public:
	template <typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, EditorPart);
		r.property("Auto-hide service selector",
		           getter<bool>(boost::bind(actionGetter, mAutoHideServiceSelector)),
		           setter<bool>(boost::bind(actionSetter, mAutoHideServiceSelector, _1)),
		           "", true);

		r.property("Show loaded libs only",
		           getter<bool>(boost::bind(actionGetter, mShowLoadedOnly)),
		           setter<bool>(boost::bind(actionSetter, mShowLoadedOnly, _1)),
		           "", false);
	}

protected:
	virtual QWidget* createPartControl();
	virtual void timerEvent(QTimerEvent* event);

private:
	void updateLibraries();
	void updateDisplay(const std::string& service);

private slots:
	void onShowLoadedOnly(bool loaded);
	void serviceSelected(const std::string& service);

private:
	QAction* mAutoHideServiceSelector;
	QAction* mShowLoadedOnly;

	std::map<std::string, LibraryRegistry::Register> mRegistries;
	boost::mutex mDataMutex;
	boost::thread mDataWorkerThread;

	ServiceSelectorBox* mServiceBox;
	boost::mutex mServiceMutex;

	TreeViewFilter* mFilter;
	QTreeWidget* mLibrariesView;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
