/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file BasicGoalTool.C
 *    Tool plugin for miracenter to send a robot to a goal using the 
 *    INavigation service interface.
 *
 * @author Erik Einhorn
 * @date   2011/07/02
 */

#include <QtGui/QMouseEvent>

#include <fw/ServiceProperty.h>

#include <visualization/3d/PoseTool.h>

#include <navigation/tasks/OrientationTask.h>
#include <navigation/tasks/PositionTask.h>
#include <navigation/tasks/PreferredDirectionTask.h>

namespace mira { namespace navigation {

///////////////////////////////////////////////////////////////////////////////

/**
 * Tool plugin for miracenter to send a robot to a goal using the
 * INavigation service interface.
 */
class BasicGoalTool : public PoseTool
{
	MIRA_META_OBJECT(BasicGoalTool,
		("Name", "Goal")
		("Category", "Navigation")
		("Description", "Set navigation goal")
		("Default", "true")
		("Order", "200"))

public:

	BasicGoalTool() :
		mNavigationService("INavigation")
	{
		mBaseTask = "{\"SubTasks\" : [ { \"@class\" : \"mira::navigation::PreferredDirectionTask\", \"Direction\" : 1, \"WrongDirectionCost\" : 0.5 } ] }";
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, PoseTool);
		r.property("NavigationService", mNavigationService, "Service used for sending task to",
		           "");
		r.property("BaseTask", mBaseTask,
		           "The task where only the PositionTask and OrientationTask is added as subtask");
	}
	/** @name Implementation of VisualizationTool */
	//@{

	virtual QIcon getIcon();

	//@}

protected:
	/** @name Implementation of PoseTool */
	//@{

	/// new pose is set as goal pose
	virtual void onNewPose(const PoseCov2& pose);

	/// right button click sends NULL task, i.e. stops current task
	virtual void onMousePressed(QMouseEvent* e);

	//@}

	std::string mBaseTask;
	ServiceProperty mNavigationService;
};

///////////////////////////////////////////////////////////////////////////////

}}
