/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <serialization/BinarySerializer.h>
#include <image/Img.h>
#include <image/Color.h>

#include <opencv2/highgui/highgui.hpp>

#include <codec/JpegCodec.h>
#include <codec/PngCodec.h>
#include <codec/Z11Codec.h>
#include <codec/Z16TableCodec.h>

using namespace mira;
using namespace mira::codec;

void test1()
{
	Img<uint16,1> img(640,480);
	img.clear();

	for(int y=0; y<img.height(); ++y)
	{
		for(int x=0; x<img.width(); ++x)
			img(x,y) = (x * 3) % 1024;
	}

	Img8U1 t = Img8U1::convertFrom(img);
	cv::imshow("test1_img", t);


	{
		Buffer<uint8> buf;
		BinaryBufferSerializer s(&buf);
		s.serialize(img);
		std::cout << "Test1: Size without codec: " << buf.size() << std::endl;

		//BinaryBufferDeserializer d(&buf);
		//Img8U3 img2;
		//d.deserialize(img2);
	}

	{
		Buffer<uint8> buf;
		BinaryBufferSerializer s(&buf);
		s.registerCodec(BinarySerializerCodecPtr(new Z16TableCodec()));

		s.serialize(img);
		std::cout << "Test1: Size with Z16TableCodec: " << buf.size() << std::endl;

		BinaryBufferDeserializer d(&buf);
		Img<uint16,1> img3(640,480);
		d.deserialize(img3);

		std::cout <<"Test1: Deserialized Images equal each other: "<<
				(img3 == img) << std::endl;
		/*for(int y=0; y<img.height(); ++y)
			for(int x=0; x<img.height(); ++x)
				if(img3(x,y)!=img(x,y))
					std::cout << "("<<x<<","<<y<<"): "<< img3(x,y) << " vs " << img(x,y) << std::endl;
		 */

		Img8U1 t = Img8U1::convertFrom(img3);
		cv::imshow("test1_decoded_img", t);
	}
}


int s = 500;
void test2()
{
	Img16U1 img(s,1);
	for(int x=0; x<img.width(); ++x)
		img(x,0) = 	(x*x)%2000;

	{
		Buffer<uint8> buf;
		BinaryBufferSerializer s(&buf);
		s.serialize(img);
		std::cout << "Test2: Size without codec: " << buf.size() << std::endl;
	}

	{
		Buffer<uint8> buf;
		BinaryBufferSerializer s(&buf);
		s.registerCodec(BinarySerializerCodecPtr(new Z11Codec()));

		s.serialize(img);
		std::cout << "Test2: Size with Z11Codec: " << buf.size() << std::endl;

		BinaryBufferDeserializer d(&buf);
		Img16U1 img3(640,1);
		d.deserialize(img3);

		std::cout << "Test2: Deserialized Images equal each other: "<<
				(img3 == img) << std::endl;

		Img8U1 t = Img8U1::convertFrom(img3);
		cv::imshow("test2_decoded_img", t);
	}

}

void test3()
{
	Img16U1 img(s,1);
	for(int x=0; x<img.width(); ++x)
		img(x,0) = (x*x)%2000;

	{
		Buffer<uint8> buf;
		BinaryBufferSerializer s(&buf);
		s.serialize(img);
		std::cout << "Test3: Size without codec: " << buf.size() << std::endl;
	}

	{
		Buffer<uint8> buf;
		BinaryBufferSerializer s(&buf);
		s.registerCodec(BinarySerializerCodecPtr(new Z16TableCodec()));

		s.serialize(img);
		std::cout << "Test3: Size with Z16TableCodec: " << buf.size() << std::endl;

		BinaryBufferDeserializer d(&buf);
		Img16U1 img3(640,1);
		d.deserialize(img3);

		std::cout << "Test3: Deserialized Images equal each other: "<<
				(img3 == img) << std::endl;

		Img8U1 t = Img8U1::convertFrom(img3);
		cv::imshow("test3_decoded_img", t);
	}

}


int main()
{
	test1();
	test2();
	test3();
	cv::waitKey();
	return 0;
}
