#!/bin/bash

# The following functions are provided for old bash versions that do not 
# provide the _get_comp_words_by_ref function. It is based on code from:
#
#   bash_completion - programmable completion functions for bash 3.2+
#
#   Copyright © 2006-2008, Ian Macdonald <ian@caliban.org>
#             © 2009-2010, Bash Completion Maintainers
#                     <bash-completion-devel@lists.alioth.debian.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software Foundation,
#   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#   The latest version of this software can be obtained here:
#
#   http://bash-completion.alioth.debian.org/
#
#   RELEASE: 2.x
_mira_reassemble_comp_words_by_ref()
{
	local exclude i j first
	# Which word separators to exclude?
	exclude="${1//[^$COMP_WORDBREAKS]}"
	cword_=$COMP_CWORD
	if [ -z "$exclude" ]; then
		words_=("${COMP_WORDS[@]}")
		return
	fi
	# List of word completion separators has shrunk;
	# re-assemble words to complete.
	for ((i=0, j=0; i < ${#COMP_WORDS[@]}; i++, j++)); do
		# Append each nonempty word consisting of just
		# word separator characters to the current word.
		first=t
		while
			[ $i -gt 0 ] &&
			[ -n "${COMP_WORDS[$i]}" ] &&
			# word consists of excluded word separators
			[ "${COMP_WORDS[$i]//[^$exclude]}" = "${COMP_WORDS[$i]}" ]
		do
			# Attach to the previous token,
			# unless the previous token is the command name.
			if [ $j -ge 2 ] && [ -n "$first" ]; then
				((j--))
			fi
			first=
			words_[$j]=${words_[j]}${COMP_WORDS[i]}
			if [ $i = $COMP_CWORD ]; then
				cword_=$j
			fi
			if (($i < ${#COMP_WORDS[@]} - 1)); then
				((i++))
			else
				# Done.
				return
			fi
		done
		words_[$j]=${words_[j]}${COMP_WORDS[i]}
		if [ $i = $COMP_CWORD ]; then
			cword_=$j
		fi
	done
}

# use our version of _get_comp_words_by_ref only, if the function does not exist yet!
if ! type _get_comp_words_by_ref >/dev/null 2>&1; then
unset _get_comp_words_by_ref
if [[ -z ${ZSH_VERSION:+set} ]]; then
_get_comp_words_by_ref ()
{
	local exclude cur_ words_ cword_
	if [ "$1" = "-n" ]; then
		exclude=$2
		shift 2
	fi
	_mira_reassemble_comp_words_by_ref "$exclude"
	cur_=${words_[cword_]}
	while [ $# -gt 0 ]; do
		case "$1" in
		cur)
			cur=$cur_
			;;
		prev)
			prev=${words_[$cword_-1]}
			;;
		words)
			words=("${words_[@]}")
			;;
		cword)
			cword=$cword_
			;;
		esac
		shift
	done
}
else
_get_comp_words_by_ref ()
{
	while [ $# -gt 0 ]; do
		case "$1" in
		cur)
			cur=${COMP_WORDS[COMP_CWORD]}
			;;
		prev)
			prev=${COMP_WORDS[COMP_CWORD-1]}
			;;
		words)
			words=("${COMP_WORDS[@]}")
			;;
		cword)
			cword=$COMP_CWORD
			;;
		-n)
			# assume COMP_WORDBREAKS is already set sanely
			shift
			;;
		esac
		shift
	done
}
fi
fi

function _mira_ltrim_colon_completions
{
	# If word-to-complete contains a colon,
	# and bash-version < 4,
	# or bash-version >= 4 and COMP_WORDBREAKS contains a colon
	if [[
		"$1" == *:* && (
		    ${BASH_VERSINFO[0]} -lt 4 || 
		    (${BASH_VERSINFO[0]} -ge 4 && "$COMP_WORDBREAKS" == *:*) 
		)
	]]; then
		# Remove colon-word prefix from COMPREPLY items
		local colon_word=${1%${1##*:}}
		local i=${#COMPREPLY[*]}
		while [ $((--i)) -ge 0 ]; do
			COMPREPLY[$i]=${COMPREPLY[$i]#"$colon_word"}
		done
	fi
} # _mira_ltrim_colon_completions()


function _mira_ltrim
{
	# Remove colon-word prefix from COMPREPLY items
	local colon_word=${1}
	local i=${#COMPREPLY[*]}
	while [ $((--i)) -ge 0 ]; do
		COMPREPLY[$i]=${COMPREPLY[$i]#"$colon_word"}
	done
}

function _mira_completion
{
	local cur
	_get_comp_words_by_ref -n : cur

	_mira_split_path ${cur}
	local splitRes=$?

	wordlist=$($1 ${splitRes})
	IFS=$'\n'

	#if [[ "$splitRes" == 0 ]] ; then
	#	compopt -o filenames
	#else
	#	compopt +o filenames
	#fi

	COMPREPLY=($(compgen -P "${_mira_split_path_var[2]}" -W "${wordlist}" -- "${_mira_split_path_var[3]}") )
	unset IFS

	_mira_ltrim_colon_completions "${cur}"
}

################################################################################

function _miracomplete_packages {
	local rdir="${_mira_split_path_var[1]}"
	if [ -z ${rdir} ]; then
		bash $_mirafindpkg | awk -- '{print $1":"}' 
		rdir="."
	fi
}

################################################################################

function _miracomplete_subdirsproc {
	case "$1" in
	0) _miracomplete_packages;;
	1) ;;
	2) #find subdirs and remove the trailing slash
		find -L "${_mira_split_path_var[5]}/${_mira_split_path_var[1]}" -maxdepth 1 -mindepth 1 -type d ! -regex ".*/[.].*" -print0 2>/dev/null | tr '\000' '\n' | sed -e "s/.*\/\(.*\)/\1\//g"
	;;
	esac
}

function _miracomplete_subdirs {
	_mira_completion _miracomplete_subdirsproc
}

################################################################################

function _miracomplete_pkgandfilesproc
{
	local splitRes=$1
	case "$splitRes" in
	0)  #package list
		local rdir="${_mira_split_path_var[1]}"
		if [ -z ${rdir} ]; then
			bash $_mirafindpkg | awk -- '{print $1":"}' 
			rdir="."
		fi
		#subdirs
		find -L "${rdir}" -maxdepth 1 -mindepth 1 -type d ! -regex ".*/[.].*" -print0 2>/dev/null | tr '\000' '\n' | sed -e "s/.*\/\(.*\)/\1\//g"
		#find files
		find -L "${rdir}" -maxdepth 1 -mindepth 1 -type f ! -regex ".*/[.].*" -print0 2>/dev/null | tr '\000' '\n' | sed -e "s/.*\/\(.*\)/\1/g"
	;;
	1)
	;;
	2)  #find subdirs and remove the trailing slash
		find -L "${_mira_split_path_var[5]}/${_mira_split_path_var[1]}" -maxdepth 1 -mindepth 1 -type d ! -regex ".*/[.].*" -print0 2>/dev/null | tr '\000' '\n' | sed -e "s/.*\/\(.*\)/\1\//g"
		#find files
		find -L "${_mira_split_path_var[5]}/${_mira_split_path_var[1]}" -maxdepth 1 -mindepth 1 -type f ! -regex ".*/[.].*" -print0 2>/dev/null | tr '\000' '\n' | sed -e "s/.*\/\(.*\)/\1/g"
	;;
	esac
}

function _miracomplete_pkgandfiles
{
	_mira_completion _miracomplete_pkgandfilesproc
}

################################################################################
