set(CTEST_SITE "$ENV{HOSTNAME}")
set(CTEST_PROJECT_NAME "MIRA")
set(CTEST_BUILD_NAME "Nightly")
set(CTEST_NIGHTLY_START_TIME "01:00:00 UTC")
set(CTEST_CMAKE_GENERATOR "Unix Makefiles")
set(CTEST_BUILD_CONFIGURATION "Release")
set(MODEL "Nightly")
set_property(GLOBAL PROPERTY SubProject Basics)

set(REPOSITORY_URL "https://www.mira-project.org/svn/MIRA")

###############################################################################
# Setup build environment
###############################################################################

set(PARALLEL_MAKE_JOBS "-j1")
set(FIRST_BUILD_TARGET "coverage")
set(MIRA_BUILD_COMMAND "make")
set(SECOND_BUILD_TARGET "release")
set(SCP_PKG_TARGET "USER@HOST:PATH")
set(SCP_DOC_TARGET "USER@HOST:PATH")

find_package(Subversion)
find_program(CTEST_COVERAGE_COMMAND NAMES gcov)
find_program(CTEST_COMMAND NAMES ctest)
find_program(MAKE_COMMAND NAMES make)

set(CTEST_SOURCE_DIRECTORY   "${CTEST_SCRIPT_DIRECTORY}")
set(CTEST_BINARY_DIRECTORY "${CTEST_SCRIPT_DIRECTORY}/build")
set(CTEST_COSCRIPT_DIRECTORY "${CTEST_SCRIPT_DIRECTORY}")
set(CTEST_UPDATE_COMMAND     ${Subversion_SVN_EXECUTABLE})
set(CTEST_CHECKOUT_COMMAND   "${Subversion_SVN_EXECUTABLE} co https://www.mira-project.org/svn/MIRA/trunk ${CTEST_SOURCE_DIRECTORY}")

file(TO_NATIVE_PATH ${CTEST_SOURCE_DIRECTORY} NATIVE_SOURCE_DIRECTORY)

set( ENV{MIRA_ROOT_DIR} ${NATIVE_SOURCE_DIRECTORY} )
set( ENV{MIRA_PATH} $ENV{MIRA_ROOT_DIR} )

set(PROJECT_SOURCE_DIR "${CTEST_SOURCE_DIRECTORY}")
set( ENV{LD_LIBRARY_PATH} "$ENV{LD_LIBRARY_PATH}:$ENV{MIRA_ROOT_DIR}/lib" )
message("LD_LIBRARY_PATH: $ENV{LD_LIBRARY_PATH}")

message("MIRA_ROOT_DIR:           $ENV{MIRA_ROOT_DIR}")
message("MIRA_PATH:               $ENV{MIRA_PATH}")
message("CTEST_SOURCE_DIRECTORY: ${CTEST_SOURCE_DIRECTORY}")

###############################################################################
# Setup Dashboard dropping
###############################################################################

if(NOT DEFINED CTEST_DROP_METHOD)
	set(CTEST_DROP_METHOD "http")
endif()

if(CTEST_DROP_METHOD STREQUAL "http")
	SET(CTEST_DROP_SITE "www.mira-project.org")
	SET(CTEST_DROP_LOCATION
		"/MIRA_cdash/submit.php?project=${CTEST_PROJECT_NAME}")
	SET(CTEST_DROP_BUILD_LOCATION
		"/MIRA_cdash/uploadbuild.php?project=${CTEST_PROJECT_NAME}")
	SET(CTEST_TRIGGER_SITE "")
	SET(CTEST_DROP_SITE_CDASH TRUE)
endif()

###############################################################################
# Start building, testing and upload
###############################################################################

set(CTEST_BINARY_DIRECTORY "${CTEST_SCRIPT_DIRECTORY}/build/${FIRST_BUILD_TARGET}")
set(CTEST_TEST_DIRECTORY "${CTEST_SCRIPT_DIRECTORY}/build/${FIRST_BUILD_TARGET}")
set(CTEST_BUILD_COMMAND "make ${PARALLEL_MAKE_JOBS} ${FIRST_BUILD_TARGET}")

# do the first build (with checkout) and submit results
ctest_start(${MODEL})
ctest_update(SOURCE "${CTEST_SOURCE_DIRECTORY}")
ctest_build(BUILD "${CTEST_SOURCE_DIRECTORY}")
ctest_test(BUILD "${CTEST_TEST_DIRECTORY}")
ctest_coverage(BUILD "${CTEST_TEST_DIRECTORY}")
ctest_submit()

# do the second build
set(CTEST_BINARY_DIRECTORY "${CTEST_SCRIPT_DIRECTORY}/build/${SECOND_BUILD_TARGET}")
set(CTEST_TEST_DIRECTORY "${CTEST_SCRIPT_DIRECTORY}/build/${SECOND_BUILD_TARGET}")
set(CTEST_BUILD_COMMAND "make ${PARALLEL_MAKE_JOBS} ${SECOND_BUILD_TARGET}")

ctest_build(BUILD "${CTEST_SOURCE_DIRECTORY}")

# install to obtain student version
EXECUTE_PROCESS(COMMAND "${MAKE_COMMAND}" "DESTDIR=${CTEST_SOURCE_DIRECTORY}/Student" "install_${SECOND_BUILD_TARGET}"
	WORKING_DIRECTORY ${CTEST_SOURCE_DIRECTORY}
	OUTPUT_VARIABLE makeInstallLog
	ERROR_VARIABLE makeInstallLog)
FILE(WRITE ${CTEST_BINARY_DIRECTORY}/Testing/makeinstall.log "${makeInstallLog}")

# build the documentation
EXECUTE_PROCESS(COMMAND "make" "doc_release"
	WORKING_DIRECTORY "${CTEST_SOURCE_DIRECTORY}"
	OUTPUT_VARIABLE docLog
	ERROR_VARIABLE docLog)
FILE(WRITE ${CTEST_BINARY_DIRECTORY}/Testing/makeDoc.log "${docLog}")

# find out the revision number
EXECUTE_PROCESS(COMMAND "${Subversion_SVN_EXECUTABLE}" "info"
	OUTPUT_VARIABLE SVN_REVISION)
STRING(REGEX REPLACE ".*Rev: ([^\n]+).*" "\\1" SVN_REVISION "${SVN_REVISION}")

# add revision number to last build
FILE(WRITE ${CTEST_SOURCE_DIRECTORY}/Student/opt/MIRA/Revision.txt "${SVN_REVISION}")

# make compressed student version
EXECUTE_PROCESS(COMMAND "tar" "cfvz" "MIRA-${SVN_REVISION}.tgz" "."
	WORKING_DIRECTORY "${CTEST_SOURCE_DIRECTORY}/Student/opt"
	OUTPUT_VARIABLE tarLog
	ERROR_VARIABLE tarLog)
FILE(WRITE ${CTEST_BINARY_DIRECTORY}/Testing/createTar.log "${tarLog}")

# compress the documentation
EXECUTE_PROCESS(COMMAND "tar" "cfvz" "MIRA-Documentation.tgz" "doc"
	WORKING_DIRECTORY "${CTEST_SOURCE_DIRECTORY}/build"
	OUTPUT_VARIABLE tarDocLog
	ERROR_VARIABLE tarDocLog)
FILE(WRITE ${CTEST_BINARY_DIRECTORY}/Testing/createDocTar.log "${tarDocLog}")

# upload the student version
EXECUTE_PROCESS(COMMAND "scp" "MIRA-${SVN_REVISION}.tgz" ${SCP_PKG_TARGET}
	WORKING_DIRECTORY "${CTEST_SOURCE_DIRECTORY}/Student/opt"
	OUTPUT_VARIABLE scpLog
	ERROR_VARIABLE scpLog)
FILE(WRITE ${CTEST_BINARY_DIRECTORY}/Testing/scp.log "${scpLog}")

# upload the documentation
EXECUTE_PROCESS(COMMAND "scp" "MIRA-Documentation.tgz" ${SCP_DOC_TARGET}
	WORKING_DIRECTORY "${CTEST_SOURCE_DIRECTORY}/build"
	OUTPUT_VARIABLE scpDocLog
	ERROR_VARIABLE scpDocLog)
FILE(WRITE ${CTEST_BINARY_DIRECTORY}/Testing/scpDoc.log "${scpdocLog}")
