<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>Eigen</title>
    <filename>index</filename>
  </compound>
  <compound kind="page">
    <name>CustomizingEigen</name>
    <title>Customizing/Extending Eigen</title>
    <filename>CustomizingEigen</filename>
    <docanchor file="CustomizingEigen">CustomScalarType</docanchor>
    <docanchor file="CustomizingEigen">ExtendingMatrixBase</docanchor>
    <docanchor file="CustomizingEigen">PreprocessorDirectives</docanchor>
  </compound>
  <compound kind="page">
    <name>WrongStackAlignment</name>
    <title>Troubleshooting - Compiler making a wrong assumption on stack alignment</title>
    <filename>WrongStackAlignment</filename>
    <docanchor file="WrongStackAlignment">sec_sol1</docanchor>
    <docanchor file="WrongStackAlignment">sec_sol2</docanchor>
  </compound>
  <compound kind="page">
    <name>Experimental</name>
    <title>Experimental parts of Eigen</title>
    <filename>Experimental</filename>
    <docanchor file="StructHavingEigenMembers">summary</docanchor>
    <docanchor file="Experimental">modules</docanchor>
    <docanchor file="Experimental">core</docanchor>
  </compound>
  <compound kind="page">
    <name>FixedSizeVectorizable</name>
    <title>Fixed-size vectorizable Eigen objects</title>
    <filename>FixedSizeVectorizable</filename>
    <docanchor file="StructHavingEigenMembers">summary</docanchor>
    <docanchor file="UnalignedArrayAssert">explanation</docanchor>
  </compound>
  <compound kind="page">
    <name>InsideEigenExample</name>
    <title>What happens inside Eigen, on a simple example</title>
    <filename>InsideEigenExample</filename>
    <docanchor file="InsideEigenExample">Assignment</docanchor>
    <docanchor file="InsideEigenExample">ConstructingVectors</docanchor>
    <docanchor file="InsideEigenExample">WhyInteresting</docanchor>
    <docanchor file="InsideEigenExample">ConstructionOfSumXpr</docanchor>
  </compound>
  <compound kind="page">
    <name>PassingByValue</name>
    <title>Passing Eigen objects by value to functions</title>
    <filename>PassingByValue</filename>
  </compound>
  <compound kind="page">
    <name>TutorialCore</name>
    <title>Tutorial 1/3 - Core features</title>
    <filename>TutorialCore</filename>
    <docanchor file="TutorialCore">TutorialCoreArithmeticOperators</docanchor>
    <docanchor file="TutorialCore">TutorialCoreTransposeAdjoint</docanchor>
    <docanchor file="TutorialCore">TutorialCoreSimpleExampleFixedSize</docanchor>
    <docanchor file="TutorialCore">TutorialCoreSpecialTopics</docanchor>
    <docanchor file="TutorialCore">TutorialCoreMatrixInitialization</docanchor>
    <docanchor file="TutorialCore">TutorialCoreMatrixTypes</docanchor>
    <docanchor file="TutorialCore">TutorialCoreSimpleExampleDynamicSize</docanchor>
    <docanchor file="TutorialCore">TutorialCoreCoefficients</docanchor>
    <docanchor file="TutorialCore">TutorialMap</docanchor>
    <docanchor file="TutorialCore">TutorialCasting</docanchor>
    <docanchor file="TutorialCore">TutorialCoreReductions</docanchor>
    <docanchor file="TutorialCore">TutorialCoreTriangularMatrix</docanchor>
    <docanchor file="TutorialCore">TutorialCoreGettingStarted</docanchor>
    <docanchor file="TutorialCore">TutorialCoreDotNorm</docanchor>
    <docanchor file="TutorialCore">TutorialCoreMatrixBlocks</docanchor>
    <docanchor file="TutorialCore">TutorialPredefMat</docanchor>
    <docanchor file="TutorialCore">TutorialCommaInit</docanchor>
    <docanchor file="TutorialCore">TutorialCoreDiagonalMatrices</docanchor>
  </compound>
  <compound kind="page">
    <name>StlContainers</name>
    <title>Using STL Containers with Eigen</title>
    <filename>StlContainers</filename>
    <docanchor file="StructHavingEigenMembers">summary</docanchor>
    <docanchor file="StlContainers">vector</docanchor>
    <docanchor file="StlContainers">newvector</docanchor>
    <docanchor file="StlContainers">allocator</docanchor>
  </compound>
  <compound kind="page">
    <name>StructHavingEigenMembers</name>
    <title>Structures Having Eigen Members</title>
    <filename>StructHavingEigenMembers</filename>
    <docanchor file="StructHavingEigenMembers">why</docanchor>
    <docanchor file="StructHavingEigenMembers">bugineigen</docanchor>
    <docanchor file="StructHavingEigenMembers">summary</docanchor>
    <docanchor file="StructHavingEigenMembers">what</docanchor>
    <docanchor file="StructHavingEigenMembers">conditional</docanchor>
    <docanchor file="StructHavingEigenMembers">movetotop</docanchor>
    <docanchor file="StructHavingEigenMembers">dynamicsize</docanchor>
    <docanchor file="StructHavingEigenMembers">how</docanchor>
  </compound>
  <compound kind="page">
    <name>TopicLazyEvaluation</name>
    <title>Lazy Evaluation and Aliasing</title>
    <filename>TopicLazyEvaluation</filename>
  </compound>
  <compound kind="page">
    <name>TutorialGeometry</name>
    <title>Tutorial 2/3 - Geometry</title>
    <filename>TutorialGeometry</filename>
    <docanchor file="TutorialGeometry">TutorialGeoTransform</docanchor>
    <docanchor file="TutorialGeometry">TutorialGeoEulerAngles</docanchor>
    <docanchor file="TutorialGeometry">TutorialGeoElementaryTransformations</docanchor>
    <docanchor file="TutorialGeometry">TutorialGeoCommontransformationAPI</docanchor>
  </compound>
  <compound kind="page">
    <name>TutorialAdvancedLinearAlgebra</name>
    <title>Tutorial 3/3 - Advanced linear algebra</title>
    <filename>TutorialAdvancedLinearAlgebra</filename>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvSolvers</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvSolvers_Symmetric</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvSolvers_SVD</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvSolvers_Inverse</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvQR</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvCholesky</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvEigenProblems</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvLU</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvSolvers_LU</docanchor>
    <docanchor file="TutorialAdvancedLinearAlgebra">TutorialAdvSolvers_Triangular</docanchor>
  </compound>
  <compound kind="page">
    <name>TutorialSparse</name>
    <title>Tutorial - Getting started with the sparse module</title>
    <filename>TutorialSparse</filename>
    <docanchor file="TutorialSparse">TutorialSparseDirectSolvers_LLT</docanchor>
    <docanchor file="TutorialSparse">TutorialSparseFilling</docanchor>
    <docanchor file="TutorialSparse">TutorialSparseFeatureSet</docanchor>
    <docanchor file="TutorialSparse">TutorialSparseDirectSolvers</docanchor>
    <docanchor file="TutorialSparse">TutorialSparseIntro</docanchor>
    <docanchor file="TutorialSparse">TutorialSparseDirectSolvers_LU</docanchor>
    <docanchor file="TutorialSparse">TutorialSparseDirectSolvers_LDLT</docanchor>
  </compound>
  <compound kind="page">
    <name>UnalignedArrayAssert</name>
    <title>Explanation of the assertion on unaligned arrays</title>
    <filename>UnalignedArrayAssert</filename>
    <docanchor file="UnalignedArrayAssert">c1</docanchor>
    <docanchor file="UnalignedArrayAssert">where</docanchor>
    <docanchor file="UnalignedArrayAssert">c2</docanchor>
    <docanchor file="UnalignedArrayAssert">c3</docanchor>
    <docanchor file="UnalignedArrayAssert">explanation</docanchor>
    <docanchor file="UnalignedArrayAssert">c4</docanchor>
    <docanchor file="UnalignedArrayAssert">getrid</docanchor>
  </compound>
  <compound kind="group">
    <name>Array_Module</name>
    <title>Array module</title>
    <filename>group__Array__Module.html</filename>
  </compound>
  <compound kind="group">
    <name>Cholesky_Module</name>
    <title>Cholesky module</title>
    <filename>group__Cholesky__Module.html</filename>
  </compound>
  <compound kind="group">
    <name>Core_Module</name>
    <title>Core module</title>
    <filename>group__Core__Module.html</filename>
    <subgroup>flags</subgroup>
    <subgroup>matrixtypedefs</subgroup>
  </compound>
  <compound kind="group">
    <name>flags</name>
    <title>flags</title>
    <filename>group__flags.html</filename>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>ActualPacketAccessBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>gaafbee24aed0aa204db61f7fce3334329</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>AlignedBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>ga972a2dcb6603215fa53e0b9e82051426</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>DirectAccessBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>ga54c3b872f5a14e7e0d3d6539b704ea67</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>EvalBeforeAssigningBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>gadc8925e67a5a54bd479d6f587112e19a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>EvalBeforeNestingBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>gaf8ad6e2956f7368b8e3f7407e2319e63</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>LinearAccessBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>gab9799bf6feed77fc9fce0136ee55b99c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>LowerTriangularBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>gac61c3fd638e895edd7c3d1e89b5d170b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>PacketAccessBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>gaa780614dc11271c147db56e9c1524e76</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>RowMajorBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>ga7bd49e7b260e869e10fb9dc4fd081a85</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>SelfAdjointBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>gadb6040aad0695de4085f5dc5e641c66f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>SparseBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>ga3c602d309bf5c3f5eba3d972bde5490c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>UnitDiagBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>ga254555b50eae5fa8a8d241f6bc08939a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>UpperTriangularBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>ga2c91e62bfb42e3ac7a6aae2153d2e8dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const unsigned int</type>
      <name>ZeroDiagBit</name>
      <anchorfile>group__flags.html</anchorfile>
      <anchor>gab59e11ef20fc97c063991fc318d2d074</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>matrixtypedefs</name>
    <title>Global matrix typedefs</title>
    <filename>group__matrixtypedefs.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>EIGEN_MAKE_TYPEDEFS_ALL_SIZES</name>
      <anchorfile>group__matrixtypedefs.html</anchorfile>
      <anchor>ga892e22c9b467dd1a68caa783b05d15f5</anchor>
      <arglist>(Type, TypeSuffix)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Geometry_Module</name>
    <title>Geometry module</title>
    <filename>group__Geometry__Module.html</filename>
    <class kind="class">Eigen::AlignedBox</class>
    <class kind="class">Eigen::AngleAxis</class>
    <class kind="class">Eigen::Hyperplane</class>
    <class kind="class">Eigen::ParametrizedLine</class>
    <class kind="class">Eigen::Quaternion</class>
    <class kind="class">Eigen::Rotation2D</class>
    <class kind="class">Eigen::Scaling</class>
    <class kind="class">Eigen::Transform</class>
    <class kind="class">Eigen::Translation</class>
    <member kind="typedef">
      <type>AngleAxis&lt; double &gt;</type>
      <name>AngleAxisd</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga0db1cc067c51aaa6dedf5805ee0c53d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>AngleAxis&lt; float &gt;</type>
      <name>AngleAxisf</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga811d6fdab2002723bc7a72f055ce8c1d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Quaternion&lt; double &gt;</type>
      <name>Quaterniond</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga0d2bd45f1215359f8e7c0d7ab53c4acb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Quaternion&lt; float &gt;</type>
      <name>Quaternionf</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>gaf65cf6f803890e57488d7de750bef682</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Rotation2D&lt; double &gt;</type>
      <name>Rotation2Dd</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga197b898c965d08135ebfb21bf41b23e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Rotation2D&lt; float &gt;</type>
      <name>Rotation2Df</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga9a907f59280ce5650106a74904bab16d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Scaling&lt; double, 2 &gt;</type>
      <name>Scaling2d</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga0bd9ad6cbbd04e19839c3099ec4cc2f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Scaling&lt; float, 2 &gt;</type>
      <name>Scaling2f</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga6dadc39dddd1468c0f43795bd3b3ddc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Scaling&lt; double, 3 &gt;</type>
      <name>Scaling3d</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>gaf3a886c00ace0d612f1c08d1a2ccc5a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Scaling&lt; float, 3 &gt;</type>
      <name>Scaling3f</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga371d61f9b9e65a0c9226df2f84e2b889</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Transform&lt; double, 2 &gt;</type>
      <name>Transform2d</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga50b7384fd223c0bbe68f07f45770e155</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Transform&lt; float, 2 &gt;</type>
      <name>Transform2f</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga286ec38c39d5e356dbfea7d695f09a41</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Transform&lt; double, 3 &gt;</type>
      <name>Transform3d</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga93f2bb4699ee3ff37ff156a9c7a12d7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Transform&lt; float, 3 &gt;</type>
      <name>Transform3f</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>gac2cfea9409b1ac589cc20f259b6189eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Translation&lt; double, 2 &gt;</type>
      <name>Translation2d</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>gaa0b48ef208ba6abeb7f4786b552a3bc4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Translation&lt; float, 2 &gt;</type>
      <name>Translation2f</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga94a8401d6caf6c9688fd14a17297fa20</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Translation&lt; double, 3 &gt;</type>
      <name>Translation3d</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>gac7244ecac036525fb23aad8d3bf3209f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Translation&lt; float, 3 &gt;</type>
      <name>Translation3f</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga53a248891c9ce7fb37ed793cd85eed85</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Matrix&lt; Scalar, 3, 1 &gt;</type>
      <name>eulerAngles</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga087701690bd612a10b0b0c796553f29e</anchor>
      <arglist>(int a0, int a1, int a2) const </arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>LeastSquares_Module</name>
    <title>LeastSquares module</title>
    <filename>group__LeastSquares__Module.html</filename>
    <member kind="function">
      <type>void</type>
      <name>fitHyperplane</name>
      <anchorfile>group__LeastSquares__Module.html</anchorfile>
      <anchor>ga47b8da18a9439013bb1deab804e9a039</anchor>
      <arglist>(int numPoints, VectorType **points, HyperplaneType *result, typename NumTraits&lt; typename VectorType::Scalar &gt;::Real *soundness=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>linearRegression</name>
      <anchorfile>group__LeastSquares__Module.html</anchorfile>
      <anchor>ga9d76a09ff407fb23047fcb8388cdaa5e</anchor>
      <arglist>(int numPoints, VectorType **points, VectorType *result, int funcOfOthers)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>LU_Module</name>
    <title>LU module</title>
    <filename>group__LU__Module.html</filename>
    <class kind="class">Eigen::LU</class>
  </compound>
  <compound kind="group">
    <name>QR_Module</name>
    <title>QR module</title>
    <filename>group__QR__Module.html</filename>
    <class kind="class">Eigen::EigenSolver</class>
    <class kind="class">Eigen::HessenbergDecomposition</class>
    <class kind="class">Eigen::QR</class>
    <class kind="class">Eigen::SelfAdjointEigenSolver</class>
    <class kind="class">Eigen::Tridiagonalization</class>
  </compound>
  <compound kind="group">
    <name>Sparse_Module</name>
    <title>Sparse module</title>
    <filename>group__Sparse__Module.html</filename>
    <class kind="class">Eigen::SparseLDLT</class>
    <class kind="class">Eigen::SparseLLT</class>
    <class kind="class">Eigen::SparseLU</class>
  </compound>
  <compound kind="group">
    <name>SVD_Module</name>
    <title>SVD module</title>
    <filename>group__SVD__Module.html</filename>
    <class kind="class">Eigen::SVD</class>
  </compound>
  <compound kind="class">
    <name>InnerIterator</name>
    <filename>classInnerIterator.html</filename>
  </compound>
  <compound kind="class">
    <name>NumTraits</name>
    <filename>classNumTraits.html</filename>
  </compound>
  <compound kind="class">
    <name>Eigen::aligned_allocator</name>
    <filename>classEigen_1_1aligned__allocator.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>const T *</type>
      <name>const_pointer</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a53d259f0075b22d7646e373816830e8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>const T &amp;</type>
      <name>const_reference</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>af9ba3e25df088c62f7d535b91672cda9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::ptrdiff_t</type>
      <name>difference_type</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>ad319fc54a93a2c7058c70e40428ed2e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T *</type>
      <name>pointer</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a680c78d51cff3fd301666dd75bdbe49d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T &amp;</type>
      <name>reference</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a9b1a63f171d76a7a3995b6858e99f2ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::size_t</type>
      <name>size_type</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a89a6dcafb6130e3e1bcd6d1285e0dd6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a265a253612b46abed17c61b0a5e5ce30</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const_pointer</type>
      <name>address</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a6eff3c9165c84970dc09188446818163</anchor>
      <arglist>(const_reference value) const </arglist>
    </member>
    <member kind="function">
      <type>pointer</type>
      <name>address</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>aff0d032bc4d2f83ad5d851f434e34a21</anchor>
      <arglist>(reference value) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>aligned_allocator</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a46663ec8fb653ddd14811d724eba38ea</anchor>
      <arglist>(const aligned_allocator&lt; U &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>aligned_allocator</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>aee716b3ebb95fd1ec1500dd9fd49eacb</anchor>
      <arglist>(const aligned_allocator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>pointer</type>
      <name>allocate</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a7a9acf6ba6d942837a27f5001b83e682</anchor>
      <arglist>(size_type num, const_pointer *hint=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>construct</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>aa2278ed5efa0b6703c95a4756fb24b8e</anchor>
      <arglist>(pointer p, const T &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deallocate</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a319e54a17444d4df6f9fa3863ef92ecc</anchor>
      <arglist>(pointer p, size_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>destroy</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>aab1823d742973fba3433309bd3ee03f1</anchor>
      <arglist>(pointer p)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>max_size</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a0ab5ce862c0331d9e45a6e1774fca131</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a3ff28d57d1b126fea414bdda3c9787eb</anchor>
      <arglist>(const aligned_allocator&lt; T &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classEigen_1_1aligned__allocator.html</anchorfile>
      <anchor>a12e56506a4b669e532006e61327fd0c8</anchor>
      <arglist>(const aligned_allocator&lt; T &gt; &amp;other) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::AlignedBox</name>
    <filename>classEigen_1_1AlignedBox.html</filename>
    <templarg></templarg>
    <templarg>_AmbientDim</templarg>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, AmbientDimAtCompileTime, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>ad05514d010d3df4bdb8a28accaaed19f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AlignedBox</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a3f25d954e1317ee5d546ceb8474cdf85</anchor>
      <arglist>(const AlignedBox&lt; OtherScalarType, AmbientDimAtCompileTime &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AlignedBox</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a369e732f1a49dd610d16102976cd4a9d</anchor>
      <arglist>(const VectorType &amp;p)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AlignedBox</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a9e07efd97c8e2b8265eca6da204ad97d</anchor>
      <arglist>(const VectorType &amp;_min, const VectorType &amp;_max)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AlignedBox</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>acf2c6febba404c8a407466aaf692beec</anchor>
      <arglist>(int _dim)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AlignedBox</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a65c24247d90726cff7b91048a3d2a053</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; AlignedBox, AlignedBox&lt; NewScalarType, AmbientDimAtCompileTime &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>aca6ba6503be022a37bda129e7e5eaa9e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>AlignedBox &amp;</type>
      <name>clamp</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a254af66a9538bf46354a04bc557c4771</anchor>
      <arglist>(const AlignedBox &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a3a808a7b2d30081b831718fe8045299d</anchor>
      <arglist>(const AlignedBox &amp;b) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a63f3a65c330c66f7d46ee13a8fc75d53</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dim</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a57840c996d92c9162995c5fbd8ab1bd1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>AlignedBox &amp;</type>
      <name>extend</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>ae25d7d20ec0b045b21b26be1cfb14dad</anchor>
      <arglist>(const AlignedBox &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>AlignedBox &amp;</type>
      <name>extend</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a933a2f28d3747de2ea7a63f3d6d18614</anchor>
      <arglist>(const VectorType &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>exteriorDistance</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a155c07a3f5812452e44c914a33629aed</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a942ec9c4da7c68a9d72f517e62a26324</anchor>
      <arglist>(const AlignedBox &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>ac02f2a4d7312eb91f40980adfd4e31b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>VectorType &amp;</type>
      <name>max</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>adefeef169aec1860e1f6918593d0c296</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const VectorType &amp;</type>
      <name>max</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a72c2ab7065f7394b45d38e192fb6f2ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>VectorType &amp;</type>
      <name>min</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a23a3edd4a99d06d6c99a025cff635d3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const VectorType &amp;</type>
      <name>min</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a805182ddc71f58c6e56886a6354c3c13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNull</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>a91e28e1274cd18a6413c67bf55356cf6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>squaredExteriorDistance</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>ae74b0271d54dd534bbfa37a2cc6a714c</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>AlignedBox &amp;</type>
      <name>translate</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>afba1b1a8c99ea5ed6f52a0194224e5ed</anchor>
      <arglist>(const VectorType &amp;t)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorType</type>
      <name>m_max</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>af3069f5819827486d88d5d2336bc031c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorType</type>
      <name>m_min</name>
      <anchorfile>classEigen_1_1AlignedBox.html</anchorfile>
      <anchor>af705ee8f7c68b80b2541e8076fde90cf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::AmbiVector::Iterator</name>
    <filename>classEigen_1_1AmbiVector_1_1Iterator.html</filename>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>index</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>ad9c88ed5e8125d66291acd55da72d73e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Iterator</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>a06899a42214bf9ab47fa03faf5959fa0</anchor>
      <arglist>(const AmbiVector &amp;vec, RealScalar epsilon=RealScalar(0.1)*precision&lt; RealScalar &gt;())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>aa385aa18f5e42db5a415c25a90f4193d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator++</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>aef12ef33726bc591f569f822c7b5ac41</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>value</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>a1c122f08d161f2f760caef5ff8b5981e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_cachedIndex</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>af43ea1d4ef07a8ed1200a044cbceaf69</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Scalar</type>
      <name>m_cachedValue</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>a89fcc910171691e3ce429440314e06d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_currentEl</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>a185bc6aff3b06c908bc5635612c38cb7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>RealScalar</type>
      <name>m_epsilon</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>af46fb8f8ff562bce34972d7dddfaee03</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_isDense</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>ab3f1c6ef1ea83c3efa521e6b3ac9589a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const AmbiVector &amp;</type>
      <name>m_vector</name>
      <anchorfile>classEigen_1_1AmbiVector_1_1Iterator.html</anchorfile>
      <anchor>a28d8f4dc27975889aa9209d956e1d6ae</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::AngleAxis</name>
    <filename>classEigen_1_1AngleAxis.html</filename>
    <templarg>_Scalar</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, 3, 3 &gt;</type>
      <name>Matrix3</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>abdb0743d0fe840b927780b2bd78fb29e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Quaternion&lt; Scalar &gt;</type>
      <name>QuaternionType</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>aacc9b6877c8bde7e1d4b36cc326c7aad</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, 3, 1 &gt;</type>
      <name>Vector3</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>ab05eeebdd63f50a52fecb6353018075f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>angle</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a83ab19e0cf6095c27248a0136d521172</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>angle</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a0779e44b0f389bec959428f203bc766e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AngleAxis</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a943d4279c4b0252c10b179bbb048e0d5</anchor>
      <arglist>(const AngleAxis&lt; OtherScalarType &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AngleAxis</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a17d2b561494dd30705fb4d0a3e6b5b46</anchor>
      <arglist>(const MatrixBase&lt; Derived &gt; &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AngleAxis</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a6ac4a27e5273a8dfd279a2c6a8439f3e</anchor>
      <arglist>(const QuaternionType &amp;q)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AngleAxis</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a7ebaf9cfb7892f6f9d0700c5347c5ffa</anchor>
      <arglist>(Scalar angle, const MatrixBase&lt; Derived &gt; &amp;axis)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AngleAxis</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a38772216b8d784ddbe99d2d3df961f32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Vector3 &amp;</type>
      <name>axis</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a8708c64763305e497f560b38262946f9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Vector3 &amp;</type>
      <name>axis</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>ad8d7e852f852855f633594d24871a03c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; AngleAxis, AngleAxis&lt; NewScalarType &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>ad4c7ad22e3d19e932437582687e34eaf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>AngleAxis &amp;</type>
      <name>fromRotationMatrix</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a56ca41967f3fc25ce40091f418745176</anchor>
      <arglist>(const MatrixBase&lt; Derived &gt; &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>AngleAxis</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a68dbca4080079a7376bc8d6cfd8fe098</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a21ff7f0391a3bd0c16b352aa447cd4fb</anchor>
      <arglist>(const AngleAxis &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>Vector3</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>ae758834568a642c3cbaab7e0274c9dff</anchor>
      <arglist>(const Vector3 &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Matrix3</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a32c18a54074a0ffbe42a71869c76a053</anchor>
      <arglist>(const Matrix3 &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>QuaternionType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a83533759bf90b1514c756cd538101736</anchor>
      <arglist>(const QuaternionType &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>QuaternionType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>afbaeb13e13184d381a9e443166fc66b8</anchor>
      <arglist>(const AngleAxis &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>AngleAxis &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a46e6ab00ede75ef721258866b3ee3b87</anchor>
      <arglist>(const MatrixBase&lt; Derived &gt; &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>AngleAxis &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a88b360d36ae2f9d3f08d0b787908ba78</anchor>
      <arglist>(const QuaternionType &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>Matrix3</type>
      <name>toRotationMatrix</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a34adf4403bbc909c67309fbc7b6dbc16</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Scalar</type>
      <name>m_angle</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a9c61016039e020fdd4c952e798e49394</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Vector3</type>
      <name>m_axis</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a8e83488497708b141393740464f9aa19</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend Matrix3</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>a7b353e051be8f249adfa550865415e15</anchor>
      <arglist>(const Matrix3 &amp;a, const AngleAxis &amp;b)</arglist>
    </member>
    <member kind="friend">
      <type>friend QuaternionType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1AngleAxis.html</anchorfile>
      <anchor>acdec7200dd68b70b615bcda9659fed26</anchor>
      <arglist>(const QuaternionType &amp;a, const AngleAxis &amp;b)</arglist>
    </member>
    <docanchor file="classEigen_1_1AngleAxis">AngleAxisForEuler</docanchor>
  </compound>
  <compound kind="class">
    <name>Eigen::Block</name>
    <filename>classEigen_1_1Block.html</filename>
    <templarg></templarg>
    <templarg>BlockRows</templarg>
    <templarg>BlockCols</templarg>
    <templarg>PacketAccess</templarg>
    <templarg>_DirectAccessStatus</templarg>
    <member kind="function">
      <type></type>
      <name>Block</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a794de8c41557609e076b3d57feedb0ca</anchor>
      <arglist>(const MatrixType &amp;matrix, int startRow, int startCol, int blockRows, int blockCols)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Block</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a33572851dfd1cca80c75fc56798d5113</anchor>
      <arglist>(const MatrixType &amp;matrix, int startRow, int startCol)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Block</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a6c7c1d6354a8b82b986d859022cf38ad</anchor>
      <arglist>(const MatrixType &amp;matrix, int i)</arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>ac244dc54675046d04a0fde51485f83ef</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>aa095ad255b5cb6efeeaa5dd302f8772d</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a84651a987b69ad1870f33337d7285d7c</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>afe4aad896c0826549cafd17ed9bc21af</anchor>
      <arglist>(int index, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a6a38e68d9cae6812636583ccaacbef11</anchor>
      <arglist>(int row, int col, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ei_int_if_dynamic&lt; ColsAtCompileTime &gt;</type>
      <name>m_blockCols</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a7fd19e92e2dc8a4e59523a5ea2cbdb06</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ei_int_if_dynamic&lt; RowsAtCompileTime &gt;</type>
      <name>m_blockRows</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a56d079308216befb028fb20717f7d82f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MatrixType::Nested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>aa213d3c4337a578d57ada1869f65e55e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ei_int_if_dynamic&lt; MatrixType::ColsAtCompileTime==1?0:Dynamic &gt;</type>
      <name>m_startCol</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>a8214d2f5bbc39294ec0dec2c48a88175</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ei_int_if_dynamic&lt; MatrixType::RowsAtCompileTime==1?0:Dynamic &gt;</type>
      <name>m_startRow</name>
      <anchorfile>classEigen_1_1Block.html</anchorfile>
      <anchor>aaaa2b0a635a42bd4f1913c0ffd6263a9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::CommaInitializer</name>
    <filename>structEigen_1_1CommaInitializer.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>ei_traits&lt; MatrixType &gt;::Scalar</type>
      <name>Scalar</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>a35f048fd81ea5ea9c013aa3b4dbdfac5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CommaInitializer</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>af5e2e094d15e657475acbd4ed84250e8</anchor>
      <arglist>(MatrixType &amp;mat, const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CommaInitializer</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>a96d7ebdf3140ee2cf1f79fd3b0dbeda6</anchor>
      <arglist>(MatrixType &amp;mat, const Scalar &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>MatrixType &amp;</type>
      <name>finished</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>a6feaab799f3955521fd163b89f114e97</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>CommaInitializer &amp;</type>
      <name>operator,</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>a802c8460a68941f3ab6efc7486a12fae</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CommaInitializer &amp;</type>
      <name>operator,</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>a2cc0699486e5e95a9bec1badc902e111</anchor>
      <arglist>(const Scalar &amp;s)</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>m_col</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>acc1e0656106640e5da659781881f716f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>m_currentBlockRows</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>ae509dbd4c341870d1a8ae691e323e92e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>MatrixType &amp;</type>
      <name>m_matrix</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>a604c4f20b342509614bda5970fd02c4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>m_row</name>
      <anchorfile>structEigen_1_1CommaInitializer.html</anchorfile>
      <anchor>a9160ee48886232e4713ef139e015a695</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::CompressedStorage</name>
    <filename>classEigen_1_1CompressedStorage.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type>std::size_t</type>
      <name>allocatedSize</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>ab413dbff9b7cc2f8c83b5c41fd82a4a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a95efcf5e0c935cfb405815692a8090e2</anchor>
      <arglist>(const Scalar &amp;v, int i)</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>at</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>aff10ffd8c88e0cf77d8f20d7bb518a1f</anchor>
      <arglist>(int key, Scalar defaultValue=Scalar(0)) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>atInRange</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a129e6a395a6d81f7b0be41ba5a3c29c1</anchor>
      <arglist>(std::size_t start, std::size_t end, int key, Scalar defaultValue=Scalar(0)) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>atWithInsertion</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a154fca58eae8cad692b82cefd3120f1a</anchor>
      <arglist>(int key, Scalar defaultValue=Scalar(0))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>ac8bb3912a3ce86b15842e79d0b421204</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CompressedStorage</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a7323b4038ec1e65dcf52c7ea95e9de6f</anchor>
      <arglist>(const CompressedStorage &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CompressedStorage</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a15c24e54a68e8f23e90e358f8af9707e</anchor>
      <arglist>(std::size_t size)</arglist>
    </member>
    <member kind="function">
      <type>const int &amp;</type>
      <name>index</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>adde4a841b6c3e4d792c7f166c4fbcf3a</anchor>
      <arglist>(std::size_t i) const </arglist>
    </member>
    <member kind="function">
      <type>int &amp;</type>
      <name>index</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a6f347c0bea536314b53e163ce2417ca5</anchor>
      <arglist>(std::size_t i)</arglist>
    </member>
    <member kind="function">
      <type>CompressedStorage &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>ad5b598889cbadd9cc9265622642e2da9</anchor>
      <arglist>(const CompressedStorage &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prune</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a63540e9242a42c735d0e58c4c4e8f95d</anchor>
      <arglist>(Scalar reference, RealScalar epsilon=precision&lt; RealScalar &gt;())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reserve</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a9c2442c7ea8a8de2fbaeb66310345191</anchor>
      <arglist>(std::size_t size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>acdac6bc5b1098704264b7bcb8fc2e888</anchor>
      <arglist>(std::size_t size, float reserveSizeFactor=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>searchLowerIndex</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a9b3ae8e25f31d6f598fa880f8b9f4203</anchor>
      <arglist>(std::size_t start, std::size_t end, int key) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>searchLowerIndex</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a9199e70ba88342efb7c1fa08468e9f06</anchor>
      <arglist>(int key) const </arglist>
    </member>
    <member kind="function">
      <type>std::size_t</type>
      <name>size</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a725e764d8ff6e3008f4494b38b7edca0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>squeeze</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a2864bb5bf45a177b41a46ab5ed60fb47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a2e582f307b82203c0d7f1a104f4bcc09</anchor>
      <arglist>(CompressedStorage &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>const Scalar &amp;</type>
      <name>value</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>aff9c78369791dc5d7751e3a4e8eb152e</anchor>
      <arglist>(std::size_t i) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>value</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a89f89b329acb3aae42228a7b8b0ffb72</anchor>
      <arglist>(std::size_t i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static CompressedStorage</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>af461b3d19a7ceb2ac92c2bb17500ac31</anchor>
      <arglist>(int *indices, Scalar *values, std::size_t size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>reallocate</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a334b8261e59f7a8e6ec798c66e9e3e50</anchor>
      <arglist>(std::size_t size)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::size_t</type>
      <name>m_allocatedSize</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>ab2b1a79687ecfedcb3fc61bb4ad08a69</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int *</type>
      <name>m_indices</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a4f19c59d2c2390296797ac88bc4b2332</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::size_t</type>
      <name>m_size</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a338287d0a1c89d037708af4ff6d46a99</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Scalar *</type>
      <name>m_values</name>
      <anchorfile>classEigen_1_1CompressedStorage.html</anchorfile>
      <anchor>a2317742732cb5716f0e0174f5fb27d16</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Cwise</name>
    <filename>classEigen_1_1Cwise.html</filename>
    <templarg>ExpressionType</templarg>
    <member kind="typedef">
      <type>ei_meta_if&lt; ei_must_nest_by_value&lt; ExpressionType &gt;::ret, ExpressionType, const ExpressionType &amp; &gt;::ret</type>
      <name>ExpressionTypeNested</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a78faa66fa13262945677052387be284a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_traits&lt; ExpressionType &gt;::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a2b4634ec663cff58bb04711491b69415</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CwiseUnaryOp&lt; ei_scalar_add_op&lt; Scalar &gt;, ExpressionType &gt;</type>
      <name>ScalarAddReturnType</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ab71379b6f5f52bb68fcaea0e924fdc37</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const ExpressionType &amp;</type>
      <name>_expression</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ab1cd1649c2f88524d95bd7b399121b68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_abs_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>abs</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>abf73276fc968045bd7d6b9dbb1fe3b72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_abs2_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>abs2</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ad29af81c1f4786df5bb532a487f72d52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_cos_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>cos</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a76d05c27b753d221252b16b97f9fbab5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_cube_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>cube</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a3b6207c63baad44d5a58f82b028aa813</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Cwise</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a3e438d9ac883cf5b1fc5d7c1e410552c</anchor>
      <arglist>(const ExpressionType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const</type>
      <name>EIGEN_CWISE_COMP_TO_SCALAR_RETURN_TYPE</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a36d740d63c72dc77f3738f737020ca3d</anchor>
      <arglist>(std::not_equal_to) operator!</arglist>
    </member>
    <member kind="function">
      <type>const</type>
      <name>EIGEN_CWISE_COMP_TO_SCALAR_RETURN_TYPE</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a1115975d41c9f7039d1f0932de246eab</anchor>
      <arglist>(std::equal_to) operator</arglist>
    </member>
    <member kind="function">
      <type>const</type>
      <name>EIGEN_CWISE_COMP_TO_SCALAR_RETURN_TYPE</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ad4f030acc887cc1ca6cd981cb0985019</anchor>
      <arglist>(std::greater_equal) operator&gt;</arglist>
    </member>
    <member kind="function">
      <type>const</type>
      <name>EIGEN_CWISE_COMP_TO_SCALAR_RETURN_TYPE</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ab1f712dce2232cf555888e967dd3c13b</anchor>
      <arglist>(std::greater) operator&gt;(Scalar s) const </arglist>
    </member>
    <member kind="function">
      <type>const</type>
      <name>EIGEN_CWISE_COMP_TO_SCALAR_RETURN_TYPE</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a8f9ddf7354ff42ebc9707f733e23afe7</anchor>
      <arglist>(std::less_equal) operator&lt;</arglist>
    </member>
    <member kind="function">
      <type>const</type>
      <name>EIGEN_CWISE_COMP_TO_SCALAR_RETURN_TYPE</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a6145333e1623bf1f383e8483b8ff35ca</anchor>
      <arglist>(std::less) operator&lt;(Scalar s) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_exp_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>exp</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a8baf8ea4acd852ab9ddc35fa3bbd83bf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_inverse_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ae475ab181822196f61f196e516041c07</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_log_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>log</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a0f75324aab0ee99ce02bfaa44119f2a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; ei_scalar_max_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>max</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ae608ac83ea7cb01d884abcf85b94a9bb</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; ei_scalar_min_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>min</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>acbf08c69f291bc91070119cad61292b2</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; std::not_equal_to&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>operator!=</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ad3df97d4c0219adc7331da4bb1fae85b</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const EIGEN_CWISE_PRODUCT_RETURN_TYPE</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>af8d8c250fa591890f4b20cb7f204be26</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>ExpressionType &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>adc085f1d92b3d03465c87a0a57009868</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>const ScalarAddReturnType</type>
      <name>operator+</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>add8c356711a7c04b7c62b786b4c383d4</anchor>
      <arglist>(const Scalar &amp;scalar) const </arglist>
    </member>
    <member kind="function">
      <type>ExpressionType &amp;</type>
      <name>operator+=</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ad981ab11a3c7a7060b2cecca53e0e9f1</anchor>
      <arglist>(const Scalar &amp;scalar)</arglist>
    </member>
    <member kind="function">
      <type>const ScalarAddReturnType</type>
      <name>operator-</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a1dafaeb3a809235c22938b8ebc8cd6e1</anchor>
      <arglist>(const Scalar &amp;scalar) const </arglist>
    </member>
    <member kind="function">
      <type>ExpressionType &amp;</type>
      <name>operator-=</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>abf6e0493dbca4a066a4145a70751062d</anchor>
      <arglist>(const Scalar &amp;scalar)</arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; ei_scalar_quotient_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>operator/</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a071ded032b2323baf136ba9c094f3d3f</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>ExpressionType &amp;</type>
      <name>operator/=</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a4f6bb458ae2ef5b1a61bad8936901cb9</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; std::less&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>operator&lt;</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a8ce93b197a516f01cbe6a8b69fe2e55a</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; std::less_equal&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>operator&lt;=</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ac136482a0387413e87f03d42cf66ef93</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; std::equal_to&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>operator==</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>af2c083300507210a5787a9dc8c987931</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; std::greater&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>operator&gt;</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ac6be6fd65bab1b59a37d150008fbbb98</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; std::greater_equal&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType, OtherDerived &gt;</type>
      <name>operator&gt;=</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ac894c172ed68bca7ff88c7aab39bc036</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_pow_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>pow</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>aab658c5caacc369555217edc8375d2ac</anchor>
      <arglist>(const Scalar &amp;exponent) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_sin_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>sin</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a94da776079a69fa64e43e408310d59c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_sqrt_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>sqrt</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a9e42325f91b34f40ba99f85e982a5e18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_square_op&lt; typename ei_traits&lt; ExpressionType &gt;::Scalar &gt;, ExpressionType &gt;</type>
      <name>square</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a082297eb6b440fdc43977e3be2207ec4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ExpressionTypeNested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>a885783fe5a6c8184c0119a14eb9961fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend const ScalarAddReturnType</type>
      <name>operator+</name>
      <anchorfile>classEigen_1_1Cwise.html</anchorfile>
      <anchor>ae3ebfb798683c224a3b4f25a4a35073d</anchor>
      <arglist>(const Scalar &amp;scalar, const Cwise &amp;mat)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::CwiseBinaryOp</name>
    <filename>classEigen_1_1CwiseBinaryOp.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>ei_traits&lt; CwiseBinaryOp &gt;::LhsNested</type>
      <name>LhsNested</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>a68edf5cc951b9a36e5896e0871669798</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_traits&lt; CwiseBinaryOp &gt;::RhsNested</type>
      <name>RhsNested</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>a0a3346d3b746bda2f78ebdbb653353fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CwiseBinaryOp</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>a8d81e5235f2275a615230e206be1e3e3</anchor>
      <arglist>(const Lhs &amp;lhs, const Rhs &amp;rhs, const BinaryOp &amp;func=BinaryOp())</arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>aa095ad255b5cb6efeeaa5dd302f8772d</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>a84651a987b69ad1870f33337d7285d7c</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const BinaryOp</type>
      <name>m_functor</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>ab15ea59d3b4acef9de418d78c8ad3c0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const LhsNested</type>
      <name>m_lhs</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>ae1caf29b04271234ea499ae96c8d4ba3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const RhsNested</type>
      <name>m_rhs</name>
      <anchorfile>classEigen_1_1CwiseBinaryOp.html</anchorfile>
      <anchor>a4ded68608647d72c0180d78485e851bd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::CwiseNullaryOp</name>
    <filename>classEigen_1_1CwiseNullaryOp.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>a145bb097ba22beb254b597fb1da74c2a</anchor>
      <arglist>(int rows, int cols) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CwiseNullaryOp</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>a36ec011c91182219c17812383bf14668</anchor>
      <arglist>(int rows, int cols, const NullaryOp &amp;func=NullaryOp())</arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>ae4fa3d320f04979c696a63c2488fd5ce</anchor>
      <arglist>(int) const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>ab6d6a53c7e27486f2daca3ce875e3651</anchor>
      <arglist>(int, int) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ei_int_if_dynamic&lt; ColsAtCompileTime &gt;</type>
      <name>m_cols</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>a44f1670c5e14e83095645a921daed758</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const NullaryOp</type>
      <name>m_functor</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>a8c599fe7926389d978e6daec3dd229d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ei_int_if_dynamic&lt; RowsAtCompileTime &gt;</type>
      <name>m_rows</name>
      <anchorfile>classEigen_1_1CwiseNullaryOp.html</anchorfile>
      <anchor>aee1201d74b6ba9fcda38492359207846</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::CwiseUnaryOp</name>
    <filename>classEigen_1_1CwiseUnaryOp.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CwiseUnaryOp</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>a632c473c84f81c5bcef253ca32129d37</anchor>
      <arglist>(const MatrixType &amp;mat, const UnaryOp &amp;func=UnaryOp())</arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>aa095ad255b5cb6efeeaa5dd302f8772d</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>a84651a987b69ad1870f33337d7285d7c</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const UnaryOp</type>
      <name>m_functor</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>a1bd31f9eac3456767cdc03142bba9202</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MatrixType::Nested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1CwiseUnaryOp.html</anchorfile>
      <anchor>aa213d3c4337a578d57ada1869f65e55e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::DiagonalCoeffs</name>
    <filename>classEigen_1_1DiagonalCoeffs.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1DiagonalCoeffs.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1DiagonalCoeffs.html</anchorfile>
      <anchor>a173dfd3713eb1894862489845c0297c4</anchor>
      <arglist>(int row, int) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1DiagonalCoeffs.html</anchorfile>
      <anchor>ac244dc54675046d04a0fde51485f83ef</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1DiagonalCoeffs.html</anchorfile>
      <anchor>aef679d5fad5187cba8ad629cc4a857bc</anchor>
      <arglist>(int row, int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1DiagonalCoeffs.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DiagonalCoeffs</name>
      <anchorfile>classEigen_1_1DiagonalCoeffs.html</anchorfile>
      <anchor>a2e011bb7b2ec485b6398bac182a7c30a</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1DiagonalCoeffs.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MatrixType::Nested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1DiagonalCoeffs.html</anchorfile>
      <anchor>aa213d3c4337a578d57ada1869f65e55e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::DiagonalMatrix</name>
    <filename>classEigen_1_1DiagonalMatrix.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>CoeffsVectorType</type>
      <name>_CoeffsVectorType</name>
      <anchorfile>classEigen_1_1DiagonalMatrix.html</anchorfile>
      <anchor>a62b9f9ad49658f88afb09d125c5a6537</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1DiagonalMatrix.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1DiagonalMatrix.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CoeffsVectorType &amp;</type>
      <name>diagonal</name>
      <anchorfile>classEigen_1_1DiagonalMatrix.html</anchorfile>
      <anchor>ad62c4f2ead4c167b76f6ce3224fc0b45</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DiagonalMatrix</name>
      <anchorfile>classEigen_1_1DiagonalMatrix.html</anchorfile>
      <anchor>a063a5054b3303ffd6d219e8237dc0a74</anchor>
      <arglist>(const CoeffsVectorType &amp;coeffs)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DiagonalMatrix</name>
      <anchorfile>classEigen_1_1DiagonalMatrix.html</anchorfile>
      <anchor>a75f62070740bfff99d23355a94d12cc8</anchor>
      <arglist>(const DiagonalMatrix&lt; OtherCoeffsVectorType &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1DiagonalMatrix.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const CoeffsVectorType::Nested</type>
      <name>m_coeffs</name>
      <anchorfile>classEigen_1_1DiagonalMatrix.html</anchorfile>
      <anchor>af221566a8916b57f0a7e9dcd16f6c199</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::DynamicSparseMatrix</name>
    <filename>classEigen_1_1DynamicSparseMatrix.html</filename>
    <templarg></templarg>
    <templarg>_Flags</templarg>
    <member kind="typedef">
      <type>MappedSparseMatrix&lt; Scalar, Flags &gt;</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a25cb1cbaee9b60f3e02c96cc69db2775</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; CompressedStorage&lt; Scalar &gt; &gt; &amp;</type>
      <name>_data</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a09f31ff8f2c763e4bd3967727cabfd00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; CompressedStorage&lt; Scalar &gt; &gt; &amp;</type>
      <name>_data</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>ab877dd7648d0d382b84218b0a0440755</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>af2b14e136cbed0bd5fbd5e72a08d3187</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DynamicSparseMatrix</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a0cf50a3067930af4a0b16027dc80eae5</anchor>
      <arglist>(const DynamicSparseMatrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DynamicSparseMatrix</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a3a8df5754227f2b3a3ca197e2b3d8ca4</anchor>
      <arglist>(const SparseMatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DynamicSparseMatrix</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>af75c1393de8f860de8fe0677ceb25a9b</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>endFill</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a4d3d8b6f0cd82ee988c3465731fe7e64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>fill</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a2e4bf7eb9757b85be9af24d71e4bcb59</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>fillrand</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a275d73c9a743664156294ccfe1122595</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerNonZeros</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>ae81e96121524a9077b8ec0c2eb5d32f1</anchor>
      <arglist>(int j) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerSize</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a124752e160ea0b87f4b5fbd9b630b8ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nonZeros</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>aacaa48cbf79ea5dadaa66ca36bb29bf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DynamicSparseMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a5e1d60799bce9734c0af7e88f6e31ee2</anchor>
      <arglist>(const SparseMatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DynamicSparseMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a17ec76399dbd31ba475fb8772f6c129a</anchor>
      <arglist>(const DynamicSparseMatrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>outerSize</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>ab0a84319855a030cd5446a2ed38b500c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prune</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a63540e9242a42c735d0e58c4c4e8f95d</anchor>
      <arglist>(Scalar reference, RealScalar epsilon=precision&lt; RealScalar &gt;())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>acedbb131f3c73db12693c80f8b00d75b</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resizeAndKeepData</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>aa5d0f2aa75b80e2063eee1b2c7f0ae0f</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZero</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a47affd1a10b589811fc4828c1a2e0c6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startFill</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>acab9178f0932b886d40ee1990bd8b144</anchor>
      <arglist>(int reserveSize=1000)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a9988545370384562905e2a7a0524a02f</anchor>
      <arglist>(DynamicSparseMatrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DynamicSparseMatrix</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>a73ba3b1e1403972e4f32eb10bfa63215</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>DynamicSparseMatrix&lt; Scalar,(Flags &amp;~RowMajorBit)|(IsRowMajor?RowMajorBit:0)&gt;</type>
      <name>TransposedSparseMatrix</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>aab51055d680a2ff0692ecd7ee662a5a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; CompressedStorage&lt; Scalar &gt; &gt;</type>
      <name>m_data</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>af479001b3abaf77dc5c924d91694679e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_innerSize</name>
      <anchorfile>classEigen_1_1DynamicSparseMatrix.html</anchorfile>
      <anchor>afa327d86d468b495fe83abab242c906f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::EigenSolver</name>
    <filename>classEigen_1_1EigenSolver.html</filename>
    <templarg>_MatrixType</templarg>
    <member kind="typedef">
      <type>std::complex&lt; RealScalar &gt;</type>
      <name>Complex</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a1a215510434ed195e4ce08e1f0b86afe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Complex, MatrixType::ColsAtCompileTime, 1 &gt;</type>
      <name>EigenvalueType</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a1eb1930516223d4f3ef4b957e5b6e212</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Complex, MatrixType::RowsAtCompileTime, MatrixType::ColsAtCompileTime &gt;</type>
      <name>EigenvectorType</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a1879b7a2642885fac4054c4256f0f4e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_MatrixType</type>
      <name>MatrixType</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>aeb6c0eb89cc982629305f6c7e0791caf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; RealScalar, MatrixType::ColsAtCompileTime, 1 &gt;</type>
      <name>RealVectorType</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a851a3ba3fef8f12638d6d8429faa3570</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; RealScalar, Dynamic, 1 &gt;</type>
      <name>RealVectorTypeX</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>abf56d6f2a699316c27d0ac6df9fc95b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EigenSolver</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a7d49a7ec0c89aa0af94eae8b05316b28</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EigenSolver</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a838424bc2f923e06e7690965bf6d7769</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EigenvalueType</type>
      <name>eigenvalues</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>acffd08bee548eaa5c10414343a93529f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EigenvectorType</type>
      <name>eigenvectors</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>af772055c36de2761f14a7749c18e6dd7</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>pseudoEigenvalueMatrix</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a4140972e2b45343d1ef1793c2824159c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const MatrixType &amp;</type>
      <name>pseudoEigenvectors</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a3b6c3b38f50c2372de195ff955a4e02d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>EigenvalueType</type>
      <name>m_eivalues</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>ae9c0742ca53195047d6ba097fd2df698</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_eivec</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>aadffd531416b65eba828a8b6bb8c3fde</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_isInitialized</name>
      <anchorfile>classEigen_1_1EigenSolver.html</anchorfile>
      <anchor>a217245eec26f69d0c5b6e991937de95a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Flagged</name>
    <filename>classEigen_1_1Flagged.html</filename>
    <templarg></templarg>
    <templarg>Added</templarg>
    <templarg>Removed</templarg>
    <member kind="typedef">
      <type>ei_meta_if&lt; ei_must_nest_by_value&lt; ExpressionType &gt;::ret, ExpressionType, const ExpressionType &amp; &gt;::ret</type>
      <name>ExpressionTypeNested</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a78faa66fa13262945677052387be284a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ExpressionType::InnerIterator</type>
      <name>InnerIterator</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a1ab6cb31264779b4f0a46c838eae4e21</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const ExpressionType &amp;</type>
      <name>_expression</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>ab1cd1649c2f88524d95bd7b399121b68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>ac244dc54675046d04a0fde51485f83ef</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Flagged</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a7731bf8ebb3ece2715683189ff1dcf9b</anchor>
      <arglist>(const ExpressionType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a189ce98791b46dfcb2143824afd6bad0</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a25a22be95c6dbeaaedeefa2ff1c86044</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stride</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a2f0529f7f5ff03b8a26e3a3d1925bb2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>afe4aad896c0826549cafd17ed9bc21af</anchor>
      <arglist>(int index, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a6a38e68d9cae6812636583ccaacbef11</anchor>
      <arglist>(int row, int col, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ExpressionTypeNested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1Flagged.html</anchorfile>
      <anchor>a885783fe5a6c8184c0119a14eb9961fc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::HessenbergDecomposition</name>
    <filename>classEigen_1_1HessenbergDecomposition.html</filename>
    <templarg>_MatrixType</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, SizeMinusOne, 1 &gt;</type>
      <name>CoeffVectorType</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>abea75df1e0a8369a6e40fcd507142999</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NestByValue&lt; DiagonalCoeffs&lt; MatrixType &gt; &gt;::RealReturnType</type>
      <name>DiagonalReturnType</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a71c1da1db6849dd95ab7fb95e640fb06</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; RealScalar, Size, 1 &gt;</type>
      <name>DiagonalType</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a87068f43ff0630dfc77b4fc53a48c65c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_MatrixType</type>
      <name>MatrixType</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>aeb6c0eb89cc982629305f6c7e0791caf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NestByValue&lt; DiagonalCoeffs&lt; NestByValue&lt; Block&lt; MatrixType, SizeMinusOne, SizeMinusOne &gt; &gt; &gt; &gt;::RealReturnType</type>
      <name>SubDiagonalReturnType</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a57a1f96c246abc9afba85755902a6932</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; RealScalar, SizeMinusOne, 1 &gt;</type>
      <name>SubDiagonalType</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>ab4c34abe4993bde7bc8483c95cb7e04f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HessenbergDecomposition</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a5f1aa26a2c7a68fedb5f201912df9128</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HessenbergDecomposition</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a9b10326f72fbfe0b3602630cfe7494df</anchor>
      <arglist>(int size=Size==Dynamic?2:Size)</arglist>
    </member>
    <member kind="function">
      <type>CoeffVectorType</type>
      <name>householderCoefficients</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>ade50f8e51aae26549cee83d541a622bc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>matrixH</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a1a821db294276f70704a3d1e6426917e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>matrixQ</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a20981fb3b815a34ad97ce1b6c06cd878</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const MatrixType &amp;</type>
      <name>packedMatrix</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>ac99c081e3c659e0448623c881e04b9c2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>CoeffVectorType</type>
      <name>m_hCoeffs</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a4f25ef6c17bba4dec8ba3b590dd74a3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1HessenbergDecomposition.html</anchorfile>
      <anchor>a5cb944a2054dfd326e4dcf77bb1bacf1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Hyperplane</name>
    <filename>classEigen_1_1Hyperplane.html</filename>
    <templarg></templarg>
    <templarg>_AmbientDim</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, int(AmbientDimAtCompileTime)==Dynamic?Dynamic:int(AmbientDimAtCompileTime)+1, 1 &gt;</type>
      <name>Coefficients</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>ad3d83d8f4668a4e85aa9d646d68c6261</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Block&lt; Coefficients, AmbientDimAtCompileTime, 1 &gt;</type>
      <name>NormalReturnType</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>aac64c993c698e37e73c7c9c7480be80f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, AmbientDimAtCompileTime, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>ad05514d010d3df4bdb8a28accaaed19f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>absDistance</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a8383bb22fa5f6024856f2c781f6ec0db</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; Hyperplane, Hyperplane&lt; NewScalarType, AmbientDimAtCompileTime &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>ad8839a9b9284cc48e8e22134aeb6a99c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Coefficients &amp;</type>
      <name>coeffs</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a1617ce16af4ff4c65d2155848f2ea161</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Coefficients &amp;</type>
      <name>coeffs</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a67d7e844f940f6ca2673eadacaf08b3b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dim</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a57840c996d92c9162995c5fbd8ab1bd1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Hyperplane</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a825cc2efe018250a6b0e5286775b547b</anchor>
      <arglist>(const Hyperplane&lt; OtherScalarType, AmbientDimAtCompileTime &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Hyperplane</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a7e93264afdcb9e5e762413df10bad3dd</anchor>
      <arglist>(const ParametrizedLine&lt; Scalar, AmbientDimAtCompileTime &gt; &amp;parametrized)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Hyperplane</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>aeaf9d37f2c9ce08706dddd631955a660</anchor>
      <arglist>(const VectorType &amp;n, Scalar d)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Hyperplane</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>ad3ab0f5ce565bb0561e5dd3d82358c0e</anchor>
      <arglist>(const VectorType &amp;n, const VectorType &amp;e)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Hyperplane</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>af9a64eb0b8b0f3b0913172861c7a4ccf</anchor>
      <arglist>(int _dim)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Hyperplane</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>af5da8814bd3fb91f730302692c736069</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>VectorType</type>
      <name>intersection</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a79cc134d196c93926bd003dc8fbf1858</anchor>
      <arglist>(const Hyperplane &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a527d62618c7fbe79a3a67e292663685f</anchor>
      <arglist>(const Hyperplane &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>NormalReturnType</type>
      <name>normal</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a115e276ad412ed6378e3291095132591</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const NormalReturnType</type>
      <name>normal</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a94d0c1b07282a61c9e58bf4b22e1b1bc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>normalize</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a7494eb6e7ee0d104f3a01dcceed8607a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>offset</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a12c3df61f19531230e282a879b605842</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar &amp;</type>
      <name>offset</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a32ddf277ab2a650e7d520bcbbc09fb99</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>VectorType</type>
      <name>projection</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>ac93039c47cde2b60b29d99f3e1a7dc71</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>signedDistance</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>aacd139793b951a521e0e5147a4793d9c</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>Hyperplane &amp;</type>
      <name>transform</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>af82e3182309c2a6373798a6636f30a41</anchor>
      <arglist>(const Transform&lt; Scalar, AmbientDimAtCompileTime &gt; &amp;t, TransformTraits traits=Affine)</arglist>
    </member>
    <member kind="function">
      <type>Hyperplane &amp;</type>
      <name>transform</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>acecb5cf492d5795a1c2ff3e540b0e19b</anchor>
      <arglist>(const MatrixBase&lt; XprType &gt; &amp;mat, TransformTraits traits=Affine)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Hyperplane</type>
      <name>Through</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>aabfcda23a80edfd62387bb3d930f4b96</anchor>
      <arglist>(const VectorType &amp;p0, const VectorType &amp;p1, const VectorType &amp;p2)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Hyperplane</type>
      <name>Through</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a10fad5ae000f23b20ebc9e54ed7202dd</anchor>
      <arglist>(const VectorType &amp;p0, const VectorType &amp;p1)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Coefficients</type>
      <name>m_coeffs</name>
      <anchorfile>classEigen_1_1Hyperplane.html</anchorfile>
      <anchor>a0fefc62bb93454c110680b8400cab7f6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::IOFormat</name>
    <filename>structEigen_1_1IOFormat.html</filename>
    <member kind="function">
      <type></type>
      <name>IOFormat</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>a5aeb6185ebac493b8107de6acdf362bd</anchor>
      <arglist>(int _precision=4, int _flags=Raw, const std::string &amp;_coeffSeparator=&quot; &quot;, const std::string &amp;_rowSeparator=&quot;\n&quot;, const std::string &amp;_rowPrefix=&quot;&quot;, const std::string &amp;_rowSuffix=&quot;&quot;, const std::string &amp;_matPrefix=&quot;&quot;, const std::string &amp;_matSuffix=&quot;&quot;)</arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>coeffSeparator</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>a8eb58a72e2a76aea9892b7436a61dec6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>flags</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>ac8bf36fe0577cba66bccda3a6f7e80a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>matPrefix</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>aab662a225717e6bfa419122e0063bbeb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>matSuffix</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>a96acf48a7714fc6d446175eefa8f7eef</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>precision</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>aa95455ed52a8459fad69509a4a0411b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>rowPrefix</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>aa1ff276961489c75e66a9dae2a8d3541</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>rowSeparator</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>a32d85c58b2d50627e324c420b357419e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>rowSpacer</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>aed0cb391bf20e2a53c32f850b5127055</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>rowSuffix</name>
      <anchorfile>structEigen_1_1IOFormat.html</anchorfile>
      <anchor>a623314391fcd5f77b1352f079e8d8b87</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::LDLT</name>
    <filename>classEigen_1_1LDLT.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>NumTraits&lt; typename MatrixType::Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a79aff568be74c125bfe8d749047de98e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, MatrixType::ColsAtCompileTime, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a7f4af69eabe67230f4d72b7b8a7ee915</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPositiveDefinite</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a20c4cab6ea9d67009b45148d7870844e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LDLT</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a4f9c1dcdc8070fb63772e3d940e41fb3</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>Part&lt; MatrixType, UnitLowerTriangular &gt;</type>
      <name>matrixL</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>aefcea5686b2c11f14bbc607ec3eeea70</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solve</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a4e3afb4002d8de426f4549352f9e3262</anchor>
      <arglist>(const MatrixBase&lt; RhsDerived &gt; &amp;b, ResultType *result) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solveInPlace</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>aacbc167e0ab987691f803cace5aa2449</anchor>
      <arglist>(MatrixBase&lt; Derived &gt; &amp;bAndX) const </arglist>
    </member>
    <member kind="function">
      <type>DiagonalCoeffs&lt; MatrixType &gt;</type>
      <name>vectorD</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a33510d111dcde024c0debf2df0bc9c55</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_isPositiveDefinite</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a63d30fb46b8dd0ad21af7ab9ef332044</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1LDLT.html</anchorfile>
      <anchor>a5cb944a2054dfd326e4dcf77bb1bacf1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::LLT</name>
    <filename>classEigen_1_1LLT.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPositiveDefinite</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a20c4cab6ea9d67009b45148d7870844e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LLT</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a1a97df7b6bc482c6aea2324d8151c8fa</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LLT</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a5bb9ddb29f0e0710acfe830794571f25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Part&lt; MatrixType, LowerTriangular &gt;</type>
      <name>matrixL</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a9e03eb41bfeddc1350f69aa150e00c53</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solve</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a4e3afb4002d8de426f4549352f9e3262</anchor>
      <arglist>(const MatrixBase&lt; RhsDerived &gt; &amp;b, ResultType *result) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solveInPlace</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>aacbc167e0ab987691f803cace5aa2449</anchor>
      <arglist>(MatrixBase&lt; Derived &gt; &amp;bAndX) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_isInitialized</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a217245eec26f69d0c5b6e991937de95a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_isPositiveDefinite</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a63d30fb46b8dd0ad21af7ab9ef332044</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1LLT.html</anchorfile>
      <anchor>a5cb944a2054dfd326e4dcf77bb1bacf1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::LU</name>
    <filename>classEigen_1_1LU.html</filename>
    <templarg>MatrixType</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, MatrixType::RowsAtCompileTime, 1, MatrixType::Options, MatrixType::MaxRowsAtCompileTime, 1 &gt;</type>
      <name>ColVectorType</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a4674b31f2687ff0882b891d5fec172c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; typename MatrixType::Scalar, MatrixType::RowsAtCompileTime, Dynamic, MatrixType::Options, MatrixType::MaxRowsAtCompileTime, MatrixType::MaxColsAtCompileTime &gt;</type>
      <name>ImageResultType</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a287b861e7305b49938bf68c14b7dd769</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; int, MatrixType::RowsAtCompileTime, 1, MatrixType::Options, MatrixType::MaxRowsAtCompileTime, 1 &gt;</type>
      <name>IntColVectorType</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a3ec2a0caf0011053d676eec9feced0ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; int, 1, MatrixType::ColsAtCompileTime, MatrixType::Options, 1, MatrixType::MaxColsAtCompileTime &gt;</type>
      <name>IntRowVectorType</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a1f4ddd33df3cfe1f5c199d4234686b98</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; typename MatrixType::Scalar, MatrixType::ColsAtCompileTime, Dynamic, MatrixType::Options, MatrixType::MaxColsAtCompileTime, MatrixType::MaxColsAtCompileTime &gt;</type>
      <name>KernelResultType</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a6e9d07ece640f8c4819fa8b15160555b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NumTraits&lt; typename MatrixType::Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a79aff568be74c125bfe8d749047de98e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, 1, MatrixType::ColsAtCompileTime, MatrixType::Options, 1, MatrixType::MaxColsAtCompileTime &gt;</type>
      <name>RowVectorType</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a2fa381561d9aaea516444e60ddb6d1e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeImage</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a292d1204adacdb4e73dcb76ede008f90</anchor>
      <arglist>(ImageMatrixType *result) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeInverse</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>ad608648410aa79bf22fb0f9777456a0c</anchor>
      <arglist>(ResultType *result) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeKernel</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a55bbe8064e721946ff164ddf66217ab1</anchor>
      <arglist>(KernelMatrixType *result) const </arglist>
    </member>
    <member kind="function">
      <type>ei_traits&lt; MatrixType &gt;::Scalar</type>
      <name>determinant</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a11be16e659e085e093cfa479f7a9131c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dimensionOfKernel</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a982993bdfdcd8f2001aceaa68f334912</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const ImageResultType</type>
      <name>image</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>aeb8c21c87ebe44e0a1af08cd69b8e766</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a5c45a1d7969b57807246466b8a4d599f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInjective</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a1e119085e53eca65e9ba15451c102d40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInvertible</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>ab60c7d993c9eba31668fb8886d621094</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSurjective</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a5968b9ca46303b3cc7250e7b120ab7e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KernelResultType</type>
      <name>kernel</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a64cf46c69c9aab1ad26faf5600502708</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LU</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a24afd95c0cd29b8f1c4c774e03cb68fd</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const MatrixType &amp;</type>
      <name>matrixLU</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>ad69664a62ab4d3026566d0d4a261b187</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const IntColVectorType &amp;</type>
      <name>permutationP</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>ae3b7d484e4f7d0f8a0c3cd8e4e665553</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const IntRowVectorType &amp;</type>
      <name>permutationQ</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a349d004f0cb5f773de839374dbd66ede</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rank</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>ae59754aa54d2ee843c39aebc1de9cfb1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solve</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>acf22c329a5c3d713a20c4ab0558014b3</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;b, ResultType *result) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_det_pq</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a990268ecd895512d1d7ccbcf8b096edc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_lu</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a3e13268db1badecbd4495e4f93fb3dac</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MatrixType &amp;</type>
      <name>m_originalMatrix</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a5c8fb2fc8b78340c0d4ab9d10d08d7b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>IntColVectorType</type>
      <name>m_p</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a249cb4d35fb18dec750197b87a76c5fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>RealScalar</type>
      <name>m_precision</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a6931ccef8ba2cf4f11b6d23dae2931f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>IntRowVectorType</type>
      <name>m_q</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>a4a9348ae0e36ed1b0380b56358f56f4f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_rank</name>
      <anchorfile>classEigen_1_1LU.html</anchorfile>
      <anchor>ac6a822dc76382e4027cf94ac3e510056</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Map</name>
    <filename>classEigen_1_1Map.html</filename>
    <templarg></templarg>
    <templarg>PacketAccess</templarg>
    <member kind="typedef">
      <type>ei_traits&lt; Map &gt;::AlignedDerivedType</type>
      <name>AlignedDerivedType</name>
      <anchorfile>classEigen_1_1Map.html</anchorfile>
      <anchor>aba8bf732eaae9398c8e36b5fc221bb0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AlignedDerivedType</type>
      <name>_convertToForceAligned</name>
      <anchorfile>classEigen_1_1Map.html</anchorfile>
      <anchor>a8fbed16a6c5b73cb367a938bc6a815a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Map.html</anchorfile>
      <anchor>a024e3af89015f780a026af31f4fc9fc0</anchor>
      <arglist>(const Scalar *data, int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Map.html</anchorfile>
      <anchor>aa31f8c03fb174bf2bee3e53d678ec12d</anchor>
      <arglist>(const Scalar *data, int size)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Map.html</anchorfile>
      <anchor>a11db9d88c378d7db16b924e0532246bf</anchor>
      <arglist>(const Scalar *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1Map.html</anchorfile>
      <anchor>ada388d17b93c54a1a0f6edddbe0953ab</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1Map.html</anchorfile>
      <anchor>acedbb131f3c73db12693c80f8b00d75b</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stride</name>
      <anchorfile>classEigen_1_1Map.html</anchorfile>
      <anchor>a2f0529f7f5ff03b8a26e3a3d1925bb2b</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::MapBase</name>
    <filename>classEigen_1_1MapBase.html</filename>
    <templarg>Derived</templarg>
    <member kind="enumvalue">
      <name>RowsAtCompileTime</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>abc3975f01f66a098a347a8262ff103e5a38ab482a62bf46f6ed6dcc4e9dd0dddf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ColsAtCompileTime</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>abc3975f01f66a098a347a8262ff103e5ae943bdba893721a848dfcd03db756b22</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SizeAtCompileTime</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>abc3975f01f66a098a347a8262ff103e5ab30be5c02d7a124ec165d2ab6c5b05ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_traits&lt; Derived &gt;::AlignedDerivedType</type>
      <name>AlignedDerivedType</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a35aa90b180017b4f7b90212fe870889d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixBase&lt; Derived &gt;</type>
      <name>Base</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a0c21fb1f093f709af41fde1122aa153d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Base::PacketScalar</type>
      <name>PacketScalar</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>ade79715b53c7f094e82439d7edc3ba27</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_traits&lt; Derived &gt;::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>aba932c0fad971d4ffa4015627a740c10</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar &amp;</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a8830ac30ab1d25b6499aec7d07457b9f</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>ac244dc54675046d04a0fde51485f83ef</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar *</type>
      <name>data</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a40dcc334db75411e168691d9bce08c3a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>AlignedDerivedType</type>
      <name>forceAligned</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a0ef5cc2662352eb92b78b84d8a5e197a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MapBase</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>ab1a2f90cfdd7b07c1f556db91eee185a</anchor>
      <arglist>(const Scalar *data, int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MapBase</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a7e1fe1e197eaee0b186bbcbca41e790a</anchor>
      <arglist>(const Scalar *data, int size)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MapBase</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>ae0fda87b63b93d22683313bbaf7e58bd</anchor>
      <arglist>(const Scalar *data)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>ad80d750dcf7adca19b83d72209642584</anchor>
      <arglist>(const Scalar &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator+=</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>af76cd319dd1b5020dccef9fec30dd3ec</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator-=</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a74532b841458dc24664e167b60425b9f</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator/=</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a6839fe3fc3e3a54820f667861335003b</anchor>
      <arglist>(const Scalar &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a906e540b7c2e7e9d399aad7f93f098ca</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>aabebc837c821adafc9825ead067d0d78</anchor>
      <arglist>(const MapBase &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>aa095ad255b5cb6efeeaa5dd302f8772d</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a84651a987b69ad1870f33337d7285d7c</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stride</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a2f0529f7f5ff03b8a26e3a3d1925bb2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>afe4aad896c0826549cafd17ed9bc21af</anchor>
      <arglist>(int index, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a6a38e68d9cae6812636583ccaacbef11</anchor>
      <arglist>(int row, int col, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ei_int_if_dynamic&lt; ColsAtCompileTime &gt;</type>
      <name>m_cols</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a44f1670c5e14e83095645a921daed758</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const Scalar *EIGEN_RESTRICT</type>
      <name>m_data</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>a07cd32af2daae3b963c1e5f44b543adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ei_int_if_dynamic&lt; RowsAtCompileTime &gt;</type>
      <name>m_rows</name>
      <anchorfile>classEigen_1_1MapBase.html</anchorfile>
      <anchor>aee1201d74b6ba9fcda38492359207846</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::MappedSparseMatrix</name>
    <filename>classEigen_1_1MappedSparseMatrix.html</filename>
    <templarg></templarg>
    <templarg>_Flags</templarg>
    <member kind="function">
      <type>int *</type>
      <name>_innerIndexPtr</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a3532bd05076e166d3f5c7fc1bb54eb74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const int *</type>
      <name>_innerIndexPtr</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>aba5797dde801250ea687d232f81b44ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int *</type>
      <name>_outerIndexPtr</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a8a5f93acb012342bec6fa6ccca080b11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const int *</type>
      <name>_outerIndexPtr</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a3c5af0bda8657c94ff7d9b832000eaa8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar *</type>
      <name>_valuePtr</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a9aefb5ca87ecaa16461a9e0d6dcd7aa5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar *</type>
      <name>_valuePtr</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a23ae779fc3d5fbc6f18a2526916fe116</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>af2b14e136cbed0bd5fbd5e72a08d3187</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerNonZeros</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>ae81e96121524a9077b8ec0c2eb5d32f1</anchor>
      <arglist>(int j) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerSize</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a124752e160ea0b87f4b5fbd9b630b8ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MappedSparseMatrix</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a0d45fb2de07db690bc90e039f478d8d7</anchor>
      <arglist>(int rows, int cols, int nnz, int *outerIndexPtr, int *innerIndexPtr, Scalar *valuePtr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nonZeros</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>aacaa48cbf79ea5dadaa66ca36bb29bf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>outerSize</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>ab0a84319855a030cd5446a2ed38b500c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MappedSparseMatrix</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a719fff69117e57718602e7b16c9c9b65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int *</type>
      <name>m_innerIndices</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a31bab86dc528ed10feb494cc6173bf18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_innerSize</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>afa327d86d468b495fe83abab242c906f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_nnz</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a5b80f3129c67c2046d22197638051925</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int *</type>
      <name>m_outerIndex</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a9f4bc490ac1e1dda96c1bc44771c19d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_outerSize</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a802c54d83b6f8111734bdf883bbc41d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Scalar *</type>
      <name>m_values</name>
      <anchorfile>classEigen_1_1MappedSparseMatrix.html</anchorfile>
      <anchor>a2317742732cb5716f0e0174f5fb27d16</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Matrix</name>
    <filename>classEigen_1_1Matrix.html</filename>
    <templarg>_Scalar</templarg>
    <templarg>_Rows</templarg>
    <templarg>_Cols</templarg>
    <templarg>_Options</templarg>
    <templarg>_MaxRows</templarg>
    <templarg>_MaxCols</templarg>
    <member kind="typedef">
      <type>class Eigen::Map&lt; Matrix, Aligned &gt;</type>
      <name>AlignedMapType</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a5830d4226b3807f9d39d3c8607e4cf46</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>class Eigen::Map&lt; Matrix, Unaligned &gt;</type>
      <name>UnalignedMapType</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>aa9826317d604ec9b56089cd68a36cb50</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const Base &amp;</type>
      <name>base</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ad4c6b0a9d438877ae710fec4f033536f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Base &amp;</type>
      <name>base</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a243732286fa1e9939428c44b132c43b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar &amp;</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>addd935deb107256ca0655b6e7009745b</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar &amp;</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a8830ac30ab1d25b6499aec7d07457b9f</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ac244dc54675046d04a0fde51485f83ef</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar *</type>
      <name>data</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a4663159a1450fa89214b1ab71f7ef5bf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar *</type>
      <name>data</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a40dcc334db75411e168691d9bce08c3a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>af2d4986be1d6ed12dd0e45f713006cb7</anchor>
      <arglist>(const RotationBase&lt; OtherDerived, ColsAtCompileTime &gt; &amp;r)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a5e72b7c50059bf70eca50ada11a4cf88</anchor>
      <arglist>(const Matrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ad2ba769ad42723b1e0948f22c8748da9</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a4f6c5c1b14834bcdb46d641e36e826b5</anchor>
      <arglist>(const Scalar *data)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a5369f0750f5f1e885976fb598800d6d8</anchor>
      <arglist>(const Scalar &amp;x, const Scalar &amp;y, const Scalar &amp;z, const Scalar &amp;w)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ae935ed53e9609902a67341245ebc7610</anchor>
      <arglist>(const Scalar &amp;x, const Scalar &amp;y, const Scalar &amp;z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ab56268eca20252dfc2d7847eaf7e66c4</anchor>
      <arglist>(const double &amp;x, const double &amp;y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a88f1e0595425c51c6d01ad3f357401b4</anchor>
      <arglist>(const float &amp;x, const float &amp;y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ad97f38f1cc0c10798fba22b10f2973c3</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ad8b62150da51b1482377a666819eab3f</anchor>
      <arglist>(int dim)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a3aede62f513da27e6f61ae7a972b4f96</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>acffcd7bcc65a020a945e5e29d23eb2cb</anchor>
      <arglist>(const RotationBase&lt; OtherDerived, ColsAtCompileTime &gt; &amp;r)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ad0cefab13f61a9dfd2733a7da70a264e</anchor>
      <arglist>(const Matrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a4d2ffbae0570961c38589b84e31b2e56</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>aa095ad255b5cb6efeeaa5dd302f8772d</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a84651a987b69ad1870f33337d7285d7c</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ada388d17b93c54a1a0f6edddbe0953ab</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>acedbb131f3c73db12693c80f8b00d75b</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setConstant</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>aedf890e6cee4b0cdfc462b179db8ed44</anchor>
      <arglist>(int rows, int cols, const Scalar &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setConstant</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ad1290e65077e21bbb2040d30c7b2481d</anchor>
      <arglist>(int size, const Scalar &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setIdentity</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a7d992f0e55a6cbacc8a73fe62dd4322f</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setOnes</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>aa45f581bbc068e18c7af5efcb789debc</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setOnes</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a7b0e4c6bbec4560af2d2abf03aaf5b3d</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setRandom</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ab2ff4ab26ed1799cced1ef39ad9ff8e6</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setRandom</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a1d03699fd673e9d502edceeaa0a29ef0</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setZero</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a34d6d08af9f7dca06410b66049904fb1</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>Matrix &amp;</type>
      <name>setZero</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ac828d080c265265d3c9ea3ecfbb7311d</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stride</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>acab40bcf2fda12b7b73b37abb7afe7e0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a8a1ea9f6b79803b063c022aa87376ca6</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>afe4aad896c0826549cafd17ed9bc21af</anchor>
      <arglist>(int index, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a6a38e68d9cae6812636583ccaacbef11</anchor>
      <arglist>(int row, int col, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Matrix</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a2249c859d9c3503ec00d3a20fe963842</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static UnalignedMapType</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>ad28eb93c86ba8f6892f2f7fb83f3cd8f</anchor>
      <arglist>(Scalar *data, int rows, int cols)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const UnalignedMapType</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a62829207953914311f8b18cf8171cfe8</anchor>
      <arglist>(const Scalar *data, int rows, int cols)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static UnalignedMapType</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a318b3fc418b9d0f55c7d815114829e63</anchor>
      <arglist>(Scalar *data, int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const UnalignedMapType</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a2a1c4bd778b4d8f7bdfba2fc86934df3</anchor>
      <arglist>(const Scalar *data, int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static UnalignedMapType</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a59939f243606eb37cd694ac89dee8d6f</anchor>
      <arglist>(Scalar *data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const UnalignedMapType</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>afa0224b025dcaba329f095726b84d87c</anchor>
      <arglist>(const Scalar *data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static AlignedMapType</type>
      <name>MapAligned</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a490884e7d0b5bb771d4ca3073b12137e</anchor>
      <arglist>(Scalar *data, int rows, int cols)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const AlignedMapType</type>
      <name>MapAligned</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a2fd1a3400368c54ec808411e623cd959</anchor>
      <arglist>(const Scalar *data, int rows, int cols)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static AlignedMapType</type>
      <name>MapAligned</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a1cd6b49f2889d346268c61e88f772bac</anchor>
      <arglist>(Scalar *data, int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const AlignedMapType</type>
      <name>MapAligned</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a93315ccaeeb14ab0a6a4da50fd65fc47</anchor>
      <arglist>(const Scalar *data, int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static AlignedMapType</type>
      <name>MapAligned</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>a8a4c8353053c367b476f29293c45519c</anchor>
      <arglist>(Scalar *data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const AlignedMapType</type>
      <name>MapAligned</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>aeeb6da3648d4a1c75026b4c42690c7bf</anchor>
      <arglist>(const Scalar *data)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ei_matrix_storage&lt; Scalar, MaxSizeAtCompileTime, RowsAtCompileTime, ColsAtCompileTime, Options &gt;</type>
      <name>m_storage</name>
      <anchorfile>classEigen_1_1Matrix.html</anchorfile>
      <anchor>aed24d1237a5e08d080136132b13e8e29</anchor>
      <arglist></arglist>
    </member>
    <docanchor file="classEigen_1_1Matrix">fixedsize</docanchor>
    <docanchor file="classEigen_1_1Matrix">maxrows</docanchor>
    <docanchor file="classEigen_1_1Matrix">dense</docanchor>
  </compound>
  <compound kind="class">
    <name>Eigen::MatrixBase</name>
    <filename>classEigen_1_1MatrixBase.html</filename>
    <templarg>Derived</templarg>
    <member kind="enumvalue">
      <name>RowsAtCompileTime</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffa38ab482a62bf46f6ed6dcc4e9dd0dddf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ColsAtCompileTime</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffae943bdba893721a848dfcd03db756b22</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SizeAtCompileTime</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffab30be5c02d7a124ec165d2ab6c5b05ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MaxRowsAtCompileTime</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffa1264a9a69c437cbe0f8e723d88471c4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MaxColsAtCompileTime</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffac9998fd25639e32ba4d58d67bfff4420</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MaxSizeAtCompileTime</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffacf4ecb7db5a851c1ff90ae7621ab3fd1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IsVectorAtCompileTime</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffa7e22277c8f0a1a76dd0d6c62e366b59f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Flags</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffa96296863b401484bc191339414c90e6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CoeffReadCost</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa94c5fdcac6a4b26211b612c3edc04ffa17c43b803133ba4f73b417edcbfb8206</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const AdjointReturnType</type>
      <name>adjoint</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ac43d5834cffcedbd27777329a8f5eeca</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>all</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aea914316af61df197f21629e14e7870a</anchor>
      <arglist>(void) const </arglist>
      <docanchor file="classEigen_1_1MatrixBase">CwiseAll</docanchor>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>any</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a42571e028736ca9103bac8b50f269824</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const DiagonalMatrix&lt; Derived &gt;</type>
      <name>asDiagonal</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aaec3343396b8a39d1596a43d0d2c5303</anchor>
      <arglist>() const </arglist>
      <docanchor file="classEigen_1_1MatrixBase">AsDiagonalExample</docanchor>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; CustomBinaryOp, Derived, OtherDerived &gt;</type>
      <name>binaryExpr</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae022bf30f910d5d1b016c3d88f6af1ad</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other, const CustomBinaryOp &amp;func=CustomBinaryOp()) const </arglist>
      <docanchor file="classEigen_1_1MatrixBase">CustomCwiseBinaryFunctors</docanchor>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived, BlockRows, BlockCols &gt;::Type</type>
      <name>block</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a259b0f38d5b492dd1448e78542a0f683</anchor>
      <arglist>(int startRow, int startCol) const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived, BlockRows, BlockCols &gt;::Type</type>
      <name>block</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a02ac7cc94982a8c01e3208d9d8df47ab</anchor>
      <arglist>(int startRow, int startCol)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">BlockSubMatrixFixedSize</docanchor>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived &gt;::Type</type>
      <name>block</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa7e0b89cfac5d4be02b0ca8ac633197e</anchor>
      <arglist>(int startRow, int startCol, int blockRows, int blockCols) const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived &gt;::Type</type>
      <name>block</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ac1b9440fcf0b94542e60773ba5d3c2d1</anchor>
      <arglist>(int startRow, int startCol, int blockRows, int blockCols)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">BlockIntIntIntInt</docanchor>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_cast_op&lt; typename ei_traits&lt; Derived &gt;::Scalar, NewType &gt;, Derived &gt;</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae5ad49ef58badf00059632916cb12b2a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aeb33b895566f71a98f28359939527a55</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>af645bea3743fcaa43bbcaa2015b21530</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a0a66d15cf364072a54b581410d552c02</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>adfa3e1d676cd25694e4fede3437c171b</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>const ColXpr</type>
      <name>col</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a24b75b72a29cc837d7587582675fb070</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>ColXpr</type>
      <name>col</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae6cb4fcd84ced1360441a7b7e282dc0f</anchor>
      <arglist>(int i)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">BlockColumn</docanchor>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PartialRedux&lt; Derived, Vertical &gt;</type>
      <name>colwise</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ac08331a5160474a7adf402f7d3145258</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeInverse</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a08c315e91cee988fc450c35ed693fbe1</anchor>
      <arglist>(MatrixBase&lt; OtherDerived &gt; *result) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeInverse</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a2d0ae0ceffafbc4dbd34ca6205c40504</anchor>
      <arglist>(MatrixBase&lt; ResultType &gt; *result) const </arglist>
    </member>
    <member kind="function">
      <type>ConjugateReturnType</type>
      <name>conjugate</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ad35a9b8323261b1cd31b65f96d21d063</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived, CRows, CCols &gt;::Type</type>
      <name>corner</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a7a75612abaf757d97caa51a139200e50</anchor>
      <arglist>(CornerType type) const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived, CRows, CCols &gt;::Type</type>
      <name>corner</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>af755e6cbc0f9b851eb47ce2134f4ee17</anchor>
      <arglist>(CornerType type)</arglist>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived &gt;::Type</type>
      <name>corner</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>af34404960ef27785dc6f449ff1a4d0ae</anchor>
      <arglist>(CornerType type, int cRows, int cCols) const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived &gt;::Type</type>
      <name>corner</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a068af1e6b6e41cfb3ae77db25c9b0a5a</anchor>
      <arglist>(CornerType type, int cRows, int cCols)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">BlockCornerDynamicSize</docanchor>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a0745638c9967e2ed90bc96c012288c55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>PlainMatrixType</type>
      <name>cross</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae09fde9d844e0eb8248955b3a2754272</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Cwise&lt; Derived &gt;</type>
      <name>cwise</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a9f4f205b2ba2ba399d8e867d0b53f720</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Cwise&lt; Derived &gt;</type>
      <name>cwise</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a906977fa32914eafbd6bd5f83dbb19f4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>determinant</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a6f5ac4adf1dc104cc0956148614a9039</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const DiagonalCoeffs&lt; Derived &gt;</type>
      <name>diagonal</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a5007dfdf5651dd179278092cc8ac800d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DiagonalCoeffs&lt; Derived &gt;</type>
      <name>diagonal</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aad2bbc89f14495fcd18f1f23065b830c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>dot</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a4e96b0429788d5b34fc81c73ff7dab54</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>EigenvaluesReturnType</type>
      <name>eigenvalues</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a68d59007cb0a8acfcd24a5df6d83624d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived, Size &gt;::SubVectorType</type>
      <name>end</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a24da565adb52768513ebdf27a104b385</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived, Size &gt;::SubVectorType</type>
      <name>end</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1153ccc141fcc30baa605b4c67c693bc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived, Dynamic &gt;::SubVectorType</type>
      <name>end</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a350c79b8d7ae4830a9e7b9ee0bab8217</anchor>
      <arglist>(int size) const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived, Dynamic &gt;::SubVectorType</type>
      <name>end</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a0eaecd0b54807f1139738b520a20837c</anchor>
      <arglist>(int size)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">BlockEnd</docanchor>
    </member>
    <member kind="function">
      <type>Matrix&lt; Scalar, 3, 1 &gt;</type>
      <name>eulerAngles</name>
      <anchorfile>group__Geometry__Module.html</anchorfile>
      <anchor>ga087701690bd612a10b0b0c796553f29e</anchor>
      <arglist>(int a0, int a1, int a2) const </arglist>
    </member>
    <member kind="function">
      <type>const ei_eval&lt; Derived &gt;::type</type>
      <name>eval</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a6f160cb9b5446acbc5f481ec4404e3e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a98692bec8f3d859f1e7a60eab87ac571</anchor>
      <arglist>(const Scalar &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>const WithFormat&lt; Derived &gt;</type>
      <name>format</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa364b60e6a2a124ea7392e4c0550fb4e</anchor>
      <arglist>(const IOFormat &amp;fmt) const </arglist>
    </member>
    <member kind="function">
      <type>const ImagReturnType</type>
      <name>imag</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa96a8c75851da3600319b911a6b3959b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerSize</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a124752e160ea0b87f4b5fbd9b630b8ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PlainMatrixType</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a5782c3af36c3083685e4df868c201fc5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a730d00e2f6386dd5d82b8531ed4dc650</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa25e68370045ed7a2386e253ed8c0456</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other, RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApproxToConstant</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aee98804d7572ddb18e0506a9cb3eaa2e</anchor>
      <arglist>(const Scalar &amp;value, RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isConstant</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a0c98a8f642bda66dd57e37746f36a071</anchor>
      <arglist>(const Scalar &amp;value, RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isDiagonal</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a3d222837920bb5cd6f7b78db0f5324d9</anchor>
      <arglist>(RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isIdentity</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a84f6b7be1d0a4ed5df444a7277b9f53a</anchor>
      <arglist>(RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isLowerTriangular</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a3105b43b93f830668c3bb213c7c195fd</anchor>
      <arglist>(RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMuchSmallerThan</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a9e965ea084d696378d118f729e77229d</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMuchSmallerThan</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>acb1c124808d77a26b1879633853b5099</anchor>
      <arglist>(const typename NumTraits&lt; Scalar &gt;::Real &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMuchSmallerThan</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a9ebb02c198772d5a979a972755c6a2e0</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other, RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMuchSmallerThan</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>afde1b6a24b08e00238634c667bb3890d</anchor>
      <arglist>(const RealScalar &amp;other, RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isOnes</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1c70e2502c2d7be0341dee1019d9f1ec</anchor>
      <arglist>(RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isOrthogonal</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa321b2d791665a2eecbdafc1b5f01221</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other, RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isUnitary</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a282f28a8bda739e2fe9d862e73d3e330</anchor>
      <arglist>(RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isUpperTriangular</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a81b3001da9f283d0a55c8ef55807b747</anchor>
      <arglist>(RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isVector</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a6ed9d8dbec28bf8536105047dc8f375e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isZero</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a5552346fc6fc53b4bd800dccc2eb5dc6</anchor>
      <arglist>(RealScalar prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>const Flagged&lt; Derived, 0, EvalBeforeNestingBit|EvalBeforeAssigningBit &gt;</type>
      <name>lazy</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa72415bd9a4b1356f1a4ee99b7f816e1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>lazyAssign</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aeb3c1d6d131708e3c66c27a5a065129a</anchor>
      <arglist>(const SparseProduct&lt; Lhs, Rhs, DenseTimeSparseProduct &gt; &amp;product)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>lazyAssign</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a96d06b3233149582c94fcd42ebbe265e</anchor>
      <arglist>(const SparseProduct&lt; Lhs, Rhs, SparseTimeDenseProduct &gt; &amp;product)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>lazyAssign</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a77a2979ccd147ac70865d8b0ad075d1c</anchor>
      <arglist>(const Product&lt; Lhs, Rhs, CacheFriendlyProduct &gt; &amp;product)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>lazyAssign</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a589859495cdfee5953a999598d54cac4</anchor>
      <arglist>(const SparseProduct&lt; Derived1, Derived2, DenseTimeSparseProduct &gt; &amp;product)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>lazyAssign</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a2eacfd071d63e1cdc83a3957f62a783b</anchor>
      <arglist>(const SparseProduct&lt; Derived1, Derived2, SparseTimeDenseProduct &gt; &amp;product)</arglist>
    </member>
    <member kind="function">
      <type>const LDLT&lt; PlainMatrixType &gt;</type>
      <name>ldlt</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ac7fc1c7a34877aa85903238f23bf913d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const LLT&lt; PlainMatrixType &gt;</type>
      <name>llt</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a766155ab83d7d0f570b04be33f6c636e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>lpNorm</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a8fbbec1c2e35c8e4004b5706c41c5b77</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const LU&lt; PlainMatrixType &gt;</type>
      <name>lu</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a7e712209da6215811579341f2e551076</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Flagged&lt; Derived, Added, 0 &gt;</type>
      <name>marked</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a234c226a30d258a7cc49bcfe621d5394</anchor>
      <arglist>() const </arglist>
      <docanchor file="classEigen_1_1MatrixBase">MarkExample</docanchor>
    </member>
    <member kind="function">
      <type>ei_traits&lt; Derived &gt;::Scalar</type>
      <name>maxCoeff</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a601f8d499ae291cab3eec06a8dcae4a9</anchor>
      <arglist>(int *index) const </arglist>
    </member>
    <member kind="function">
      <type>ei_traits&lt; Derived &gt;::Scalar</type>
      <name>maxCoeff</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>af272ec0e497286f5581b67cf5c8dda76</anchor>
      <arglist>(int *row, int *col) const </arglist>
    </member>
    <member kind="function">
      <type>ei_traits&lt; Derived &gt;::Scalar</type>
      <name>maxCoeff</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1bad7616c278fa82120ef41f47c33dd1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ei_traits&lt; Derived &gt;::Scalar</type>
      <name>minCoeff</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aff915fbfcc7728b515eb8a68623fdd52</anchor>
      <arglist>(int *index) const </arglist>
    </member>
    <member kind="function">
      <type>ei_traits&lt; Derived &gt;::Scalar</type>
      <name>minCoeff</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a81cf9b9d698d2d9bd05fabb21933aa57</anchor>
      <arglist>(int *row, int *col) const </arglist>
    </member>
    <member kind="function">
      <type>ei_traits&lt; Derived &gt;::Scalar</type>
      <name>minCoeff</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>abcee706b351ceea87fe8ec01ca8c7b80</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Minor&lt; Derived &gt;</type>
      <name>minor</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a354600a8b2cbdba292831d2ed9c0980f</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Minor&lt; Derived &gt;</type>
      <name>minor</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a71d337e08d1d9d0733c3ae89bb8e47d3</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>const NestByValue&lt; Derived &gt;</type>
      <name>nestByValue</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a324b9263b40738a260d46ff011b8d31b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nonZeros</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aacaa48cbf79ea5dadaa66ca36bb29bf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>norm</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>af8ee22f575671cee1ed7263ce5e83f0a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>normalize</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>acd0de676568888d848beb97dcc53ae47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const PlainMatrixType</type>
      <name>normalized</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a256fc669d12e5fc902a763248d0fd161</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>acd24a990ef9e1637c8c949ed7782c913</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>operator()</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a7637e26f0beebde0885cf3cbc9a0ced2</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>operator()</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae21fc94f107091857a6e88891ab661a2</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>operator()</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ac24d58e4659f72129bf24d52d8d6d0a9</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>operator()</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a416464558df059e32c699e8018db7d5c</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>const ProductReturnType&lt; Derived, OtherDerived &gt;::Type</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a9e1bd40c9a6c6d511a374766d0a20baf</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const ScalarMultipleReturnType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae8ab11fb1ef0822aa61527f7ecd77b9d</anchor>
      <arglist>(const Scalar &amp;scalar) const </arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a64d1fcb6312c996643c3fd27b24208c3</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae339381c643e4ed8eaac81755c35532b</anchor>
      <arglist>(const Scalar &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; ei_scalar_sum_op&lt; typename ei_traits&lt; Derived &gt;::Scalar &gt;, Derived, OtherDerived &gt;</type>
      <name>operator+</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a38fa4739859ca9d430d8a2a6d632b91c</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator+=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>adcd49c85a1d222ce114b981766657579</anchor>
      <arglist>(const Flagged&lt; Product&lt; Lhs, Rhs, CacheFriendlyProduct &gt;, 0, EvalBeforeNestingBit|EvalBeforeAssigningBit &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator+=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a31f05f322a9706d0549fa846eff3348a</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>const CwiseBinaryOp&lt; ei_scalar_difference_op&lt; typename ei_traits&lt; Derived &gt;::Scalar &gt;, Derived, OtherDerived &gt;</type>
      <name>operator-</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a5a2e9b4fcf3ba39a6e74c7187e1cbad7</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_opposite_op&lt; typename ei_traits&lt; Derived &gt;::Scalar &gt;, Derived &gt;</type>
      <name>operator-</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a7bae095ab36844f106f863cbc8f76180</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator-=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a2566e1b29a48a2e496dc8d47dd5550d1</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; ei_scalar_quotient1_op&lt; typename ei_traits&lt; Derived &gt;::Scalar &gt;, Derived &gt;</type>
      <name>operator/</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a9ad9d9a4f318dd9d28fc0256c3b45e9d</anchor>
      <arglist>(const Scalar &amp;scalar) const </arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator/=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a18e0c799d4dbc351465fb2d8964a6913</anchor>
      <arglist>(const Scalar &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CommaInitializer&lt; Derived &gt;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aaa3146643d53a968c320e5a36ae62995</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CommaInitializer&lt; Derived &gt;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ade5d2e09de50c2ca145037f295542b16</anchor>
      <arglist>(const Scalar &amp;s)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">CommaInit</docanchor>
      <docanchor file="classEigen_1_1MatrixBase">MatrixBaseCommaInitRef</docanchor>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>afb5f6dbb48478231af93b1f4d3a5c6af</anchor>
      <arglist>(const MatrixBase &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a906e540b7c2e7e9d399aad7f93f098ca</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a169d9284b48ec7daf8d8236542b467e5</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>operator[]</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a3423834c25914b3e287f577df184ad24</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>operator[]</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a429adea9d332454866da0c0307ea99dd</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>operatorNorm</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ac316d3eb36915b669aa07210adbd4265</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>outerSize</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ab0a84319855a030cd5446a2ed38b500c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1c50f7699d052ea6cde67b8704bbf243</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a078cf7e0f99fc729cbe7a2c623b5c82c</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>const Part&lt; Derived, Mode &gt;</type>
      <name>part</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1b36c6b7b8cf8178e23e81b52d54fa71</anchor>
      <arglist>() const </arglist>
      <docanchor file="classEigen_1_1MatrixBase">PartExample</docanchor>
    </member>
    <member kind="function">
      <type>Part&lt; Derived, Mode &gt;</type>
      <name>part</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ad837e1a3b250b8375cbfd079585c23ee</anchor>
      <arglist>()</arglist>
      <docanchor file="classEigen_1_1MatrixBase">PartExample</docanchor>
    </member>
    <member kind="function">
      <type>const QR&lt; PlainMatrixType &gt;</type>
      <name>qr</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1774ba38cdfdff568db95ff03d0ff211</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const RealReturnType</type>
      <name>real</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ad2b0d3593e734975e2d0e137a5ce1ecb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const RowXpr</type>
      <name>row</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a5afdd33e4ea64918cd65ba06b547f2d3</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>RowXpr</type>
      <name>row</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae51fe9cef1d2c30bd5172a4ebb0a0875</anchor>
      <arglist>(int i)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">BlockRow</docanchor>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PartialRedux&lt; Derived, Horizontal &gt;</type>
      <name>rowwise</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1bcbe189b52d25bffc02e40a77ea4f74</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived, Size &gt;::SubVectorType</type>
      <name>segment</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a7bd9cc8b836f273af648a26e9e537ba0</anchor>
      <arglist>(int start) const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived, Size &gt;::SubVectorType</type>
      <name>segment</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ac8654bddaa97098d6cb320cc9a7d1b77</anchor>
      <arglist>(int start)</arglist>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived &gt;::SubVectorType</type>
      <name>segment</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a96bf81e2f9e81b2cff4887dbe5fd8b22</anchor>
      <arglist>(int start, int size) const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived &gt;::SubVectorType</type>
      <name>segment</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a4d9f2188195e410a09ea180032d6b9a1</anchor>
      <arglist>(int start, int size)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">SegmentIntInt</docanchor>
    </member>
    <member kind="function">
      <type>const Select&lt; Derived, NestByValue&lt; typename ElseDerived::ConstantReturnType &gt;, ElseDerived &gt;</type>
      <name>select</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a7a6f6614ad709c847d3b19930cd5cc7a</anchor>
      <arglist>(typename ElseDerived::Scalar thenScalar, const MatrixBase&lt; ElseDerived &gt; &amp;elseMatrix) const </arglist>
    </member>
    <member kind="function">
      <type>const Select&lt; Derived, ThenDerived, NestByValue&lt; typename ThenDerived::ConstantReturnType &gt; &gt;</type>
      <name>select</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a053273722a7e70b488cfef80b78d3e12</anchor>
      <arglist>(const MatrixBase&lt; ThenDerived &gt; &amp;thenMatrix, typename ThenDerived::Scalar elseScalar) const </arglist>
    </member>
    <member kind="function">
      <type>const Select&lt; Derived, ThenDerived, ElseDerived &gt;</type>
      <name>select</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a6e0f1b2f47ac0ab140e1fb24a4884807</anchor>
      <arglist>(const MatrixBase&lt; ThenDerived &gt; &amp;thenMatrix, const MatrixBase&lt; ElseDerived &gt; &amp;elseMatrix) const </arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>setConstant</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a351ca566980cf96d9cdd61f3ce0cf94f</anchor>
      <arglist>(const Scalar &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>setIdentity</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>af1b15ae4c6f69b7324dd8ef70089dfc3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>setOnes</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a196e62ee8a1fc3b4af631e955d650cfc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>setRandom</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ab795c242db18862f502dfd9fa625c504</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>setZero</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a9053ca03ac251002768a54742be28fce</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ab8e4e3e2a7bf18888b71bdf9dda0770b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ei_plain_matrix_type_column_major&lt; OtherDerived &gt;::type</type>
      <name>solveTriangular</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a89efaba57cb2952b65868b4d679ce954</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
      <docanchor file="classEigen_1_1MatrixBase">SolveTriangular</docanchor>
    </member>
    <member kind="function">
      <type>void</type>
      <name>solveTriangularInPlace</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a23170e95af16e164b1c7f9f37191ae16</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>squaredNorm</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ab74a8fd24342d6bff527fab209de4299</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived, Size &gt;::SubVectorType</type>
      <name>start</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a8039cf5fbbec8b38f47ad1612ae74ce5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived, Size &gt;::SubVectorType</type>
      <name>start</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a4b1533cc1dc731ad8b098b6917f84392</anchor>
      <arglist>(void)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">BlockStart</docanchor>
    </member>
    <member kind="function">
      <type>const BlockReturnType&lt; Derived, Dynamic &gt;::SubVectorType</type>
      <name>start</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a700f3324bb2601289462c64adf8a006b</anchor>
      <arglist>(int size) const </arglist>
    </member>
    <member kind="function">
      <type>BlockReturnType&lt; Derived, Dynamic &gt;::SubVectorType</type>
      <name>start</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a56cb50eb0e6f63ecc8b67e0a23698f68</anchor>
      <arglist>(int size)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">BlockInt</docanchor>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stride</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>acab40bcf2fda12b7b73b37abb7afe7e0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>sum</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1a929bf7ed2da1ce69567ea8f5500c9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SVD&lt; PlainMatrixType &gt;</type>
      <name>svd</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>add5a743c34ce3bf47fcfe77534628f0b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a8a1ea9f6b79803b063c022aa87376ca6</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>trace</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a478ae1d313e948b268930a75806534b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Eigen::Transpose&lt; Derived &gt;</type>
      <name>transpose</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>afe7d72d54fe934999bd88e6d06265943</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Eigen::Transpose&lt; Derived &gt;</type>
      <name>transpose</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a3c187c30922fc5e42f208ae3eb0970ee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transposeInPlace</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a3689faf485a5e405a4fc9bf0e05564c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const CwiseUnaryOp&lt; CustomUnaryOp, Derived &gt;</type>
      <name>unaryExpr</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a1d1835f182c0141dc073a1045c8a2e9e</anchor>
      <arglist>(const CustomUnaryOp &amp;func=CustomUnaryOp()) const </arglist>
      <docanchor file="classEigen_1_1MatrixBase">CustomCwiseUnaryFunctors</docanchor>
    </member>
    <member kind="function">
      <type>PlainMatrixType</type>
      <name>unitOrthogonal</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a0a57cf2bff5c65a9e750d40c242779fc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a27a76ec18b16b75e0fab691c3a027575</anchor>
      <arglist>(Visitor &amp;func) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>w</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>abfa2f5be6b1ab016838f572b5b1a24a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>w</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aebb9ee81c2621bd09f29b312ec961ff1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a9591e7d3bf512fdd14b0d43f8f9ede7f</anchor>
      <arglist>(int index, const typename ei_packet_traits&lt; typename ei_traits&lt; Derived &gt;::Scalar &gt;::type &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a90dc8246780431cfb9f461818405500d</anchor>
      <arglist>(int row, int col, const typename ei_packet_traits&lt; typename ei_traits&lt; Derived &gt;::Scalar &gt;::type &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>afe4aad896c0826549cafd17ed9bc21af</anchor>
      <arglist>(int index, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a6a38e68d9cae6812636583ccaacbef11</anchor>
      <arglist>(int row, int col, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>x</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a722402e70c4a7edff949a6a92e076914</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>x</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ad8214e0ab7ecaed3fc38f5c1e6c2b017</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>y</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a93cf83437d8a8543806556d8c20a8e61</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>y</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a28fdac94d97a080d7827c12a416b42ed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>z</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa9c3af7b831e7ca782db4b08e4776723</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>z</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a84eec5f149ec2aed7ffe6080b76f7d79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Constant</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aca106133b09d5ea867a668c52e398397</anchor>
      <arglist>(const Scalar &amp;value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Constant</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aac5926ecfc1b903fa5794f0a6f28dd58</anchor>
      <arglist>(int size, const Scalar &amp;value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Constant</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a8c876bf139ea2ea1a2439197de71a34d</anchor>
      <arglist>(int rows, int cols, const Scalar &amp;value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const IdentityReturnType</type>
      <name>Identity</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a8ddce11b0f483486c5bbb25776ece6b9</anchor>
      <arglist>(int rows, int cols)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">Identity</docanchor>
    </member>
    <member kind="function" static="yes">
      <type>static const IdentityReturnType</type>
      <name>Identity</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a0650b65c6ae6c3d19a138b72a6d68568</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const CwiseNullaryOp&lt; CustomNullaryOp, Derived &gt;</type>
      <name>NullaryExpr</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a79e88797d4fbc0edcff21729289df7dd</anchor>
      <arglist>(const CustomNullaryOp &amp;func)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const CwiseNullaryOp&lt; CustomNullaryOp, Derived &gt;</type>
      <name>NullaryExpr</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aa9ad05f2787b6aa5d5b64c9314bc2ad9</anchor>
      <arglist>(int size, const CustomNullaryOp &amp;func)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const CwiseNullaryOp&lt; CustomNullaryOp, Derived &gt;</type>
      <name>NullaryExpr</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a11772fd9938947c0221894d8008a7ecc</anchor>
      <arglist>(int rows, int cols, const CustomNullaryOp &amp;func)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Ones</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae0e2f77d9f39aa59ca8b713b0e00cbfc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Ones</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a3cb6ceea69b2c7fbb2bc754214999a91</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Ones</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae77d9cc313732ae56e473050399afa3d</anchor>
      <arglist>(int rows, int cols)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">One</docanchor>
    </member>
    <member kind="function" static="yes">
      <type>static const CwiseNullaryOp&lt; ei_scalar_random_op&lt; Scalar &gt;, Derived &gt;</type>
      <name>Random</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae684f5171eb4058fad5e8cd32c2f0418</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const CwiseNullaryOp&lt; ei_scalar_random_op&lt; Scalar &gt;, Derived &gt;</type>
      <name>Random</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a559a6a34881de37bc4b2c1908edd7c05</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const CwiseNullaryOp&lt; ei_scalar_random_op&lt; Scalar &gt;, Derived &gt;</type>
      <name>Random</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a40fa9d297730a7100c74ecd7d2883776</anchor>
      <arglist>(int rows, int cols)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">RandomExample</docanchor>
    </member>
    <member kind="function" static="yes">
      <type>static const BasisReturnType</type>
      <name>Unit</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>abd85d2a05a6c4fa499b59e4809369986</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const BasisReturnType</type>
      <name>Unit</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a714d4d54761b91cc66cd561e277675c8</anchor>
      <arglist>(int size, int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const BasisReturnType</type>
      <name>UnitW</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a585b3898eb4f52adce6b7025fb8fb429</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const BasisReturnType</type>
      <name>UnitX</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a5e0e42c39330e4274d2d0479048ebc37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const BasisReturnType</type>
      <name>UnitY</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>abc925a22c4f4b48b5b10fa90924f14c1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const BasisReturnType</type>
      <name>UnitZ</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a135f14351a7213bf0b764272c14ca68c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Zero</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>ae9cdecf0d3cbed8ec68146479023bccb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Zero</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a7ac920b3f252a3a115a60d6bd0cd8dc9</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const ConstantReturnType</type>
      <name>Zero</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a8d088adf15475ce181576589c6824a44</anchor>
      <arglist>(int rows, int cols)</arglist>
      <docanchor file="classEigen_1_1MatrixBase">Zero</docanchor>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MatrixBase</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>aab6feeb032f73d67bf225d1320e881c6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend">
      <type>friend const CwiseUnaryOp&lt; ei_scalar_multiple_op&lt; typename ei_traits&lt; Derived &gt;::Scalar &gt;, Derived &gt;</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a2e1af96a2e534ace0776ddb297c8de0b</anchor>
      <arglist>(const Scalar &amp;scalar, const MatrixBase &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classEigen_1_1MatrixBase.html</anchorfile>
      <anchor>a3643c0c4836c9fe7e073de53195f63f7</anchor>
      <arglist>(std::ostream &amp;s, const MatrixBase&lt; Derived &gt; &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Minor</name>
    <filename>classEigen_1_1Minor.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Minor.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Minor.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1Minor.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Minor</name>
      <anchorfile>classEigen_1_1Minor.html</anchorfile>
      <anchor>a239b352f15d8c5e39bb8d0558f13c707</anchor>
      <arglist>(const MatrixType &amp;matrix, int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1Minor.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const int</type>
      <name>m_col</name>
      <anchorfile>classEigen_1_1Minor.html</anchorfile>
      <anchor>ab6a8a49a94422f7003fd081f81865b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MatrixType::Nested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1Minor.html</anchorfile>
      <anchor>aa213d3c4337a578d57ada1869f65e55e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const int</type>
      <name>m_row</name>
      <anchorfile>classEigen_1_1Minor.html</anchorfile>
      <anchor>a7076fc3fc01dad2da556da0802700af4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::NestByValue</name>
    <filename>classEigen_1_1NestByValue.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>ac244dc54675046d04a0fde51485f83ef</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NestByValue</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a9217f7566331226b01e2c984443a7624</anchor>
      <arglist>(const ExpressionType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a189ce98791b46dfcb2143824afd6bad0</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a25a22be95c6dbeaaedeefa2ff1c86044</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stride</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a2f0529f7f5ff03b8a26e3a3d1925bb2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>afe4aad896c0826549cafd17ed9bc21af</anchor>
      <arglist>(int index, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>a6a38e68d9cae6812636583ccaacbef11</anchor>
      <arglist>(int row, int col, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ExpressionType</type>
      <name>m_expression</name>
      <anchorfile>classEigen_1_1NestByValue.html</anchorfile>
      <anchor>ad0e5954004cd4f842177d7c98d192c93</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::ParametrizedLine</name>
    <filename>classEigen_1_1ParametrizedLine.html</filename>
    <templarg></templarg>
    <templarg>_AmbientDim</templarg>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, AmbientDimAtCompileTime, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ad05514d010d3df4bdb8a28accaaed19f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; ParametrizedLine, ParametrizedLine&lt; NewScalarType, AmbientDimAtCompileTime &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a1415ccc23ae8a3910f4b19dd5c424b9f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dim</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a57840c996d92c9162995c5fbd8ab1bd1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>VectorType &amp;</type>
      <name>direction</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a7f4c25d6c477394b60916e6c42c347e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const VectorType &amp;</type>
      <name>direction</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ae89bdd6d3aaacab13f4694184bddd616</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>distance</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a07e68c35a13ec165902e8f5e670acd26</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>intersection</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a33b3eb8a17bb64d25c398bfdde80e896</anchor>
      <arglist>(const Hyperplane&lt; _Scalar, _AmbientDim &gt; &amp;hyperplane)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a15a41116a58282edf412dd163c8fd0d4</anchor>
      <arglist>(const ParametrizedLine &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>VectorType &amp;</type>
      <name>origin</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a6a6d07fbddcf71140e3d0ca52db44458</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const VectorType &amp;</type>
      <name>origin</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ad86eaa995a9ac942bec99849c833064e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ParametrizedLine</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ab27c92fa45cb7cf42c35b00ee55bd09d</anchor>
      <arglist>(const ParametrizedLine&lt; OtherScalarType, AmbientDimAtCompileTime &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ParametrizedLine</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ac6ebf92d1ba59f97e1e66855b4c6c17a</anchor>
      <arglist>(const Hyperplane&lt; _Scalar, _AmbientDim &gt; &amp;hyperplane)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ParametrizedLine</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>aaaa6ea65c420bb90c2a98719ea17074f</anchor>
      <arglist>(const VectorType &amp;origin, const VectorType &amp;direction)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ParametrizedLine</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a036d9f2f5609cfc72a4926ec024e8fa5</anchor>
      <arglist>(int _dim)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ParametrizedLine</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ac5c2ec38035eb882c02df80d7e94c2a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>VectorType</type>
      <name>projection</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ac93039c47cde2b60b29d99f3e1a7dc71</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>squaredDistance</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ac1a8c756c2619371a35f80e062a16deb</anchor>
      <arglist>(const VectorType &amp;p) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ParametrizedLine</type>
      <name>Through</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>af9509e5253a2b64d8be3a2c3a59395b4</anchor>
      <arglist>(const VectorType &amp;p0, const VectorType &amp;p1)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorType</type>
      <name>m_direction</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>a660d8a5b522315dceff17cd8797bcf59</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorType</type>
      <name>m_origin</name>
      <anchorfile>classEigen_1_1ParametrizedLine.html</anchorfile>
      <anchor>ad5651cc0bf2c728efd0b80c1c32af178</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Part</name>
    <filename>classEigen_1_1Part.html</filename>
    <templarg></templarg>
    <templarg>Mode</templarg>
    <member kind="function">
      <type>const MatrixType &amp;</type>
      <name>_expression</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>af2fe0d3a5766be2a4cb386173be46246</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>af2b14e136cbed0bd5fbd5e72a08d3187</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>const Block&lt; Part, RowsAtCompileTime, 1 &gt;</type>
      <name>col</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a66ab4e3ed515cd1e7077d57db78e1591</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>const Block&lt; Part, RowsAtCompileTime, 1 &gt;</type>
      <name>col</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a477163a3fc6f491d64e4545e2aae1ce6</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lazyAssign</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a7047c1cf6ddcf448b7a42434edec9435</anchor>
      <arglist>(const Other &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Part &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>ac33a39ef6a345325c85120b4df379cbf</anchor>
      <arglist>(const typename ei_traits&lt; MatrixType &gt;::Scalar &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Part &amp;</type>
      <name>operator+=</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a908d59224ff365327344edf8d11eff5d</anchor>
      <arglist>(const Other &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Part &amp;</type>
      <name>operator-=</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a582224a73dcdec9608c28d4185f1b31f</anchor>
      <arglist>(const Other &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Part &amp;</type>
      <name>operator/=</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a3b2184f6734439735501e990cc5f9986</anchor>
      <arglist>(const typename ei_traits&lt; MatrixType &gt;::Scalar &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Part &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a3bcbac2560ee9ddebb1ac977ab2828bd</anchor>
      <arglist>(const Other &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Part</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>afb98afe902499b8e03443c2306c280d2</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const Block&lt; Part, 1, ColsAtCompileTime &gt;</type>
      <name>row</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a419ee5483b426cd3ef74da9116ad2a7e</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>const Block&lt; Part, 1, ColsAtCompileTime &gt;</type>
      <name>row</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a4e349a3e96c7bd8d77320fc1f878fbb6</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stride</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a2f0529f7f5ff03b8a26e3a3d1925bb2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>a8a1ea9f6b79803b063c022aa87376ca6</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MatrixType::Nested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1Part.html</anchorfile>
      <anchor>aa213d3c4337a578d57ada1869f65e55e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::PartialRedux</name>
    <filename>classEigen_1_1PartialRedux.html</filename>
    <templarg></templarg>
    <templarg>Direction</templarg>
    <member kind="typedef">
      <type>ExpressionType::PlainMatrixType</type>
      <name>CrossReturnType</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a0a655904ced26621d868aa852ddaf231</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_meta_if&lt; ei_must_nest_by_value&lt; ExpressionType &gt;::ret, ExpressionType, const ExpressionType &amp; &gt;::ret</type>
      <name>ExpressionTypeNested</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a78faa66fa13262945677052387be284a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_traits&lt; ExpressionType &gt;::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a2b4634ec663cff58bb04711491b69415</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const ExpressionType &amp;</type>
      <name>_expression</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>ab1cd1649c2f88524d95bd7b399121b68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const ReturnType&lt; ei_member_all &gt;::Type</type>
      <name>all</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>ab2afe8b3074f270510a79495b56f055c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const ReturnType&lt; ei_member_any &gt;::Type</type>
      <name>any</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>acd4fcda0b849ad5acc9a472b6c97776c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PartialReduxExpr&lt; ExpressionType, ei_member_count&lt; int &gt;, Direction &gt;</type>
      <name>count</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a04c03ed6dafd5bf2a3956e9e8b52438f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CrossReturnType</type>
      <name>cross</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a80f8897f4ea55db5e9c822ad32063dfb</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const ReturnType&lt; ei_member_maxCoeff &gt;::Type</type>
      <name>maxCoeff</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a6af617851b4cf692997ab646b29b0d4f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const ReturnType&lt; ei_member_minCoeff &gt;::Type</type>
      <name>minCoeff</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a4ab049f1b5a5ff3b19fa18f505461c70</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const ReturnType&lt; ei_member_norm, RealScalar &gt;::Type</type>
      <name>norm</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>ad0e339bdb4cd3e30b98532c17d5a5c07</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PartialRedux</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a9fa52fd4042cc3ebbba5e1a6793a5107</anchor>
      <arglist>(const ExpressionType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const ReduxReturnType&lt; BinaryOp &gt;::Type</type>
      <name>redux</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a92a10cb1b858617dd5ca08b8f4b00f25</anchor>
      <arglist>(const BinaryOp &amp;func=BinaryOp()) const </arglist>
    </member>
    <member kind="function">
      <type>const ReturnType&lt; ei_member_squaredNorm, RealScalar &gt;::Type</type>
      <name>squaredNorm</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a682d1fe247051738d22ca0339e2a09a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const ReturnType&lt; ei_member_sum &gt;::Type</type>
      <name>sum</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>aec183501c7483805346a80cee521c8b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ExpressionTypeNested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1PartialRedux.html</anchorfile>
      <anchor>a885783fe5a6c8184c0119a14eb9961fc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::PartialReduxExpr</name>
    <filename>classEigen_1_1PartialReduxExpr.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg>Direction</templarg>
    <member kind="typedef">
      <type>ei_traits&lt; PartialReduxExpr &gt;::_MatrixTypeNested</type>
      <name>_MatrixTypeNested</name>
      <anchorfile>classEigen_1_1PartialReduxExpr.html</anchorfile>
      <anchor>aeafc5099429ac34bdaf14ed76ae32de3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_traits&lt; PartialReduxExpr &gt;::MatrixTypeNested</type>
      <name>MatrixTypeNested</name>
      <anchorfile>classEigen_1_1PartialReduxExpr.html</anchorfile>
      <anchor>ad54545f4e9ad773515e05fa982d84cb7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1PartialReduxExpr.html</anchorfile>
      <anchor>a825aef1450de328cbd032978c31c1112</anchor>
      <arglist>(int i, int j) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1PartialReduxExpr.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PartialReduxExpr</name>
      <anchorfile>classEigen_1_1PartialReduxExpr.html</anchorfile>
      <anchor>a9f0f1cead789479383447fef738fa202</anchor>
      <arglist>(const MatrixType &amp;mat, const MemberOp &amp;func=MemberOp())</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1PartialReduxExpr.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MemberOp</type>
      <name>m_functor</name>
      <anchorfile>classEigen_1_1PartialReduxExpr.html</anchorfile>
      <anchor>a67b362e330c16c4eac80b1ac0b9b4e5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MatrixTypeNested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1PartialReduxExpr.html</anchorfile>
      <anchor>a9d2eab26c85824ebdd480b3099fea906</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Product</name>
    <filename>classEigen_1_1Product.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg>ProductMode</templarg>
    <member kind="function">
      <type>void</type>
      <name>_cacheFriendlyEvalAndAdd</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>ae1df8acc5e2ef4e6e2cab923cc467b2d</anchor>
      <arglist>(DestDerived &amp;res) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_useCacheFriendlyProduct</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a5219906dd1aef194a2e0ed228363c108</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const _LhsNested &amp;</type>
      <name>lhs</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a1ab2b47535692481285a998525d0c646</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a25a22be95c6dbeaaedeefa2ff1c86044</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Product</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a8d51a28c64552c75f3189f1c3782d12e</anchor>
      <arglist>(const Lhs &amp;lhs, const Rhs &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>const _RhsNested &amp;</type>
      <name>rhs</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a3483b038d185d8b507d26104094c5996</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const LhsNested</type>
      <name>m_lhs</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>ae1caf29b04271234ea499ae96c8d4ba3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const RhsNested</type>
      <name>m_rhs</name>
      <anchorfile>classEigen_1_1Product.html</anchorfile>
      <anchor>a4ded68608647d72c0180d78485e851bd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::ProductReturnType</name>
    <filename>structEigen_1_1ProductReturnType.html</filename>
    <templarg>Lhs</templarg>
    <templarg>Rhs</templarg>
    <templarg>ProductMode</templarg>
    <member kind="typedef">
      <type>ei_nested&lt; Lhs, Rhs::ColsAtCompileTime &gt;::type</type>
      <name>LhsNested</name>
      <anchorfile>structEigen_1_1ProductReturnType.html</anchorfile>
      <anchor>ae73b52d7184ce161d6a908f7e4dcc657</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_nested&lt; Rhs, Lhs::RowsAtCompileTime &gt;::type</type>
      <name>RhsNested</name>
      <anchorfile>structEigen_1_1ProductReturnType.html</anchorfile>
      <anchor>a2251596f0ef9657c64853eeca3d0bd97</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Product&lt; LhsNested, RhsNested, ProductMode &gt;</type>
      <name>Type</name>
      <anchorfile>structEigen_1_1ProductReturnType.html</anchorfile>
      <anchor>a4048c6178fee474bb6871e59b0775e5b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::QR</name>
    <filename>classEigen_1_1QR.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>Block&lt; MatrixType, MatrixType::ColsAtCompileTime, MatrixType::ColsAtCompileTime &gt;</type>
      <name>MatrixRBlockType</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a4a3211b0fb5ce840e8e8c1f5bc7f84f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, MatrixType::ColsAtCompileTime, MatrixType::ColsAtCompileTime &gt;</type>
      <name>MatrixTypeR</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a351e70faefec7e416fa6323c31639b79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType::RealScalar</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a7aed5ea125c7ad59048fe8a5ccdbdf5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, MatrixType::ColsAtCompileTime, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a7f4af69eabe67230f4d72b7b8a7ee915</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dimensionOfKernel</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a982993bdfdcd8f2001aceaa68f334912</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EIGEN_DEPRECATED bool</type>
      <name>isFullRank</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a59bd474bc5b18075d0448f3b5984dc5e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInjective</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a1e119085e53eca65e9ba15451c102d40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInvertible</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>ab60c7d993c9eba31668fb8886d621094</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSurjective</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a5968b9ca46303b3cc7250e7b120ab7e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>matrixQ</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>af4fa91230d8a9771f667fe0dbcb69746</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const Part&lt; NestByValue&lt; MatrixRBlockType &gt;, UpperTriangular &gt;</type>
      <name>matrixR</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>aaa4f8bbbf86dc356394fc4ac59a21bf6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QR</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a32111868ececa7685f8bacccb1fe3a94</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QR</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a5cac64d1ffd05a38b1a8f936f6d94589</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rank</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>ae59754aa54d2ee843c39aebc1de9cfb1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solve</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>acf22c329a5c3d713a20c4ab0558014b3</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;b, ResultType *result) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorType</type>
      <name>m_hCoeffs</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a03de91f8e567069a34d9de0844e17529</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_isInitialized</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a217245eec26f69d0c5b6e991937de95a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_qr</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a1940b15f6e13851c1af9d3d30016331f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_rank</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>ac6a822dc76382e4027cf94ac3e510056</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_rankIsUptodate</name>
      <anchorfile>classEigen_1_1QR.html</anchorfile>
      <anchor>a66c1c29921cfda5c5ddcbd6258de7d51</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Quaternion</name>
    <filename>classEigen_1_1Quaternion.html</filename>
    <templarg>_Scalar</templarg>
    <member kind="typedef">
      <type>AngleAxis&lt; Scalar &gt;</type>
      <name>AngleAxisType</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ac8cbb66bbccf5f2c9596004a14129c26</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, 4, 1 &gt;</type>
      <name>Coefficients</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ab3d37e64d55c89035ddbcec573090cb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, 3, 3 &gt;</type>
      <name>Matrix3</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>abdb0743d0fe840b927780b2bd78fb29e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, 3, 1 &gt;</type>
      <name>Vector3</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ab05eeebdd63f50a52fecb6353018075f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>angularDistance</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a0ca3ce81b69e7ec51a1b0d8ed0c14990</anchor>
      <arglist>(const Quaternion &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; Quaternion, Quaternion&lt; NewScalarType &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>aa1105a3c3c3646a8a882a6449fcd5b24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Coefficients &amp;</type>
      <name>coeffs</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a1617ce16af4ff4c65d2155848f2ea161</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Coefficients &amp;</type>
      <name>coeffs</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a67d7e844f940f6ca2673eadacaf08b3b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Quaternion</type>
      <name>conjugate</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a4bd316bee99163d192a5e932d2bb3ad4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>dot</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>aac795df050713c38fcddde080b660dab</anchor>
      <arglist>(const Quaternion &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Quaternion</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a7b237a159bd417939680ac00d0c7ecc3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a77bbf6cfed9a4c628d522e7de7635e3c</anchor>
      <arglist>(const Quaternion &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>norm</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>aa2bb33b2ed836350b02a6b9083bf8b5b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>normalize</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>acd0de676568888d848beb97dcc53ae47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Quaternion</type>
      <name>normalized</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ae347ecf6e0a78618e8fd1a3b9107df32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Vector3</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ae6b9fbe382a171200ee5f3c02b6433ca</anchor>
      <arglist>(const MatrixBase&lt; Derived &gt; &amp;vec) const </arglist>
    </member>
    <member kind="function">
      <type>Quaternion</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a19a6504748867b2950d700ed79263da3</anchor>
      <arglist>(const Quaternion &amp;q) const </arglist>
    </member>
    <member kind="function">
      <type>Quaternion &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a920ac9d9cb558a3c2fa1fec81d2b3425</anchor>
      <arglist>(const Quaternion &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>Quaternion &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a20f4ff5a521ecb311a25684e9393b813</anchor>
      <arglist>(const MatrixBase&lt; Derived &gt; &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Quaternion &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a43bd190dd77eb7c9fbe87d89ed02ec43</anchor>
      <arglist>(const AngleAxisType &amp;aa)</arglist>
    </member>
    <member kind="function">
      <type>Quaternion &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ac4f9489d36557090232f1d444865bbfd</anchor>
      <arglist>(const Quaternion &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Quaternion</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ae9c14c3d2a2fdbc3d9b397d031f19551</anchor>
      <arglist>(const Quaternion&lt; OtherScalarType &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Quaternion</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a63ac91d76d087982c7add780e10fb7e7</anchor>
      <arglist>(const MatrixBase&lt; Derived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Quaternion</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a344a7c038d0b89e798baf2baa3b4a592</anchor>
      <arglist>(const AngleAxisType &amp;aa)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Quaternion</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a746756725a1ba1c8b5c1fdb59dfcd1b0</anchor>
      <arglist>(const Quaternion &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Quaternion</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a073d5be0431b9af3750e52c92b3fd754</anchor>
      <arglist>(Scalar w, Scalar x, Scalar y, Scalar z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Quaternion</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a65ed15cc19af958b5933b5c522f10e66</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Quaternion &amp;</type>
      <name>setFromTwoVectors</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a2e6246f7bf5ec16f738889a4f3e9c3b9</anchor>
      <arglist>(const MatrixBase&lt; Derived1 &gt; &amp;a, const MatrixBase&lt; Derived2 &gt; &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>Quaternion &amp;</type>
      <name>setIdentity</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ad1270655f792c0837bf5b7668081887b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Quaternion</type>
      <name>slerp</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ad2c96e5511e8d4971428a904426a73cc</anchor>
      <arglist>(Scalar t, const Quaternion &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>squaredNorm</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a8699d72c996ca6cb4673e810fe3a616c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Matrix3</type>
      <name>toRotationMatrix</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a9671425bc36afd6b1b753e5ed759ea88</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>Block&lt; Coefficients, 3, 1 &gt;</type>
      <name>vec</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>afda7f043b16da11280516e07042c15f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Block&lt; Coefficients, 3, 1 &gt;</type>
      <name>vec</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a15554a66f179287fb6d805a99aa47e3c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>w</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a81f3d09a835c62dbde6a0824f5db517b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>w</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ae11dcbf26de9bc8c2afddf9a8b5c32a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>x</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a5e6fc074bced85f298c76edac1af6cd9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>x</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a5eb2596dc2a509b276d01578a9c3dd27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>y</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>ad948bb3bd6866bdca15149880c34be62</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>y</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a7b19faa70d70b5f16a39f1dd4b69e7a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>z</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a1abcf9e222c8e5c38cf63f6821cd6480</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>z</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a94a075384f8f54dc97a69546e600b78e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Quaternion</type>
      <name>Identity</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a4df860eb69532435e8f8032e7cba4f4c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Coefficients</type>
      <name>m_coeffs</name>
      <anchorfile>classEigen_1_1Quaternion.html</anchorfile>
      <anchor>a0fefc62bb93454c110680b8400cab7f6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::RandomSetter</name>
    <filename>classEigen_1_1RandomSetter.html</filename>
    <templarg></templarg>
    <templarg>MapTraits</templarg>
    <templarg>OuterPacketBits</templarg>
    <member kind="function">
      <type>int</type>
      <name>nonZeros</name>
      <anchorfile>classEigen_1_1RandomSetter.html</anchorfile>
      <anchor>aacaa48cbf79ea5dadaa66ca36bb29bf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>operator()</name>
      <anchorfile>classEigen_1_1RandomSetter.html</anchorfile>
      <anchor>a37cb37ec5a141ac0c85bd1e6aaa0a7f0</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RandomSetter</name>
      <anchorfile>classEigen_1_1RandomSetter.html</anchorfile>
      <anchor>a96b5dce4700ec9a2875b2e5532e6ad85</anchor>
      <arglist>(SparseMatrixType &amp;target)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~RandomSetter</name>
      <anchorfile>classEigen_1_1RandomSetter.html</anchorfile>
      <anchor>aa72ee212394d51949c7d8573d0c2fc05</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>HashMapType *</type>
      <name>m_hashmaps</name>
      <anchorfile>classEigen_1_1RandomSetter.html</anchorfile>
      <anchor>a25e8a844b5e8a91edc4bc0b927058619</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>unsigned char</type>
      <name>m_keyBitsOffset</name>
      <anchorfile>classEigen_1_1RandomSetter.html</anchorfile>
      <anchor>abbadfdfd94e61a1daeb833cc38ba812d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_outerPackets</name>
      <anchorfile>classEigen_1_1RandomSetter.html</anchorfile>
      <anchor>add21cf7cd549d3364fa5130b93434601</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SparseMatrixType *</type>
      <name>mp_target</name>
      <anchorfile>classEigen_1_1RandomSetter.html</anchorfile>
      <anchor>a5ffb8f426243a2c5b900d5f05dd05d31</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Rotation2D</name>
    <filename>classEigen_1_1Rotation2D.html</filename>
    <templarg>_Scalar</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, 2, 2 &gt;</type>
      <name>Matrix2</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a01ecffad5ba660bb85a64019c7b6e33b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, 2, 1 &gt;</type>
      <name>Vector2</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a95d0b6d6498825aabaa79a8329a77945</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>angle</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a83ab19e0cf6095c27248a0136d521172</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>angle</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a0779e44b0f389bec959428f203bc766e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; Rotation2D, Rotation2D&lt; NewScalarType &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a7afe81b7d5f6de65a6638f8709190afa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Rotation2D &amp;</type>
      <name>fromRotationMatrix</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>acdaee0fab6dff4abec1cfc1d72bdefe0</anchor>
      <arglist>(const MatrixBase&lt; Derived &gt; &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>Rotation2D</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>ab8aa19861bb0513691b920826c75aa43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a5b194a7f616e6c8d439a39933e046102</anchor>
      <arglist>(const Rotation2D &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>Vector2</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>ad34dc61aab8108f6b660a19d1fdf000a</anchor>
      <arglist>(const Vector2 &amp;vec) const </arglist>
    </member>
    <member kind="function">
      <type>Rotation2D</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>ae0c6c089ae4f8aa3069d1de268522ab9</anchor>
      <arglist>(const Rotation2D &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Rotation2D &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a38e158a4156cbc2978e31a6256ae1d4e</anchor>
      <arglist>(const Rotation2D &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Rotation2D</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a5194cfb18a293d23a19a470bafc02534</anchor>
      <arglist>(const Rotation2D&lt; OtherScalarType &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Rotation2D</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>aedd8f5c2b9ba30213e174afc4c494ccb</anchor>
      <arglist>(Scalar a)</arglist>
    </member>
    <member kind="function">
      <type>Rotation2D</type>
      <name>slerp</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a4628d924acd2c9df304116c5c78a5001</anchor>
      <arglist>(Scalar t, const Rotation2D &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Matrix2</type>
      <name>toRotationMatrix</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>af10119ceb1241b50e13faef3ecf2ea00</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Scalar</type>
      <name>m_angle</name>
      <anchorfile>classEigen_1_1Rotation2D.html</anchorfile>
      <anchor>a9c61016039e020fdd4c952e798e49394</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::RotationBase</name>
    <filename>classEigen_1_1RotationBase.html</filename>
    <templarg>Derived</templarg>
    <templarg>_Dim</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, Dim, Dim &gt;</type>
      <name>RotationMatrixType</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>abb59a4f54aebad6325389d49d48de310</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_traits&lt; Derived &gt;::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>aba932c0fad971d4ffa4015627a740c10</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Derived &amp;</type>
      <name>derived</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>aa84222add803ad7c9db07dd4dd91d5d9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Derived &amp;</type>
      <name>derived</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>a2850de52161dfe2bb6e380f1892276b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Derived</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>afe93e2d51ae82a198430ec02e1be98f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Transform&lt; Scalar, Dim &gt;</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>a677df463cf5d391aa8aacae884d271c4</anchor>
      <arglist>(const Transform&lt; Scalar, Dim &gt; &amp;t) const </arglist>
    </member>
    <member kind="function">
      <type>RotationMatrixType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>a39710fd839b22424063096df91514a79</anchor>
      <arglist>(const Scaling&lt; Scalar, Dim &gt; &amp;s) const </arglist>
    </member>
    <member kind="function">
      <type>Transform&lt; Scalar, Dim &gt;</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>a4bc3063690d3de4db8630ff14949c819</anchor>
      <arglist>(const Translation&lt; Scalar, Dim &gt; &amp;t) const </arglist>
    </member>
    <member kind="function">
      <type>RotationMatrixType</type>
      <name>toRotationMatrix</name>
      <anchorfile>classEigen_1_1RotationBase.html</anchorfile>
      <anchor>aeb3f061eb5a0f7a4509f69a7f2b9d226</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Scaling</name>
    <filename>classEigen_1_1Scaling.html</filename>
    <templarg>_Scalar</templarg>
    <templarg>_Dim</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, Dim, Dim &gt;</type>
      <name>LinearMatrixType</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>ab123316c79bd49697f551c8047cc2356</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Transform&lt; Scalar, Dim &gt;</type>
      <name>TransformType</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a3549a29a401213d244efb36e11de9c83</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Translation&lt; Scalar, Dim &gt;</type>
      <name>TranslationType</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>ac54aa49e111f1afc14c11a3a671993ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, Dim, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a0c16671587fa0dc76fafeb486d6461c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; Scaling, Scaling&lt; NewScalarType, Dim &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a6681111e3ee2224f1407e28ecaacd57d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>VectorType &amp;</type>
      <name>coeffs</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a43824776cd9777b6e2296d373ebdb222</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const VectorType &amp;</type>
      <name>coeffs</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a24580a8081c9c14529c23710bedbe94e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scaling</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>af2eb919f24fbb0136520becc714f3947</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a327994d56e406f2e0c73316140373dad</anchor>
      <arglist>(const Scaling &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>VectorType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a4e66a7d6ec3f45223ee76dc65c1672ab</anchor>
      <arglist>(const VectorType &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>LinearMatrixType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>ad647aa4d39cd3268547062e9addc06cc</anchor>
      <arglist>(const RotationBase&lt; Derived, Dim &gt; &amp;r) const </arglist>
    </member>
    <member kind="function">
      <type>LinearMatrixType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a15711f345d2544ae6093b8ad6352e5b7</anchor>
      <arglist>(const LinearMatrixType &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>TransformType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a100f8e058156e5bb47d5d7dd57d753b8</anchor>
      <arglist>(const TransformType &amp;t) const </arglist>
    </member>
    <member kind="function">
      <type>TransformType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a663e83ce257b05769e69f5142777f394</anchor>
      <arglist>(const TranslationType &amp;t) const </arglist>
    </member>
    <member kind="function">
      <type>Scaling</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>abe85311d957385aa295e9f863af1acdf</anchor>
      <arglist>(const Scaling &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Scaling &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a1aad2b4af4af6368d96f731fbd32fd4e</anchor>
      <arglist>(const Scaling &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Scaling</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>acd4ad3fa05ba9f85385d93c712527cb4</anchor>
      <arglist>(const Scaling&lt; OtherScalarType, Dim &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Scaling</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a22cae14984721682e17dfb6b0c7f5e99</anchor>
      <arglist>(const VectorType &amp;coeffs)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Scaling</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>ae4deb29273e451c0c18a14b78d98e654</anchor>
      <arglist>(const Scalar &amp;sx, const Scalar &amp;sy, const Scalar &amp;sz)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Scaling</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a42acd4a216dc6909d29e6ca9d7be8983</anchor>
      <arglist>(const Scalar &amp;sx, const Scalar &amp;sy)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Scaling</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a92329b07d5099ffcc1b91464fc26df63</anchor>
      <arglist>(const Scalar &amp;s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Scaling</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a24ee51f9b19d7de0e8dd3b5b290c6824</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorType</type>
      <name>m_coeffs</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a77fc83ec05ef2c1eff8a8b55ebcb05aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend LinearMatrixType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Scaling.html</anchorfile>
      <anchor>a2334085ff389c256ae6cc9abb6c7f447</anchor>
      <arglist>(const LinearMatrixType &amp;other, const Scaling &amp;s)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Select</name>
    <filename>classEigen_1_1Select.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Select.html</anchorfile>
      <anchor>a35df5bf8e7e85d23bd1220de3027240e</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Select.html</anchorfile>
      <anchor>a825aef1450de328cbd032978c31c1112</anchor>
      <arglist>(int i, int j) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1Select.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1Select.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Select</name>
      <anchorfile>classEigen_1_1Select.html</anchorfile>
      <anchor>aa05e875faf2b36641fdcbae588633110</anchor>
      <arglist>(const ConditionMatrixType &amp;conditionMatrix, const ThenMatrixType &amp;thenMatrix, const ElseMatrixType &amp;elseMatrix)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ConditionMatrixType::Nested</type>
      <name>m_condition</name>
      <anchorfile>classEigen_1_1Select.html</anchorfile>
      <anchor>aad49b53291335f47d24915ef1bab84f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ElseMatrixType::Nested</type>
      <name>m_else</name>
      <anchorfile>classEigen_1_1Select.html</anchorfile>
      <anchor>a8ad9ad5502b27bac589deff2e6a7d96a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ThenMatrixType::Nested</type>
      <name>m_then</name>
      <anchorfile>classEigen_1_1Select.html</anchorfile>
      <anchor>aa1216629584bfaf8807a21a1100b61a0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::SelfAdjointEigenSolver</name>
    <filename>classEigen_1_1SelfAdjointEigenSolver.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>std::complex&lt; RealScalar &gt;</type>
      <name>Complex</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a1a215510434ed195e4ce08e1f0b86afe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_MatrixType</type>
      <name>MatrixType</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>aeb6c0eb89cc982629305f6c7e0791caf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; RealScalar, MatrixType::ColsAtCompileTime, 1 &gt;</type>
      <name>RealVectorType</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a851a3ba3fef8f12638d6d8429faa3570</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; RealScalar, Dynamic, 1 &gt;</type>
      <name>RealVectorTypeX</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>abf56d6f2a699316c27d0ac6df9fc95b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Tridiagonalization&lt; MatrixType &gt;</type>
      <name>TridiagonalizationType</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a4d37ae0326789324b443c7a958c4f24e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a3ee005d043bed78ab5a504c4f5c2d11c</anchor>
      <arglist>(const MatrixType &amp;matA, const MatrixType &amp;matB, bool computeEigenvectors=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a661ac3bde8e126b2dd3a9051aad564bc</anchor>
      <arglist>(const MatrixType &amp;matrix, bool computeEigenvectors=true)</arglist>
    </member>
    <member kind="function">
      <type>RealVectorType</type>
      <name>eigenvalues</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a4cdf67ce3255c282bae9e8a281a28cd5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>eigenvectors</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a313df80ce916ac9b2b581ff562e87d9e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>operatorInverseSqrt</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a811ad0873e06be5404fc91f64f0f658d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>operatorSqrt</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>add23e44f8a7f540c288ee98b2d2b0775</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SelfAdjointEigenSolver</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a6302d080c0a8938ea787c85ce82e067a</anchor>
      <arglist>(const MatrixType &amp;matA, const MatrixType &amp;matB, bool computeEigenvectors=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SelfAdjointEigenSolver</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a5d50eda40417a083c7fdc70ec8dc6e87</anchor>
      <arglist>(const MatrixType &amp;matrix, bool computeEigenvectors=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SelfAdjointEigenSolver</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a6a86d762cabd773fccda1b394f5049fe</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_eigenvectorsOk</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a8d72e484cd442db1ff5cabe036ecd725</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>RealVectorType</type>
      <name>m_eivalues</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>a2cdede1ed5394bbc14172de82940e20d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_eivec</name>
      <anchorfile>classEigen_1_1SelfAdjointEigenSolver.html</anchorfile>
      <anchor>aadffd531416b65eba828a8b6bb8c3fde</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::SparseLDLT</name>
    <filename>classEigen_1_1SparseLDLT.html</filename>
    <templarg></templarg>
    <templarg>Backend</templarg>
    <member kind="function">
      <type>bool</type>
      <name>_numeric</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a26c0523bfb9a84758fee9cb7b1e34dde</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_symbolic</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a84f71180a997a212b96cec274b5b3a15</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>flags</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a5f944e30665d7e6775691e5fc63e9dc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CholMatrixType &amp;</type>
      <name>matrixL</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a935c8c6f14451716595c99e8eaeb67d1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>precision</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>abe5bb554978d7584795e2ebd121115aa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrecision</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a7bc6e7b398a8db1c0d746fecbf367c1d</anchor>
      <arglist>(RealScalar v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>settagss</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>ae64246a0d65d71c0b850d919b1ab25da</anchor>
      <arglist>(int f)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solveInPlace</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>ac82361eab9fdd8f888b85a77d8b8d925</anchor>
      <arglist>(MatrixBase&lt; Derived &gt; &amp;b) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseLDLT</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>afbb82cf761caece2bb3d15de2f447b68</anchor>
      <arglist>(const MatrixType &amp;matrix, int flags=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseLDLT</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>ab3c5bb75c24765c9afdb0f00e74f04ef</anchor>
      <arglist>(int flags=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>succeeded</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a9ff21cd2cb5ff6d358bb3eef3fbc4b3d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>VectorType</type>
      <name>vectorD</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a7f090776880be2ea0e140513499cdda3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>SparseMatrix&lt; Scalar, LowerTriangular|UnitDiagBit &gt;</type>
      <name>CholMatrixType</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>ad821b5a30a7460bdf0773abf6fc4d9be</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>NumTraits&lt; typename MatrixType::Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a79aff568be74c125bfe8d749047de98e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>Matrix&lt; Scalar, MatrixType::ColsAtCompileTime, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>acbcef1eb20903fe22bcfe7ca01d9daf2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorType</type>
      <name>m_diag</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a6d3a36bb33558a0f6590571a6f724831</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_flags</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>acf88a9269a6bde0e77d6d64102d824ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>CholMatrixType</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a1a662c717b7a04ed66875608cdd8c4fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorXi</type>
      <name>m_nonZerosPerCol</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a0c4b503393746276c2986792838bccd0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorXi</type>
      <name>m_parent</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a407918c993b764f218130b41de0f60ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>RealScalar</type>
      <name>m_precision</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a6931ccef8ba2cf4f11b6d23dae2931f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_status</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>a9fe0cdf49723f51eb797adbee7e7e2e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_succeeded</name>
      <anchorfile>classEigen_1_1SparseLDLT.html</anchorfile>
      <anchor>ae3491332a5e2652659672c8530f7e22c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::SparseLLT</name>
    <filename>classEigen_1_1SparseLLT.html</filename>
    <templarg></templarg>
    <templarg>Backend</templarg>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>flags</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a5f944e30665d7e6775691e5fc63e9dc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CholMatrixType &amp;</type>
      <name>matrixL</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a935c8c6f14451716595c99e8eaeb67d1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>precision</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>abe5bb554978d7584795e2ebd121115aa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFlags</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a9f29e5457641fae1b405b144a8206ca5</anchor>
      <arglist>(int f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrecision</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a7bc6e7b398a8db1c0d746fecbf367c1d</anchor>
      <arglist>(RealScalar v)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solveInPlace</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>ac82361eab9fdd8f888b85a77d8b8d925</anchor>
      <arglist>(MatrixBase&lt; Derived &gt; &amp;b) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseLLT</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a653e9e5a0d0d86ca5489268012e921cb</anchor>
      <arglist>(const MatrixType &amp;matrix, int flags=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseLLT</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>aed1c01e831d3c496dc231a060662374e</anchor>
      <arglist>(int flags=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>succeeded</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a9ff21cd2cb5ff6d358bb3eef3fbc4b3d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>SparseMatrix&lt; Scalar, LowerTriangular &gt;</type>
      <name>CholMatrixType</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a9f5cdafd16f96538654fe00dc1d64d39</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>NumTraits&lt; typename MatrixType::Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a79aff568be74c125bfe8d749047de98e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_flags</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>acf88a9269a6bde0e77d6d64102d824ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>CholMatrixType</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a1a662c717b7a04ed66875608cdd8c4fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>RealScalar</type>
      <name>m_precision</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a6931ccef8ba2cf4f11b6d23dae2931f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_status</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>a9fe0cdf49723f51eb797adbee7e7e2e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_succeeded</name>
      <anchorfile>classEigen_1_1SparseLLT.html</anchorfile>
      <anchor>ae3491332a5e2652659672c8530f7e22c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::SparseLU</name>
    <filename>classEigen_1_1SparseLU.html</filename>
    <templarg></templarg>
    <templarg>Backend</templarg>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>flags</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a5f944e30665d7e6775691e5fc63e9dc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>orderingMethod</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>ac89337e14ca5c662cc55280b690836ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RealScalar</type>
      <name>precision</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>abe5bb554978d7584795e2ebd121115aa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFlags</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a9f29e5457641fae1b405b144a8206ca5</anchor>
      <arglist>(int f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrderingMethod</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a4971cb197916b24090e9cb0b178312e0</anchor>
      <arglist>(int m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrecision</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a7bc6e7b398a8db1c0d746fecbf367c1d</anchor>
      <arglist>(RealScalar v)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solve</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>ae6e1999443e05704376b0f1862c68de4</anchor>
      <arglist>(const MatrixBase&lt; BDerived &gt; &amp;b, MatrixBase&lt; XDerived &gt; *x) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseLU</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>ad5e95240927e30bb941bb73d0d2d474c</anchor>
      <arglist>(const MatrixType &amp;matrix, int flags=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseLU</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a087bd6a44300928edd9c757e895609c8</anchor>
      <arglist>(int flags=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>succeeded</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a9ff21cd2cb5ff6d358bb3eef3fbc4b3d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>SparseMatrix&lt; Scalar, LowerTriangular &gt;</type>
      <name>LUMatrixType</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a3a06f3c4fe8d52850c8b24b2b7172d11</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>NumTraits&lt; typename MatrixType::Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a79aff568be74c125bfe8d749047de98e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_flags</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>acf88a9269a6bde0e77d6d64102d824ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>RealScalar</type>
      <name>m_precision</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a6931ccef8ba2cf4f11b6d23dae2931f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_status</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>a9fe0cdf49723f51eb797adbee7e7e2e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>m_succeeded</name>
      <anchorfile>classEigen_1_1SparseLU.html</anchorfile>
      <anchor>ae3491332a5e2652659672c8530f7e22c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::SparseMatrix</name>
    <filename>classEigen_1_1SparseMatrix.html</filename>
    <templarg>_Scalar</templarg>
    <templarg>_Flags</templarg>
    <member kind="typedef">
      <type>MappedSparseMatrix&lt; Scalar, Flags &gt;</type>
      <name>Map</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a25cb1cbaee9b60f3e02c96cc69db2775</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>int *</type>
      <name>_innerIndexPtr</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a3532bd05076e166d3f5c7fc1bb54eb74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const int *</type>
      <name>_innerIndexPtr</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>aba5797dde801250ea687d232f81b44ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int *</type>
      <name>_outerIndexPtr</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a8a5f93acb012342bec6fa6ccca080b11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const int *</type>
      <name>_outerIndexPtr</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a3c5af0bda8657c94ff7d9b832000eaa8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar *</type>
      <name>_valuePtr</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a9aefb5ca87ecaa16461a9e0d6dcd7aa5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar *</type>
      <name>_valuePtr</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a23ae779fc3d5fbc6f18a2526916fe116</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>af2b14e136cbed0bd5fbd5e72a08d3187</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>endFill</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a4d3d8b6f0cd82ee988c3465731fe7e64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>fill</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a2e4bf7eb9757b85be9af24d71e4bcb59</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>fillrand</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a275d73c9a743664156294ccfe1122595</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerNonZeros</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>ae81e96121524a9077b8ec0c2eb5d32f1</anchor>
      <arglist>(int j) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerSize</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a124752e160ea0b87f4b5fbd9b630b8ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nonZeros</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>aacaa48cbf79ea5dadaa66ca36bb29bf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SparseMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>ad9e022bf36fae16edb27194b7134cd37</anchor>
      <arglist>(const SparseMatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>SparseMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a8a36046bec7d341e04adc48e65437918</anchor>
      <arglist>(const SparseMatrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>outerSize</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>ab0a84319855a030cd5446a2ed38b500c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prune</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a63540e9242a42c735d0e58c4c4e8f95d</anchor>
      <arglist>(Scalar reference, RealScalar epsilon=precision&lt; RealScalar &gt;())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>acedbb131f3c73db12693c80f8b00d75b</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resizeNonZeros</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a160844d54f18ce1f2e6517d295a201ba</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZero</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a47affd1a10b589811fc4828c1a2e0c6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseMatrix</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a631add606d943913aa2dbda84c0d4d20</anchor>
      <arglist>(const SparseMatrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseMatrix</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>acb2692f1195ca1cf597712ee277eabb1</anchor>
      <arglist>(const SparseMatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseMatrix</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a311b0a27db3e9c4a2e618be989309e8a</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startFill</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>acab9178f0932b886d40ee1990bd8b144</anchor>
      <arglist>(int reserveSize=1000)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a396133d952d4698941fe010c7ec6f72b</anchor>
      <arglist>(SparseMatrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SparseMatrix</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>aba0104120c59e6c59af1932a8eaaa10e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="typedef" protection="protected">
      <type>SparseMatrix&lt; Scalar,(Flags &amp;~RowMajorBit)|(IsRowMajor?RowMajorBit:0)&gt;</type>
      <name>TransposedSparseMatrix</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a87ef0f2d586039ab7fa6629c303156ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>CompressedStorage&lt; Scalar &gt;</type>
      <name>m_data</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a2de6b39c40abbf706fffb52abafb342d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_innerSize</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>afa327d86d468b495fe83abab242c906f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int *</type>
      <name>m_outerIndex</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a9f4bc490ac1e1dda96c1bc44771c19d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>m_outerSize</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>a802c54d83b6f8111734bdf883bbc41d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classEigen_1_1SparseMatrix.html</anchorfile>
      <anchor>ae7cb03fccbdb1456601051ffa6522c46</anchor>
      <arglist>(std::ostream &amp;s, const SparseMatrix &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::SparseVector</name>
    <filename>classEigen_1_1SparseVector.html</filename>
    <templarg></templarg>
    <templarg>_Flags</templarg>
    <member kind="typedef">
      <type>SparseMatrixBase&lt; SparseVector &gt;</type>
      <name>SparseBase</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>ab8d7fa87cec2b9a3da483cc89a003dc3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>CompressedStorage&lt; Scalar &gt; &amp;</type>
      <name>_data</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a4aaaafa15ee52322d70515a70b1ffbf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CompressedStorage&lt; Scalar &gt; &amp;</type>
      <name>_data</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a82e6e9fce1473bef2d663621507b5907</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int *</type>
      <name>_innerIndexPtr</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a3532bd05076e166d3f5c7fc1bb54eb74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const int *</type>
      <name>_innerIndexPtr</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>aba5797dde801250ea687d232f81b44ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar *</type>
      <name>_valuePtr</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a9aefb5ca87ecaa16461a9e0d6dcd7aa5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar *</type>
      <name>_valuePtr</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a23ae779fc3d5fbc6f18a2526916fe116</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a9c49225de556c1dbe5f7780318c77b8b</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>af2b14e136cbed0bd5fbd5e72a08d3187</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a020500a423b67ae62ac7cadefeda827a</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>endFill</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a4d3d8b6f0cd82ee988c3465731fe7e64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>fill</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a37acb7abf85423e17103cd79fb9b56ed</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>fill</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a3f0931ac720013ba3f2edbb776cd5717</anchor>
      <arglist>(int r, int c)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>fillrand</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a356b7fc63c38e041190e43503ab4ce4e</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>fillrand</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>abf645f539b1aa55f6999c9f1cb647fd4</anchor>
      <arglist>(int r, int c)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerNonZeros</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>ae81e96121524a9077b8ec0c2eb5d32f1</anchor>
      <arglist>(int j) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>innerSize</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a124752e160ea0b87f4b5fbd9b630b8ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nonZeros</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>aacaa48cbf79ea5dadaa66ca36bb29bf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SparseVector &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a0d4cf4344ddee0e2572b39284b12105e</anchor>
      <arglist>(const SparseMatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>SparseVector &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a7cb38a0587374cea00d150458974ae83</anchor>
      <arglist>(const SparseVector &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>outerSize</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>ab0a84319855a030cd5446a2ed38b500c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prune</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a63540e9242a42c735d0e58c4c4e8f95d</anchor>
      <arglist>(Scalar reference, RealScalar epsilon=precision&lt; RealScalar &gt;())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reserve</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a7a0c09b9ea00ec48062fc63ce0db4880</anchor>
      <arglist>(int reserveSize)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>ab8b22b9d0f25d76dda44f79aeabd826f</anchor>
      <arglist>(int newSize)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>acedbb131f3c73db12693c80f8b00d75b</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resizeNonZeros</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a160844d54f18ce1f2e6517d295a201ba</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZero</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a47affd1a10b589811fc4828c1a2e0c6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseVector</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>af52377dfe1d0e31194f6cc97c4ef563a</anchor>
      <arglist>(const SparseVector &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseVector</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a7ae258a9d8bffe92ac070cf05e57b071</anchor>
      <arglist>(const SparseMatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseVector</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a2111d23f80d899b1bf3ab016cb3ce4c4</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseVector</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>af62f075ea232032a9b9fb52f2f44b757</anchor>
      <arglist>(int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SparseVector</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a6bcc90d3947a3d59b4f8eb93d166d935</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startFill</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a30775441fd2dde2852e637081d384514</anchor>
      <arglist>(int reserve)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>aa4c953fb9e8b7ce8457c288601d6b4ea</anchor>
      <arglist>(SparseVector &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SparseVector</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a5f5e6bacb0ddda1f48d6ec87564b9dc1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>CompressedStorage&lt; Scalar &gt;</type>
      <name>m_data</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a2de6b39c40abbf706fffb52abafb342d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>m_size</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a012b2bfbef5380cc57296def37a49a27</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classEigen_1_1SparseVector.html</anchorfile>
      <anchor>a6cf8a05d15fd30ee4fb01ecb778305c3</anchor>
      <arglist>(std::ostream &amp;s, const SparseVector &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Eigen::StdMapTraits</name>
    <filename>structEigen_1_1StdMapTraits.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>int</type>
      <name>KeyType</name>
      <anchorfile>structEigen_1_1StdMapTraits.html</anchorfile>
      <anchor>afb9ba0452c8396e90d7ecd3d035e29de</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; KeyType, Scalar &gt;</type>
      <name>Type</name>
      <anchorfile>structEigen_1_1StdMapTraits.html</anchorfile>
      <anchor>aba9617ce677dce01a7611033edbe0544</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setInvalidKey</name>
      <anchorfile>structEigen_1_1StdMapTraits.html</anchorfile>
      <anchor>a25d881f1a7582d115e77e218f1db170b</anchor>
      <arglist>(Type &amp;, const KeyType &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::SVD</name>
    <filename>classEigen_1_1SVD.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computePositiveUnitary</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a71e973ff6ef9605ee6c8d74bab431eea</anchor>
      <arglist>(UnitaryType *positive, PositiveType *unitary) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computePositiveUnitary</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a02d7cc8356b29195e7a61d1dfb7c41a0</anchor>
      <arglist>(PositiveType *positive, UnitaryType *unitary) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeRotationScaling</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>aeb40a7c3375605cb1c823c98f4b05df5</anchor>
      <arglist>(RotationType *unitary, ScalingType *positive) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeScalingRotation</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>ab9e9e1b2ebc4dd91b2fd07e427313d54</anchor>
      <arglist>(ScalingType *positive, RotationType *unitary) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeUnitaryPositive</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a5cfe59d66787ba174157ee4a913247ea</anchor>
      <arglist>(UnitaryType *unitary, PositiveType *positive) const </arglist>
    </member>
    <member kind="function">
      <type>const MatrixUType &amp;</type>
      <name>matrixU</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a49e16a4adf4fe58a2d65a5e5a31e7654</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const MatrixVType &amp;</type>
      <name>matrixV</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>ae5158ab7ca44a705c2a3b56ec926b42a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const SingularValuesType &amp;</type>
      <name>singularValues</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a48d4068b97dfbb83d62599e56e26797a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>solve</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>acf22c329a5c3d713a20c4ab0558014b3</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;b, ResultType *result) const </arglist>
    </member>
    <member kind="function">
      <type>SVD &amp;</type>
      <name>sort</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a40c74b4275fbdc7b2eaecc0bf52c6f82</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SVD</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a3de2113588996626f1adc1b8b2afdcc0</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixUType</type>
      <name>m_matU</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>af8cb6ed3d92fb85b4bdb1ca2ce17d0fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixVType</type>
      <name>m_matV</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a5e0af4ae1b21829e1bef52b8c5703c26</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SingularValuesType</type>
      <name>m_sigma</name>
      <anchorfile>classEigen_1_1SVD.html</anchorfile>
      <anchor>a5defbc80a7daf91c0b8428d105a9f055</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Transform</name>
    <filename>classEigen_1_1Transform.html</filename>
    <templarg>_Scalar</templarg>
    <templarg>_Dim</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, Dim, Dim &gt;</type>
      <name>LinearMatrixType</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ab123316c79bd49697f551c8047cc2356</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Block&lt; MatrixType, Dim, Dim &gt;</type>
      <name>LinearPart</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a385044a77900d345ea04d36482c2b68d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, HDim, HDim &gt;</type>
      <name>MatrixType</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a1c5084f9c567de1f037183ab79903d02</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Scaling&lt; Scalar, Dim &gt;</type>
      <name>ScalingType</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a77bff8824b5d0bb086b5b9a55f35ee7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Block&lt; MatrixType, Dim, 1 &gt;</type>
      <name>TranslationPart</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a1c708b703a1db072a2a8cbbaa6b6707e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Translation&lt; Scalar, Dim &gt;</type>
      <name>TranslationType</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ac54aa49e111f1afc14c11a3a671993ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, Dim, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a0c16671587fa0dc76fafeb486d6461c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; Transform, Transform&lt; NewScalarType, Dim &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ac987499c117f700740930730f6280dbc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeRotationScaling</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a5e4d7b6148336a0a417b708581d23227</anchor>
      <arglist>(RotationMatrixType *rotation, ScalingMatrixType *scaling) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeScalingRotation</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ab9216b693d2055c37ef637c82c156605</anchor>
      <arglist>(ScalingMatrixType *scaling, RotationMatrixType *rotation) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar *</type>
      <name>data</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a4663159a1450fa89214b1ab71f7ef5bf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Scalar *</type>
      <name>data</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a40dcc334db75411e168691d9bce08c3a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EIGEN_MAKE_ALIGNED_OPERATOR_NEW_IF_VECTORIZABLE_FIXED_SIZE</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a08fcfa17a274862a36b5908d2b261e0d</anchor>
      <arglist>(_Scalar, _Dim==Dynamic?Dynamic:(_Dim+1)*(_Dim+1)) enum</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>fromPositionOrientationScale</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a5a69ff71b9b5d0c946a52e37f1880dff</anchor>
      <arglist>(const MatrixBase&lt; PositionDerived &gt; &amp;position, const OrientationType &amp;orientation, const MatrixBase&lt; ScaleDerived &gt; &amp;scale)</arglist>
    </member>
    <member kind="function">
      <type>const MatrixType</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ab6c125bd46e68fe9376c50206933f4ce</anchor>
      <arglist>(TransformTraits traits=Affine) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a9c32766d583e67d864d693df28b267c9</anchor>
      <arglist>(const Transform &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>LinearPart</type>
      <name>linear</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a66704eaad42c9dd8f3723746e264fcb2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const LinearPart</type>
      <name>linear</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>acde65ada34af0a259c07933d7239ceaf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType &amp;</type>
      <name>matrix</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ad7355bb89f8429007277363642c90bfd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const MatrixType &amp;</type>
      <name>matrix</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>abc21b93260324521746a4ca2efacba90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>operator()</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a37cb37ec5a141ac0c85bd1e6aaa0a7f0</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>Scalar</type>
      <name>operator()</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a49b3c239c2f882d572f8853fd10193c5</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Transform</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>af7d22adee12923e73be0285699b95d5e</anchor>
      <arglist>(const RotationBase&lt; Derived, Dim &gt; &amp;r) const </arglist>
    </member>
    <member kind="function">
      <type>Transform</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ac19c076c7a19a315f980c00a70ebf0c0</anchor>
      <arglist>(const ScalingType &amp;s) const </arglist>
    </member>
    <member kind="function">
      <type>Transform</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a39908552c700ca9362c697a82208237c</anchor>
      <arglist>(const TranslationType &amp;t) const </arglist>
    </member>
    <member kind="function">
      <type>const Transform</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a3001cf5afd95d96a4a229e0c5f817364</anchor>
      <arglist>(const Transform &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>const ei_transform_product_impl&lt; OtherDerived, _Dim, _Dim+1 &gt;::ResultType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a1c96a919eff1aa84b6106d1c2ea671f4</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a3624096dfbddd9eeda920c09b2012fd1</anchor>
      <arglist>(const RotationBase&lt; Derived, Dim &gt; &amp;r)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a92deed32f850fa5c1f3c07937f362437</anchor>
      <arglist>(const ScalingType &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator*=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>afdd7cecaeafa0571adceb59c0bf03278</anchor>
      <arglist>(const TranslationType &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a3993e02f4a7a86f6a1f9a2359553058e</anchor>
      <arglist>(const RotationBase&lt; Derived, Dim &gt; &amp;r)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a57783cd395df195adc191442026b7e30</anchor>
      <arglist>(const ScalingType &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>abcc7c13bef06f8ab9fedd2d736744724</anchor>
      <arglist>(const TranslationType &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a187fd77350920fcdd022c40e3bf364b6</anchor>
      <arglist>(const QTransform &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a45d9ccc863d849739687f2cc274cef52</anchor>
      <arglist>(const QMatrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>abb963bfb8401ec6b2360d3b776f5fbbb</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a9603f5af45815e78aca6745e68b3ba4f</anchor>
      <arglist>(const Transform &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>prerotate</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a274658ccf2a39e572a59aa7adfe08c44</anchor>
      <arglist>(const RotationType &amp;rotation)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>prescale</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a18b256ceb98d26e5ab41e9c77a4bcf00</anchor>
      <arglist>(Scalar s)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>prescale</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>abdaa4bee9e2b4fbfd3090a0432f3df27</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>preshear</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a4bef33ab6a255397b3ba0cc826b4b812</anchor>
      <arglist>(Scalar sx, Scalar sy)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>pretranslate</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a63ce4ed497af350208893a27d8ab59f9</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>rotate</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a86a1a6271d4960e243159ed7e04d4ff9</anchor>
      <arglist>(const RotationType &amp;rotation)</arglist>
    </member>
    <member kind="function">
      <type>LinearMatrixType</type>
      <name>rotation</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a05db58ef4cda07739db14f8711699fa1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>scale</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ab6198944849fa7f8078fa20504fb3d79</anchor>
      <arglist>(Scalar s)</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>scale</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>af5638cbc23bdc71cc94c5bee985cab2e</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIdentity</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a382e6ad7e6721b121e510959e1011be3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>shear</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>adfdb23c243ba7f24aba493c5ba3edcd9</anchor>
      <arglist>(Scalar sx, Scalar sy)</arglist>
    </member>
    <member kind="function">
      <type>QMatrix</type>
      <name>toQMatrix</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a4721b3c0d0dc5c79fcd5dac8a352bc5c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>QTransform</type>
      <name>toQTransform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a58efdb505853955c01927ab52d1ea88f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a59a6f6275ddd70e59fe8f8514ea7740a</anchor>
      <arglist>(const Transform&lt; OtherScalarType, Dim &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a57dc9afa8645010c63677a60457071b2</anchor>
      <arglist>(const QTransform &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>aa5e266f2a7d9007d41655186de5b66be</anchor>
      <arglist>(const QMatrix &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a877605b406e69c4fae7f78a43db4aca7</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>acfd48b1c184da72d052b0ef177ee34ce</anchor>
      <arglist>(const RotationBase&lt; Derived, Dim &gt; &amp;r)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>af15e20ef7b7d0666061e2d1d11bb9246</anchor>
      <arglist>(const ScalingType &amp;s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a81e90182510664381ff35833903b4a1e</anchor>
      <arglist>(const TranslationType &amp;t)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a548d5a6dac2aa4b125cb7601241faacc</anchor>
      <arglist>(const Transform &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transform</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a9de68ec1c9b7809129814a3233ae4655</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Transform &amp;</type>
      <name>translate</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>adbd9ad421a180b2b31bc9066afa9814e</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>TranslationPart</type>
      <name>translation</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a79881f97c02305c0eb4820d7df00bc09</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const TranslationPart</type>
      <name>translation</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>ab2c74c7710303c208b012468fa6bb521</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const MatrixType::IdentityReturnType</type>
      <name>Identity</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a732af623dd064d03647e16d7a0fc1a99</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a5cb944a2054dfd326e4dcf77bb1bacf1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend Transform</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a9053c8e48ccd9d8db98049647727fa61</anchor>
      <arglist>(const LinearMatrixType &amp;mat, const Transform &amp;t)</arglist>
    </member>
    <member kind="friend">
      <type>friend const ProductReturnType&lt; OtherDerived, MatrixType &gt;::Type</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Transform.html</anchorfile>
      <anchor>a936e1fe2164cc23e8eaa0109db39954f</anchor>
      <arglist>(const MatrixBase&lt; OtherDerived &gt; &amp;a, const Transform &amp;b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Translation</name>
    <filename>classEigen_1_1Translation.html</filename>
    <templarg>_Scalar</templarg>
    <templarg>_Dim</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, Dim, Dim &gt;</type>
      <name>LinearMatrixType</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>ab123316c79bd49697f551c8047cc2356</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>aea29b63b6c32046ae9a471d82c5cf869</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Scaling&lt; Scalar, Dim &gt;</type>
      <name>ScalingType</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a77bff8824b5d0bb086b5b9a55f35ee7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Transform&lt; Scalar, Dim &gt;</type>
      <name>TransformType</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a3549a29a401213d244efb36e11de9c83</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, Dim, 1 &gt;</type>
      <name>VectorType</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a0c16671587fa0dc76fafeb486d6461c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ei_cast_return_type&lt; Translation, Translation&lt; NewScalarType, Dim &gt; &gt;::type</type>
      <name>cast</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a64c0ec9bc133741b44b7a37974f246f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Translation</type>
      <name>inverse</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a4a30d0656f2326b33bfe22782619dab8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApprox</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a8220dbe71b3dae79ed18c62577bd2029</anchor>
      <arglist>(const Translation &amp;other, typename NumTraits&lt; Scalar &gt;::Real prec=precision&lt; Scalar &gt;()) const </arglist>
    </member>
    <member kind="function">
      <type>VectorType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a4e66a7d6ec3f45223ee76dc65c1672ab</anchor>
      <arglist>(const VectorType &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>TransformType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a41d757ac0457bd39ebd1b77185e80ded</anchor>
      <arglist>(const TransformType &amp;t) const </arglist>
    </member>
    <member kind="function">
      <type>TransformType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>af51043aa928563b96f60152255e70c2b</anchor>
      <arglist>(const RotationBase&lt; Derived, Dim &gt; &amp;r) const </arglist>
    </member>
    <member kind="function">
      <type>TransformType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a1449a737e068ed2dbc2ca248857f0cc3</anchor>
      <arglist>(const LinearMatrixType &amp;linear) const </arglist>
    </member>
    <member kind="function">
      <type>TransformType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>abf4ba733c290c00c9b2309a7f3a96cc3</anchor>
      <arglist>(const ScalingType &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Translation</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a42026a509f82e98803005fa8893a81a7</anchor>
      <arglist>(const Translation &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>Translation &amp;</type>
      <name>operator=</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a96769b1a86862eb039e8533140a245dd</anchor>
      <arglist>(const Translation &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Translation</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>ab6882adb793e442793cdda74f59fd7c3</anchor>
      <arglist>(const Translation&lt; OtherScalarType, Dim &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Translation</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a7475e79dd0650a93f66e078f4ab9c58f</anchor>
      <arglist>(const VectorType &amp;vector)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Translation</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>ab9af64a960f10e1ee8878d6bc3526f49</anchor>
      <arglist>(const Scalar &amp;sx, const Scalar &amp;sy, const Scalar &amp;sz)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Translation</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>ab27a696c206af5c7ddd03f2d7690c597</anchor>
      <arglist>(const Scalar &amp;sx, const Scalar &amp;sy)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Translation</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>ae4694a2ae6f5453587c5d7f4bc385ded</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>VectorType &amp;</type>
      <name>vector</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>adc8969390c24af577786dc380b5bc59c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const VectorType &amp;</type>
      <name>vector</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a6426cac67bbde66876b5a949ddd96180</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>VectorType</type>
      <name>m_coeffs</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>a77fc83ec05ef2c1eff8a8b55ebcb05aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend TransformType</type>
      <name>operator*</name>
      <anchorfile>classEigen_1_1Translation.html</anchorfile>
      <anchor>ab987107af677d025f45c39646706d701</anchor>
      <arglist>(const LinearMatrixType &amp;linear, const Translation &amp;t)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Transpose</name>
    <filename>classEigen_1_1Transpose.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>a0f56c3ec1c6c67f5366ef75d28c134ce</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Scalar</type>
      <name>coeff</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>ad8927524103e5db656e46a1cdab08626</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>ac244dc54675046d04a0fde51485f83ef</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Scalar &amp;</type>
      <name>coeffRef</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>a2cc4514bff37067ccbb4924a0673bd71</anchor>
      <arglist>(int row, int col)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cols</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>a3cefa469a7524d4bbc80531ebb9b5df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>a189ce98791b46dfcb2143824afd6bad0</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const PacketScalar</type>
      <name>packet</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>a25a22be95c6dbeaaedeefa2ff1c86044</anchor>
      <arglist>(int row, int col) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rows</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>a48cdd99e4e82f74c1adae2bd69970220</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stride</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>acab40bcf2fda12b7b73b37abb7afe7e0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Transpose</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>a1c004a5918c0639bb124636cef95830e</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>afe4aad896c0826549cafd17ed9bc21af</anchor>
      <arglist>(int index, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePacket</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>a6a38e68d9cae6812636583ccaacbef11</anchor>
      <arglist>(int row, int col, const PacketScalar &amp;x)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const MatrixType::Nested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1Transpose.html</anchorfile>
      <anchor>aa213d3c4337a578d57ada1869f65e55e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::Tridiagonalization</name>
    <filename>classEigen_1_1Tridiagonalization.html</filename>
    <templarg>_MatrixType</templarg>
    <member kind="typedef">
      <type>Matrix&lt; Scalar, SizeMinusOne, 1 &gt;</type>
      <name>CoeffVectorType</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>abea75df1e0a8369a6e40fcd507142999</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NestByValue&lt; DiagonalCoeffs&lt; MatrixType &gt; &gt;::RealReturnType</type>
      <name>DiagonalReturnType</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a71c1da1db6849dd95ab7fb95e640fb06</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; RealScalar, Size, 1 &gt;</type>
      <name>DiagonalType</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a87068f43ff0630dfc77b4fc53a48c65c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_MatrixType</type>
      <name>MatrixType</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>aeb6c0eb89cc982629305f6c7e0791caf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ei_packet_traits&lt; Scalar &gt;::type</type>
      <name>Packet</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>aa80fcb28d3d60bbc0549f3558ffb665f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NumTraits&lt; Scalar &gt;::Real</type>
      <name>RealScalar</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>acb5c3dc237f99cf17167e8a629f01b43</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType::Scalar</type>
      <name>Scalar</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a3f6fc00047c205ee590f676934aab28f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>NestByValue&lt; DiagonalCoeffs&lt; NestByValue&lt; Block&lt; MatrixType, SizeMinusOne, SizeMinusOne &gt; &gt; &gt; &gt;::RealReturnType</type>
      <name>SubDiagonalReturnType</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a57a1f96c246abc9afba85755902a6932</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Matrix&lt; RealScalar, SizeMinusOne, 1 &gt;</type>
      <name>SubDiagonalType</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>ab4c34abe4993bde7bc8483c95cb7e04f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>compute</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a05a0eac1c146e9e62df9ec70f5a6f69d</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const DiagonalReturnType</type>
      <name>diagonal</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a626085a144a66a39a35bc672195103bc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>CoeffVectorType</type>
      <name>householderCoefficients</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>ade50f8e51aae26549cee83d541a622bc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>matrixQ</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>adecbd9f7f888cbcdf6cfec1841ccb81a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>MatrixType</type>
      <name>matrixT</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>ad1b9b3d3d504ee8e87eceae3dfa01ec0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const MatrixType &amp;</type>
      <name>packedMatrix</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>ac99c081e3c659e0448623c881e04b9c2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SubDiagonalReturnType</type>
      <name>subDiagonal</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>aa6dd8326d9bd9c0d72269f73f16defdc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Tridiagonalization</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>aa9f9722d2cef9425e2c0da3553dfbac7</anchor>
      <arglist>(const MatrixType &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Tridiagonalization</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a12e24d65e3bdb25b02f58c13d802ac4d</anchor>
      <arglist>(int size=Size==Dynamic?2:Size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>decomposeInPlace</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a0bb937dbfac69896f76f2828fe523c6a</anchor>
      <arglist>(MatrixType &amp;mat, DiagonalType &amp;diag, SubDiagonalType &amp;subdiag, bool extractQ=true)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>CoeffVectorType</type>
      <name>m_hCoeffs</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a4f25ef6c17bba4dec8ba3b590dd74a3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixType</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1Tridiagonalization.html</anchorfile>
      <anchor>a5cb944a2054dfd326e4dcf77bb1bacf1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Eigen::WithFormat</name>
    <filename>classEigen_1_1WithFormat.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>WithFormat</name>
      <anchorfile>classEigen_1_1WithFormat.html</anchorfile>
      <anchor>a505cae3d6fecdaa0157686eeb81b61db</anchor>
      <arglist>(const ExpressionType &amp;matrix, const IOFormat &amp;format)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>IOFormat</type>
      <name>m_format</name>
      <anchorfile>classEigen_1_1WithFormat.html</anchorfile>
      <anchor>aed0fa47d51ffe23adad43f25d5b30aed</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const ExpressionType::Nested</type>
      <name>m_matrix</name>
      <anchorfile>classEigen_1_1WithFormat.html</anchorfile>
      <anchor>a8e0e7619dc9f65feb42de8ded9694ee7</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classEigen_1_1WithFormat.html</anchorfile>
      <anchor>a817e230f591824ed812374d2da12f57b</anchor>
      <arglist>(std::ostream &amp;s, const WithFormat &amp;wf)</arglist>
    </member>
  </compound>
</tagfile>
