###############################################################################
# Procps
###############################################################################

# First, try to find new(er) libproc2
pkg_check_modules(LIBPROCPS libproc2)

IF (LIBPROCPS_FOUND)
    MESSAGE(STATUS "Using libproc2")
    SET(MIRA_USE_LIBPROC2 TRUE)

    IF (CMAKE_VERBOSE_MAKEFILE)
        MESSAGE(STATUS "LIBPROCPS")
        MESSAGE(STATUS "   incdir = " ${LIBPROCPS_INCLUDE_DIRS})
        MESSAGE(STATUS "   libdir = " ${LIBPROCPS_LIBRARY_DIRS})
        MESSAGE(STATUS "   libs   = " ${LIBPROCPS_LIBRARIES})
    ENDIF (CMAKE_VERBOSE_MAKEFILE)
ELSE()
    # ... if libproc2 was not found, we need libprocps
    MESSAGE(STATUS "Using libprocps")
    SET(MIRA_USE_LIBPROC2 FALSE)

    pkg_check_modules(LIBPROCPS REQUIRED libprocps)

    IF (CMAKE_VERBOSE_MAKEFILE)
        MESSAGE(STATUS "LIBPROCPS")
        MESSAGE(STATUS "   incdir = " ${LIBPROCPS_INCLUDE_DIRS})
        MESSAGE(STATUS "   libdir = " ${LIBPROCPS_LIBRARY_DIRS})
        MESSAGE(STATUS "   libs   = " ${LIBPROCPS_LIBRARIES})
    ENDIF (CMAKE_VERBOSE_MAKEFILE)
ENDIF()

