###############################################################################
# checks for libbfd and libiberty and the corresponding headers
###############################################################################

# On some 64bit Linux systems, libiberty is compiled without -fPIC (at least
# on Debian and Ubuntu). But on this systems, a second variant libiberty_pic
# exists sometimes. Therefore, we first try to find libiberty_pic.
FIND_LIBRARY(LIBIBERTY_PATH NAMES iberty_pic)
IF(LIBIBERTY_PATH STREQUAL LIBIBERTY_PATH-NOTFOUND)
	FIND_LIBRARY(LIBIBERTY_PATH NAMES iberty)
ENDIF()

FIND_LIBRARY(LIBBFD_PATH      NAMES bfd)
FIND_FILE(BFDHEADER_PATH      NAMES bfd.h)
FIND_FILE(DEMANGLEHEADER_PATH NAMES demangle.h PATH_SUFFIXES libiberty)

SET(HAVE_LINUX_BFD OFF)
SET(HAVE_LINUX_DEMANGLE OFF)
# we need at least libiberty for all
IF(NOT LIBIBERTY_PATH STREQUAL LIBIBERTY_PATH-NOTFOUND)
	IF(NOT ${BFDHEADER_PATH} STREQUAL BFDHEADER_PATH-NOTFOUND AND 
	   NOT ${LIBBFD_PATH} STREQUAL LIBBFD_PATH-NOTFOUND)
		SET(HAVE_LINUX_BFD ON)
	ENDIF(NOT ${BFDHEADER_PATH} STREQUAL BFDHEADER_PATH-NOTFOUND AND 
	      NOT ${LIBBFD_PATH} STREQUAL LIBBFD_PATH-NOTFOUND)
	IF(NOT ${DEMANGLEHEADER_PATH} STREQUAL DEMANGLEHEADER_PATH-NOTFOUND)
		GET_FILENAME_COMPONENT(DEMANGLEHEADER_PATH ${DEMANGLEHEADER_PATH} PATH)
		SET(HAVE_LINUX_DEMANGLE ON)
	ENDIF(NOT ${DEMANGLEHEADER_PATH} STREQUAL DEMANGLEHEADER_PATH-NOTFOUND)
ENDIF(NOT LIBIBERTY_PATH STREQUAL LIBIBERTY_PATH-NOTFOUND)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "LIBIBERTY")
	MESSAGE(STATUS "    lib  = " ${LIBIBERTY_PATH})
	MESSAGE(STATUS "LIBBFD")
	MESSAGE(STATUS "    have = " ${HAVE_LINUX_BFD})
	MESSAGE(STATUS "    lib  = " ${LIBBFD_PATH})
	MESSAGE(STATUS "    inc  = " ${BFDHEADER_PATH})
	MESSAGE(STATUS "DEMANGLE") 
	MESSAGE(STATUS "    have = " ${HAVE_LINUX_DEMANGLE})
	MESSAGE(STATUS "    inc  = " ${DEMANGLEHEADER_PATH})
ENDIF (CMAKE_VERBOSE_MAKEFILE)

###############################################################################

