###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################

#MESSAGE(STATUS ${CMAKE_BINARY_DIR})
#MESSAGE(STATUS ${CMAKE_SOURCE_DIR})
#MESSAGE(STATUS ${CMAKE_CURRENT_LIST_FILE})

###############################################################################

# Sanity check for cmake version
IF (CMAKE_VERSION VERSION_LESS 3.16.0)
	MESSAGE(FATAL_ERROR "OOOPS, cmake is too old. Need at least 3.16.0.")
ENDIF()

###############################################################################
# Setup some cmake policies

MESSAGE(WARNING "Setting policies CMP0046 to OLD")
	
# no error on non-existent dependency in add_dependencies
# (this is used in AddLibrary.cmake to add dependencies to the dist targets)
cmake_policy(SET CMP0046 OLD)

###############################################################################
# Determine the MIRA_PATH

SET(MIRA_PATH_PRE $ENV{MIRA_PATH})

# note: the "" around "${MIRA_PATH_PRE}" are very important !
string(REPLACE ":" ";" MIRA_PATH_PRE "${MIRA_PATH_PRE}")

# strip any trailing slashes from every path in MIRA_PATH env
FOREACH(path ${MIRA_PATH_PRE})
	GET_FILENAME_COMPONENT(pathComponent ${path} ABSOLUTE)
	LIST(APPEND  MIRA_PATH ${pathComponent})
	MESSAGE(STATUS "Found '${pathComponent}' in MIRA_PATH")
ENDFOREACH(path)

##############################################################################
# Prechecks

# find the directory with the MIRA make scripts (using the path of THIS file)
GET_FILENAME_COMPONENT(MIRA_MAKE_DIR ${CMAKE_CURRENT_LIST_FILE} PATH)
SET(CMAKE_MODULE_PATH ${MIRA_MAKE_DIR}) # use that directory as module path

##############################################################################
# Determine the temporary directory

SET(TMPDIR "/tmp")

IF(NOT EXISTS "${TMPDIR}")
	MESSAGE(FATAL_ERROR "OOOPS, can't determine temporary directory.")
ENDIF()

##############################################################################
# Compiler settings

# check if we are using CLANG or GCC
IF("${CMAKE_C_COMPILER}" MATCHES "clang")
	INCLUDE(ClangSettings)
ELSE()
	INCLUDE(GccSettings)
ENDIF()


##############################################################################

# Compiler Flags for AddressSanitizer
if(ENABLE_ASAN)
	message(STATUS "AddressSanitizer is enabled")

	set(ASAN_FLAGS "-fsanitize=address -g -fno-omit-frame-pointer")

	# C/C++
	set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${ASAN_FLAGS}")
	set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${ASAN_FLAGS}")

	if (CMAKE_CXX_COMPILER_ID MATCHES "Clang")
		set(CMAKE_LINKER_FLAGS "${CMAKE_LINKER_FLAGS} ${ASAN_FLAGS}")
	endif()
endif()

##############################################################################

# Flags for ccache support
if(USE_CCACHE)
	find_program(CCACHE_PROGRAM ccache)
	if(CCACHE_PROGRAM)
		message(STATUS "ccache found: ${CCACHE_PROGRAM}")
		set(CMAKE_C_COMPILER_LAUNCHER "${CCACHE_PROGRAM}")
		set(CMAKE_CXX_COMPILER_LAUNCHER "${CCACHE_PROGRAM}")
	else()
		message(FATAL_ERROR "USE_CCACHE is ON, but 'ccache' was not found in PATH. Please install ccache or set USE_CCACHE=OFF in GlobalConfig.cmake.")
	endif()
endif()

##############################################################################
# Crosscompile settings

IF (CMAKE_CROSSCOMPILING)
	INCLUDE(Crosscompile)
ENDIF (CMAKE_CROSSCOMPILING)

##############################################################################
# Set library pre and suffixes

SET(CMAKE_FIND_LIBRARY_PREFIXES "lib")
SET(CMAKE_FIND_LIBRARY_SUFFIXES ".so;.a")

##############################################################################
# Perform some important prechecks

IF (${CMAKE_BINARY_DIR} STREQUAL ${CMAKE_SOURCE_DIR})
	MESSAGE(FATAL_ERROR "You must NOT run 'cmake .' in the root directory! In-source-builds are not allowed. Use one of the following instead:\n    > make [debug]\n    > make release\n    > make test")
ENDIF (${CMAKE_BINARY_DIR} STREQUAL ${CMAKE_SOURCE_DIR})

##############################################################################
# Define path where to store external dependencies for the current build environment
SET(MIRA_EXTERNAL_DIR "${CMAKE_SOURCE_DIR}/external")

##############################################################################
# Include other CMake-Scripts

INCLUDE(AddBinary)
INCLUDE(AddDocumentation)
INCLUDE(AddExistingSubdirs)
INCLUDE(AddLibrary)
INCLUDE(AddSubdir)
INCLUDE(AddSources)
INCLUDE(AddSourceProperties)
INCLUDE(AddTargetProperties)
INCLUDE(AddTest)
INCLUDE(Dist)
INCLUDE(IncludeExistingMakefiles)
INCLUDE(InsourceMakefile)
INCLUDE(Install)
INCLUDE(JoinArguments)
INCLUDE(LinkLibraries)
INCLUDE(ListSubdirectories)
INCLUDE(Manifest)
INCLUDE(Testing)

# should be the last one
INCLUDE(Package)
INDEX_ALL_PACKAGES()
INCLUDE(DocTag)
INDEX_ALL_DOCTAGS()

##############################################################################
# add all link directories from MIRA_PATH

FOREACH(linkDirPath ${MIRA_PATH})
	MESSAGE(STATUS "Adding lib dir ${linkDirPath}/lib")
	LINK_DIRECTORIES(${linkDirPath}/lib)
ENDFOREACH(linkDirPath)

##############################################################################
# For external projects and packages that need to be downloaded
# we need the following script

INCLUDE(ExternalDependencies)
