###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides the functionality for calling the install target of the  make system
# for a single package
# Therefore the location of the package is obtained using the PackageList.txt file
# Afterwards, the install target is executed in the build directory of the package.
# This file is designed to work in CMake script mode.
# Therefore one should pass the following parameters using the -D option of CMake.
#
# Package - name of the Package
# TopDir  - top mira directory
# DestDir - target directory for installation -> make DESTDIR=...
# Target  - make target (e.g. debug or release)
#
# author: Ronny Stricker
#
###############################################################################

##############################################
# Obtain package location from PackageList.txt
# See Package.cmake

INCLUDE(${CMAKE_CURRENT_LIST_DIR}/Package.cmake)

MIRA_FIND_PACKAGE( ${Package} )

##############################################
# check if package was found
IF ( NOT PACKAGE_${Package}_FOUND )
	MESSAGE(FATAL_ERROR "Cannot find MIRA package file '" ${Package} "'.")
ENDIF()

# Remove leading MIRAPath and filename of package
FILE(RELATIVE_PATH RelFileName ${TopDir} ${PACKAGE_${Package}_PATH})
GET_FILENAME_COMPONENT(RelPath ${RelFileName} PATH)

##############################################
# Execute install command in the corresponding
# build directory of the target

SET(MIRA_BUILD_COMMAND "make")

EXECUTE_PROCESS( COMMAND "${MIRA_BUILD_COMMAND}" "DESTDIR=${DestDir}" "install"
                 WORKING_DIRECTORY "${TopDir}/build/${Target}/${RelPath}" )

