/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file MultiInputDialog.C
 *
 * @author Tim Langner
 * @date   2012/01/08
 */

#include <widgets/MultiInputDialog.h>

#include <QHBoxLayout>
#include <QLabel>
#include <QTextEdit>
#include <QLineEdit>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

MultiInputDialog::MultiInputDialog(const QString& title, QWidget* parent) :
	QDialog(parent)
{
	setWindowTitle(title);
	mLayout = new QVBoxLayout(this);

	mButtonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
	connect(mButtonBox,  SIGNAL(accepted()), this, SLOT(accept()));
	connect(mButtonBox,  SIGNAL(rejected()), this, SLOT(reject()));
	mLayout->addWidget(mButtonBox);
}


void MultiInputDialog::addInputField(const QString& name,
                                     const QString& description,
                                     const QString& data,
                                     bool multiLine)
{
	QHBoxLayout* layout = new QHBoxLayout();
	QLabel* label = new QLabel(description, this);
	label->setMinimumWidth(150);
	layout->addWidget(label);
	if (!multiLine)
	{
		QLineEdit* edit = new QLineEdit(this);
		edit->setText(data);
		edit->setMinimumWidth(250);
		mInputFields[name] = edit;
	}
	else
	{
		QTextEdit* edit = new QTextEdit(this);
		edit->setAcceptRichText(false);
		edit->setText(data);
#if QT_VERSION > QT_VERSION_CHECK(5, 12, 0)
		edit->setTabStopDistance(15);
#else
		edit->setTabStopWidth(15);
#endif
		edit->setWordWrapMode(QTextOption::NoWrap);
		edit->setMinimumWidth(250);
		mInputFields[name] = edit;
	}
	layout->addWidget(mInputFields[name], 100);
	mLayout->insertLayout(mLayout->count()-1, layout);
}

QString MultiInputDialog::getInput(const QString& name)
{
	if (mInputFields.count(name) > 0 )
	{
		QLineEdit* le = dynamic_cast<QLineEdit*>(mInputFields[name]);
		if (le)
			return le->text();
		QTextEdit* te = dynamic_cast<QTextEdit*>(mInputFields[name]);
		if (te)
			return te->toPlainText();
	}
	return "";
}

///////////////////////////////////////////////////////////////////////////////

} // namespace

