/* -*- mode: c++ -*- */
/***************************************************************************
qconsole.h  -  description
 -------------------
begin                : mar mar 15 2005
copyright            : (C) 2005 by Houssem BDIOUI
email                : houssem.bdioui@gmail.com
 ***************************************************************************/

// Source: http://sourceforge.net/projects/qconsole/
// migrated to Qt4 by YoungTaek Oh. date: Nov 29, 2010
// adapted to MIRA and removed unnecessary bloat (e.g. saved script, etc)

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QCONSOLE_H
#define QCONSOLE_H

#include <QStringList>
#include <QTextEdit>
#include <QMouseEvent>
#include <QKeyEvent>
#include <QMenu>

#include <QDialog>
#include <QListWidget>
#include <QDebug>

#include <utils/ExtensibleEnum.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 *  Popup Completer class
 *
 *  @author YoungTaek Oh
 *  @todo 1. beautifying
 *        2. icons for classifying words (eg. functions, properties...)
 *        3. bugs?
 *  @note still experimental
 */
class QConsolePopupCompleter : public QDialog
{
	Q_OBJECT

public:
	QConsolePopupCompleter(const QStringList&, QWidget *parent = 0);
	virtual ~QConsolePopupCompleter();

public:
	QString selected(void) { return selected_; }
	int exec(QTextEdit*);

protected:
	virtual void showEvent(QShowEvent*);

private Q_SLOTS:
	void onItemActivated(QListWidgetItem*);

public:
	QListWidget *listWidget_;
	QString selected_;
};

/**
 * An abstract Qt console
 * @author Houssem BDIOUI
 */
class QConsole : public QTextEdit
{
	Q_OBJECT
public:
	//constructor
	QConsole(QWidget *parent = NULL, const QString &welcomeText = "");
	//set the prompt of the console
	void setPrompt(const QString &prompt, bool display = true);
	//execCommand(QString) executes the command and displays back its result
	bool execCommand(const QString &command, bool writeCommand = true,
	                 bool showPrompt = true, QString *result = NULL);
	void clear();
	void reset(const QString &welcomeText = "");

	//cosmetic methods !

	// @{
	/// get/set command color
	QColor cmdColor() const { return cmdColor_; }
	void setCmdColor(QColor c) {cmdColor_ = c;}
	// @}

	// @{
	/// get/set error color
	QColor errColor() const { return errColor_; }
	void setErrColor(QColor c) {errColor_ = c;}
	// @}

	// @{
	/// get/set output color
	QColor outColor() const { return outColor_; }
	void setOutColor(QColor c) {outColor_ = c;}
	// @}
	void setCompletionColor(QColor c) {completionColor = c;}

	// @{
	/// get set font
	void setFont(const QFont& f);
	QFont font() const { return currentFont(); }
	// @}

protected:

	// interface for derived console classes to write some output
	void setFormat(QColor color, bool bold=false, bool italic=false);
	void setFormat(bool bold=false, bool italic=false);
	void println(const QString& s);
	void println(const std::string& s);
	void println(const char* s);


protected:
	void keyPressEvent(QKeyEvent * e);
	void contextMenuEvent( QContextMenuEvent * event);

	//Return false if the command is incomplete (e.g. unmatched braces)
	virtual bool isCommandComplete(const QString &command);
	//Get the command to validate
	QString getCurrentCommand();

	//Replace current command with a new one
	void replaceCurrentCommand(const QString &newCommand);

	//Test whether the cursor is in the edition zone
	bool isInEditionZone();
	bool isInEditionZone(int pos);

	//Test whether the selection is in the edition zone
	bool isSelectionInEditionZone();
	//Change paste behaviour
	void insertFromMimeData(const QMimeData *);


	//protected attributes
protected:
	//colors
	QColor cmdColor_, errColor_, outColor_, completionColor;

	int oldPosition;
	// cached prompt length
	int promptLength;
	// The prompt string
	QString prompt;
	// The commands history
	QStringList history;
	// Current history index (needed because afaik QStringList does not have such an index)
	int historyIndex;
	//Holds position of the prompt
	int promptPosition;

protected:
	virtual void dragEnterEvent(QDragEnterEvent *e);
	virtual void dragLeaveEvent(QDragLeaveEvent *e);
	virtual void dragMoveEvent(QDragMoveEvent *e);
	virtual void dropEvent(QDropEvent *e);

	void mousePressEvent(QMouseEvent*);
	void mouseReleaseEvent(QMouseEvent*);

	//execute a validated command (should be reimplemented and called at the end)
	//the return value of the function is the string result
	//res must hold back the return value of the command (0: passed; else: error)
	virtual QString interpretCommand(const QString &command, int *res);

	//give suggestions to autocomplete a command (should be reimplemented)
	//the return value of the function is the string list of all suggestions
	//the returned prefix is useful to complete "sub-commands"
	virtual QStringList suggestCommand(const QString &cmd, QString &prefix);


public slots:
	//Contextual menu slots
	void cut();

	//displays the prompt
	void displayPrompt();

	void onCursorPositionChanged();

Q_SIGNALS:
	//Signal emitted after that a command is executed
	void commandExecuted(const QString &command);

private:
	void handleTabKeyPress();
	void handleReturnKeyPress();
	void handleUpKeyPress();
	void handleDownKeyPress();
	void setHome();

protected:

	MIRA_EXTENSIBLE_ENUM_DECLARE(SearchMode, ExtensibleEnum<SearchMode>,
	                             SEARCH_NONE, SEARCH_HISTORY)

protected: // Specific search stuff, to be reimplemented in subclasses for own search capabilities
	virtual const SearchMode& searchModeCommand(QKeyEvent* event);
	virtual void enterSearchMode(const SearchMode& mode);
	virtual QString getSearchModeDescriptor();
	virtual QStringList getSearchList();
	// distinguish between string used for comparison (=first) and the respective command (=second)
	virtual std::multimap<QString, QString> getExtendedSearchList();

protected: // (General) Search stuff
	SearchMode currentSearchMode;

private:
	bool handleSearchKeyEvent(QKeyEvent* event); // return true if event was handled

	void overwriteCommand(QString command);
	void clearCurrentLine();
	void setCursorToEditZone();

	void resetSearch();
	void updateSearchMatches();
	void updateSearchCursor(QString query, QString result, int index, int numResults);

	void handleSearch(const SearchMode& mode);
	void handleSearchInput(QKeyEvent* event);
	void handleSearchReturnKey();
	void handleSearchEscapeKey();

	QString searchInput;

	QStringList searchMatches;
	int searchMatchIndex;

	// Store the previous prompt as we will have to restore it
	QString previousPrompt;
};

///////////////////////////////////////////////////////////////////////////////
}
#endif
