/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file CollapsibleTreeHeader.h
 *    Provides a header for tree widgets with an additional expand/collapse
 *    button in the first column.
 *
 * @author Ronny Stricker
 * @date   2013/06/07
 */

#ifndef _MIRA_COLLAPSIBLETREEHEADER_H_
#define _MIRA_COLLAPSIBLETREEHEADER_H_

#include <QHeaderView>
#include <QPushButton>

class QTreeView;
class QMouseEvent;
class QPainter;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * @brief Header for tree widgets with additional collapse/expand button
 * in the first column.
 */
class CollapsibleTreeHeader: public QHeaderView
{

public:

	CollapsibleTreeHeader(Qt::Orientation orientation, QTreeView* parent = 0);

protected:

	/**
	 * @brief Paint section of header.
	 * Calls regular paint section for all sections but section 0.
	 * Draws additional button (using primitives) on first section.
	 */
	void paintSection( QPainter* painter,
	                   QRect const& rect,
	                   int logicalIndex) const;

	/**
	 * @brief Mouse press event.
	 * Set state of button to pressed if button is under mouse. Anyhow, the
	 * event is directed to the base class.
	 */
	void mousePressEvent( QMouseEvent* event );

	/**
	 * @brief Mouse release event.
	 * Set state of button back to normal. Calls foldTree() if mouse is release
	 * over button. Anyhow, the event is directed to the base class.
	 */
	void mouseReleaseEvent( QMouseEvent* event );

	/**
	 * @brief Call collapseAll or expandAll on associated tree widget.
	 */
	void foldTree();

private:
	QIcon::State state;
	QScopedPointer<QPushButton> button;
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
