/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file AxesObject.h
 *    Declaration of the AxesObject.
 *
 * @author Tim Langner
 * @date   2011/01/04
 */

#ifndef _MIRA_AXESOBJECT_H_
#define _MIRA_AXESOBJECT_H_

#include <visualization/3d/VisualizationObject.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

class ArrowObject;

class AxesObject : public VisualizationObject
{
public:
	enum AxesFlags
	{
		NO_AXIS = 0x00,
		X_AXIS  = 0x01,
		Y_AXIS  = 0x02,
		Z_AXIS  = 0x04,
	};

	AxesObject(Ogre::SceneManager* sceneManager, Ogre::SceneNode* parent = NULL);
	virtual ~AxesObject();

	float getLength() const	{ return mAxisLength; }
	void setLength(float length);

	float getRadius() const { return mAxisRadius; }
	void setRadius(float radius);

	const Ogre::ColourValue& getXAxisColor() { return mXAxisColor; }
	const Ogre::ColourValue& getYAxisColor() { return mYAxisColor; }
	const Ogre::ColourValue& getZAxisColor() { return mZAxisColor; }
	void setColor(const Ogre::ColourValue& xaxis, const Ogre::ColourValue& yaxis, const Ogre::ColourValue& zaxis);
	void setColor(const Ogre::ColourValue& uniform);

	bool isShowingXAxis() const { return mShowXAxis; }
	void showXAxis(bool show);
	bool isShowingYAxis() const { return mShowYAxis; }
	void showYAxis(bool show);
	bool isShowingZAxis() const { return mShowZAxis; }
	void showZAxis(bool show);

	bool isShowingArrows() const { return mShowArrows; }
	void showArrows(bool show);

	float getAlpha() const { return mXAxisColor.a; }
	void setAlpha(float alpha);

	bool isVisible() const { return mVisible; }
	virtual void setVisible(bool visible, bool cascade=true);

protected:

	void updateVisibility();
	void updateScales();
	void updateColor();

	bool mVisible;
	bool mShowXAxis;
	bool mShowYAxis;
	bool mShowZAxis;
	bool mShowArrows;
	float mAxisLength;
	float mAxisRadius;
	ArrowObject* mXAxis;
	ArrowObject* mYAxis;
	ArrowObject* mZAxis;

	Ogre::ColourValue mXAxisColor;
	Ogre::ColourValue mYAxisColor;
	Ogre::ColourValue mZAxisColor;
};

//////////////////////////////////////////////////////////////////////////////

}

#endif
