/*
 * Copyright (C) 2014 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PointVectorObject.h
 *    Custom QGraphicsItem that visualizes a std::vector<Point2f>,
 *    or a downprojection of a std::vector<Point3f>.
 *
 * @author Christian Reuther
 * @date   2014/09/09
 */

#ifndef _MIRA_POINTVECTOROBJECT_H_
#define _MIRA_POINTVECTOROBJECT_H_

#include <QAbstractGraphicsShapeItem>

#include <QVector>
#include <QPainter>
#include <QWidget>

#include <geometry/Point.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

// It would probably be a good idea to template this class to match the template params of mira::Point.
template <typename PointType>
class PointVectorObject : public QAbstractGraphicsShapeItem
{
public:
	PointVectorObject(QGraphicsItem* parent = NULL);
	virtual ~PointVectorObject();

	// Using uncoloured data
	void setData(const std::vector<PointType>& data);

	// Using coloured data
	void setData(const std::vector<std::pair<PointType, QColor>>& data);

	void setWidth(qreal width);
	void setColor(const QColor& color);

	qreal width() const;
	QColor color() const;

	QRectF boundingRect() const;

protected:
	void paint(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget = NULL);

protected:
	void addPoint(qreal x, qreal y, QColor color = QColor::Invalid);
	void updateColor();

	typedef QPair<QPointF, QColor> ColouredPoint;

	QVector<ColouredPoint> mData;
	QRectF mBoundingRect;
	QRectF mBoundingRectAdjusted;

	qreal mWidth;
	QColor mColor;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
