/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationControlPage.h
 *    Declaration of the VisualizationControlPage.
 *
 * @author Erik Einhorn
 * @date   2010/12/30
 */

#ifndef _MIRA_VISUALIZATIONCONTROLPAGE_H_
#define _MIRA_VISUALIZATIONCONTROLPAGE_H_

#ifndef Q_MOC_RUN
#include <boost/shared_ptr.hpp>
#endif

#include <QWidget>

#include <factory/Factory.h>

class QPushButton;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class PropertyNode;

class PropertyEditor;
class VisualizationView;
class Visualization;
class VisualizationControl;

/**
 * VisualizationControl page.
 *
 * Visualization editors may provide a corresponding VisualizationControl page.
 * This page will be presented to the user via the standard VisualizationControl
 * (the user decides whether their workbench window contains this view)
 * whenever that editor is active.
 *
 * (Parts of this docu were taken from the Eclipse Platform SDK)
 */
class VisualizationControlPage : public QWidget, public Object
{
	MIRA_OBJECT(VisualizationControlPage)
	Q_OBJECT
public:

	/// Creates a new control page for the visualization view
	VisualizationControlPage(VisualizationView* view);

public:

	void addVisualizationToEditor(Visualization* vis);

private slots:

	void addVisualizationClicked();
	void removeVisualizationClicked();
	void moveUpVisualizationClicked();
	void moveDownVisualizationClicked();

private:

	friend class VisualizationControl; // accesses mEditor to connect slot
	PropertyEditor* mEditor;

private:

	VisualizationView* mView;

	QPushButton *mBtVisualizationAdd;
	QPushButton *mBtVisualizationRemove;
	QPushButton *mBtVisualizationUp;
	QPushButton *mBtVisualizationDown;

};

//////////////////////////////////////////////////////////////////////////////

}

MIRA_NO_PUBLIC_DEFAULT_CONSTRUCTOR( mira::VisualizationControlPage )

#endif
