/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file EditorPartWindow.h
 *    Declaration of the EditorPartWindow.
 *
 * @author Erik Einhorn
 * @date   2011/09/08
 */

#ifndef MIRA_EDITORPARTWINDOW_H_
#define MIRA_EDITORPARTWINDOW_H_

#include <QWidget>
#include <QFrame>
#include <QVBoxLayout>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class EditorPartTitleBar;
class EditorPartArea;

class EditorPartWindow : public QFrame
{
	Q_OBJECT
public:

	EditorPartWindow(EditorPartArea* area=NULL, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~EditorPartWindow();

public:

	void setWidget(QWidget* widget);
	QWidget* widget() const;

public:

	EditorPartTitleBar* getTitleBar();

public:

	/// Undocks the window from the EditorPartArea and makes it floating.
	void undock() {
		onUndock();
	}

	/// Docks the window back to the EditorPartArea.
	void dock() {
		onDock();
	}

	/// Returns true, if the window is docked in the EditorPartArea.
	bool isDocked() const {
		return mDocked;
	}

	/// Makes the window stay on top of other windows.	
	void setOnTop(bool onTop) {
		onOnTop(onTop);
	}

	/// Returns true, if the window stays on top of other windows.
	bool isOnTop() const {
		return mOnTop;
	}

public:

	void showDecorations(bool show);

	void setAutoHideDecorations(bool on);


protected:

	virtual void paintEvent(QPaintEvent *paintEvent);
	virtual void changeEvent(QEvent* event);
	//virtual void enterEvent(QEvent* event);
	//virtual void leaveEvent(QEvent* event);

protected:
	friend class EditorPartArea;

	// managed by EditorPartArea
	void setActive(bool activate);

	virtual void windowStateChanged(Qt::WindowStates oldState, Qt::WindowStates newState);

	void updateDecorations();
	void updateStateButtons(); // buttons for minimize, maximize, restore

protected slots:

	void onMinimized();
	void onMaximized();
	void onRestored();
	void onUndock();
	void onDock();
	void onOnTop(bool onTop);

signals:

	void windowTitleChanged(EditorPartWindow* editor);

private:

	/// the MDI EditorPartArea we are belonging to
	EditorPartArea* mArea;

	/// the layout of this window, that handles the titlebar and content widget
	QVBoxLayout* mLayout;

	/// the title bar
	EditorPartTitleBar* mTitleBar;

	QAction* mOnTopAction;

	/// the user set content widget
	QWidget* mWidget;

	/// an empty default content widget that is set, if the user did not specify a content widget
	QWidget* mEmptyContentWidget;

	/// geometry that is rescued before minimizing or maximizing to allow restoring
	QRect mRestoreGeometry;
	bool mRestoreOnTop;

	bool mAutoHideDecorations;
	bool mDecorationsShown;
	bool mActivated;
	bool mOnTop;

	enum WindowState {
		Minimized,
		Maximized,
		Normal,
	};

	/// The real window state that is visible to the user (Qt window state may differ and can be wrong!)
	WindowState mWindowState;


	bool mDocked;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
