/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file EditorPart.h
 *    Declaration of the EditorPart class.
 *
 * @author Erik Einhorn
 * @date   2010/12/01
 */

#ifndef _MIRA_EDITORPART_H_
#define _MIRA_EDITORPART_H_

#include <QtGui/QImage>

#include <serialization/ReflectorInterface.h>

#include <rcp/WorkbenchPart.h>
#include <rcp/EditorPartWindow.h>

// fwd decl
class QMenu;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * An editor is typically used to edit or browse data or objects. Editors are
 * shown as tabbed MDI windows. In contrast to views there may exist multiple
 * instances of a certain editor type.
 */
class EditorPart : public EditorPartWindow, public WorkbenchPart
{
	Q_OBJECT
	MIRA_ABSTRACT_OBJECT(EditorPart)
public:
	EditorPart();

	virtual ~EditorPart();

public:
	virtual void init(IWorkbenchPartSite* site);

	IWorkbenchPartSite* getSite();

public:

	/**
	 * Returns the content of the editor part as QImage.
	 * Can be reimplemented by subclasses to provide special capturing
	 * techniques that are e.g. required by OpenQL widgets.
	 */
	virtual QImage captureContent();

protected:

	/**
	 * Must be overloaded in subclasses to create the actual widget for
	 * this EditorPart.
	 * This EditorPart should be set as parent for the created widget.
	 */
	virtual QWidget* createPartControl() = 0;

	/**
	 * Returns the optional editor menu that is shown when the user clicks the
	 * editor menu tool button.
	 * An EditorPart can add items to this menu within it's createPartControl()
	 * method, by calling this method and populating items to the menu.
	 */
	QMenu* getViewMenu();

	virtual void closeEvent(QCloseEvent*);

signals:

	void editorClosed(EditorPart* editor);
	void editorDestroyed(EditorPart* editor);

private:
	IWorkbenchPartSite* mSite;
};

///////////////////////////////////////////////////////////////////////////////
}

#endif
