###############################################################################
# Ogre
###############################################################################

# Check, if the Orge package search was already done
GET_PROPERTY(OrgePackageSearchAlreadyDone GLOBAL PROPERTY OGRE_PACKAGE_FOUND)

IF(NOT OrgePackageSearchAlreadyDone)

	# Get path to Ogre based on the environment variable OGRE_HOME
	SET(OGRE_HOME $ENV{OGRE_HOME})

	###########################################################################
	# On Linux, try to find and use an already installed Ogre version.

	# Ensure, that cmake can find FindOGRE.cmake
	IF( OGRE_HOME )
		SET(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} ${OGRE_HOME}/CMake)
	ENDIF()
	SET(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH}
			# necessary when using cmake3 on an old cmake2 system
			/usr/share/cmake/Modules
			/usr/share/OGRE/cmake/modules
			/usr/lib/OGRE/cmake
			/usr/lib64/OGRE/cmake
			/usr/local/lib/OGRE/cmake
			/usr/local/lib64/OGRE/cmake)

	# Look for an installed Ogre package
	FIND_PACKAGE(OGRE QUIET)
	IF( NOT OGRE_FOUND )
		MESSAGE(FATAL_ERROR "Can't find package Ogre.")
	ENDIF()

	#######################################################################
	# Check version of installed Ogre package

	# determine Ogre version numbers
	INCLUDE(OgreGetVersion)
	OGRE_GET_VERSION(${OGRE_INCLUDE_DIR}/OgrePrerequisites.h)
	MESSAGE(STATUS "Found Ogre version ${OGRE_VERSION}")

	# We need at least version 1.7.x
	IF ( (NOT ${OGRE_VERSION_MAJOR} EQUAL 1) OR (${OGRE_VERSION_MINOR} LESS 7) )
		MESSAGE(FATAL_ERROR "Installed Ogre version is too old. Need at least 1.7.x")
	ENDIF()

	# Version 1.9.x requires Ogre Overlay
	IF ( (${OGRE_VERSION_MAJOR} EQUAL 1) AND (${OGRE_VERSION_MINOR} GREATER 8) AND (NOT ${OGRE_Overlay_FOUND}) )
		MESSAGE(FATAL_ERROR "Ogre component 'Overlay' is required!")
	ENDIF()

	###########################################################################

	# Avoid doing the same thing again by setting a GLOBAL property
	SET_PROPERTY(GLOBAL PROPERTY OGRE_PACKAGE_FOUND 1)

	# Save the settings in some global properties.
	SET_PROPERTY(GLOBAL PROPERTY OGRE_GLOBAL_INCLUDE_DIRS ${OGRE_INCLUDE_DIRS})
	SET_PROPERTY(GLOBAL PROPERTY OGRE_GLOBAL_LIBRARY_DIRS ${OGRE_LIBRARY_DIRS})

	# Version 1.9.x requires Ogre Overlay
	IF ( (${OGRE_VERSION_MAJOR} EQUAL 1) AND (${OGRE_VERSION_MINOR} GREATER 8) )
		SET_PROPERTY(GLOBAL PROPERTY OGRE_GLOBAL_LIBRARIES    ${OGRE_LIBRARIES} ${OGRE_Overlay_LIBRARIES})
	ELSE()
		SET_PROPERTY(GLOBAL PROPERTY OGRE_GLOBAL_LIBRARIES    ${OGRE_LIBRARIES})
	ENDIF()

	###########################################################################

	GET_PROPERTY(OGRE_LIBRARIES    GLOBAL PROPERTY OGRE_GLOBAL_LIBRARIES)

	IF (CMAKE_VERBOSE_MAKEFILE)
		MESSAGE(STATUS "OGRE")
		MESSAGE(STATUS "   incdir = " ${OGRE_INCLUDE_DIRS})
		MESSAGE(STATUS "   libdir = " ${OGRE_LIBRARY_DIRS})
		MESSAGE(STATUS "   libs   = " ${OGRE_LIBRARIES})
	ENDIF (CMAKE_VERBOSE_MAKEFILE)

	###########################################################################

ELSE(NOT OrgePackageSearchAlreadyDone)

	# The Orge package was already found. Thus we only restore the
	# variables from the global properties.
	GET_PROPERTY(OGRE_INCLUDE_DIRS GLOBAL PROPERTY OGRE_GLOBAL_INCLUDE_DIRS)
	GET_PROPERTY(OGRE_LIBRARY_DIRS GLOBAL PROPERTY OGRE_GLOBAL_LIBRARY_DIRS)
	GET_PROPERTY(OGRE_LIBRARIES    GLOBAL PROPERTY OGRE_GLOBAL_LIBRARIES)

ENDIF(NOT OrgePackageSearchAlreadyDone)

###############################################################################
