/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file FrameworkCPULoadTest.C
 *
 * @author Erik Einhorn
 * @date   2011/06/25
 */

#include <boost/test/unit_test.hpp>

#include <fw/Framework.h>
#include <math/LinearInterpolator.h>

#include <serialization/Serialization.h>

using namespace mira;

const char* argv[] = {"FrameworkCPULoadTest", "-d5", "--no-colors"};
Framework fw(3,(char**)argv);

const int count = 1000000000;

void callback21(ChannelRead<int> value)
{
	Duration d = Time::now() - value->timestamp;
	MIRA_LOG(NOTICE) << "callback21: " << value->value() << ", " << d;
	/*int val = value->value();
	for(int i=0; i<count; ++i)
		val += val;
	MIRA_LOG(NOTICE) << val;*/
	boost::this_thread::sleep(Duration::milliseconds(500));
}

void callback22(ChannelRead<int> value)
{
	Duration d = Time::now() - value->timestamp;
	MIRA_LOG(NOTICE) << "callback22: " << value->value() << ", " << d;
}

void callback31(ChannelRead<int> value)
{
	Duration d = Time::now() - value->timestamp;
	MIRA_LOG(NOTICE) << "callback31: " << value->value() << ", " << d;
}

void callback32(ChannelRead<int> value)
{
	Duration d = Time::now() - value->timestamp;
	MIRA_LOG(NOTICE) << "callback32: " << value->value() << ", " << d;
}

///////////////////////////////////////////////////////////////////////////////


BOOST_AUTO_TEST_CASE( CPULoadTest)
{
	std::cout << "CTEST_FULL_OUTPUT (Avoid ctest truncation of output)" << std::endl;

	Authority authority1("/", "Authority1");
	Authority authority2("/", "Authority2");
	//Authority authority3("/", "Authority3");

	Channel<int> ch11 = authority1.publish<int>("Channel1");
	Channel<int> ch12 = authority1.publish<int>("Channel2");

	Channel<int> ch21 = authority2.subscribe<int>("Channel1", callback21);
	Channel<int> ch22 = authority2.subscribe<int>("Channel2", callback22);

	//Channel<int> ch31 = authority3.subscribe<int>("Channel1", callback31);
	//Channel<int> ch32 = authority3.subscribe<int>("Channel2", callback32);

	for (int i=0; i<100; ++i)
	{
		ch11.post(i);
		ch12.post(i);
		boost::this_thread::sleep(Duration::milliseconds(100));
	}

	boost::this_thread::sleep(Duration::milliseconds(2000));
}
