/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ChannelPromoteByTypenameTestUnits3.C
 *    Test units for channel promotion by runtime typename.
 *
 * @author Christof Schröter
 * @date   2018/08/29
 */

#include <fw/Unit.h>
#include <factory/Factory.h>

#include <fw/ChannelPromoteByTypenameRegistration.h>

#include "ChannelPromoteByTypenameTest.h"

using namespace mira;

namespace mira { namespace test { namespace channel_promote { namespace ns3 {

///////////////////////////////////////////////////////////////////////////////

/**
 * Test unit publishing channels
 */
class TestTyped : public MicroUnit
{
	MIRA_OBJECT(TestTyped)

protected:

	virtual void initialize();

	void onSignal(ChannelRead<bool> data);
	void postData();

private:

	Channel<Time> mTimeChannel;
	Channel<int> mIntChannel;
	Channel<float> mFloatChannel;
	Channel<String> mStringChannel;
	Channel<char> mCharChannel;
	Channel<double> mDoubleChannel;
};

///////////////////////////////////////////////////////////////////////////////

void TestTyped::initialize()
{
	mTimeChannel = publish<Time>("Time");
	mIntChannel = publish<int>("Int");
	mFloatChannel = publish<float>("Float");
	mStringChannel = publish<String>("String");
	mCharChannel = publish<char>("Char");
	mDoubleChannel = publish<double>("Double");

	subscribe<bool>("/Signal", &TestTyped::onSignal, this);
}

void TestTyped::onSignal(ChannelRead<bool> data)
{
	postData();
}

void TestTyped::postData()
{
	std::cout << "3::postData" << std::endl;
	mTimeChannel.post(Time());
	mIntChannel.post(0);
	mFloatChannel.post(0.f);
	mStringChannel.post(String());
	mCharChannel.post('0');
	mDoubleChannel.post(0.);
	std::cout << "3::postData done" << std::endl;
}

///////////////////////////////////////////////////////////////////////////////

/**
 * Test unit subscribing channels
 */
class TestVoid : public MicroUnit
{
	MIRA_OBJECT(TestVoid)

protected:

	virtual void initialize();

	void onSignal(ChannelRead<bool> data);
	void postData();

private:

	Channel<void> mTimeChannel;
	Channel<void> mIntChannel;
	Channel<void> mFloatChannel;
	Channel<void> mStringChannel;
	Channel<void> mCharChannel;
	Channel<void> mDoubleChannel;

	Channel<void> mTimeChannel2;
	Channel<void> mIntChannel2;
	Channel<void> mFloatChannel2;
	Channel<void> mStringChannel2;
	Channel<void> mCharChannel2;
	Channel<void> mDoubleChannel2;
};

///////////////////////////////////////////////////////////////////////////////

void TestVoid::initialize()
{
	mTimeChannel = subscribe<void>("Time");
	mIntChannel = subscribe<void>("Int");
	mFloatChannel = subscribe<void>("Float");
	mStringChannel = subscribe<void>("String");
	mCharChannel = subscribe<void>("Char");
	mDoubleChannel = subscribe<void>("Double");

	mTimeChannel2 = publish<void>("Time2", typeName<Time>());
	mIntChannel2 = publish<void>("Int2", typeName<int>());
	mFloatChannel2 = publish<void>("Float2", typeName<float>());
	mStringChannel2 = publish<void>("String2", typeName<String>());
	mCharChannel2 = publish<void>("Char2", typeName<char>());
	mDoubleChannel2 = publish<void>("Double2", typeName<double>());

	subscribe<bool>("/Signal2", &TestVoid::onSignal, this);
}

void TestVoid::onSignal(ChannelRead<bool> data)
{
	postData();
}

void TestVoid::postData()
{
	postJSON<Time>(mTimeChannel2);
	postJSON<int>(mIntChannel2);
	postJSON<float>(mFloatChannel2);
	//postJSON<String>(mStringChannel2);
	postJSON<char>(mCharChannel2);
	postJSON<double>(mDoubleChannel2);
}

///////////////////////////////////////////////////////////////////////////////

}}}}

MIRA_REGISTER_CHANNELTYPE(mira::Time);
MIRA_REGISTER_CHANNELTYPE(int);

MIRA_CLASS_SERIALIZATION(mira::test::channel_promote::ns3::TestTyped, mira::MicroUnit);
MIRA_CLASS_SERIALIZATION(mira::test::channel_promote::ns3::TestVoid, mira::MicroUnit);
