/*
 * BenchmarkSubscriber.C
 *
 *  Created on: 11.07.2012
 *      Author: erik
 */

#include <lcm/lcm-cpp.hpp>

#include <stdint.h>
#include <stdlib.h>
#include <iostream>

#include <boost/thread.hpp>

#include "../BenchmarkStats.h"

#include "benchmark/Data.hpp"


BenchmarkStats b("Subscriber");

uint64_t memStart;

class Handler
{
public:
	~Handler() {}

	void handleMessage(const lcm::ReceiveBuffer* rbuf,
			const std::string& chan,
			const benchmark::Data * msg)
	{
		uint64_t s = msg->timestamp;
		b.toc(s);

		uint64_t memDiff1 = getMemoryUsage() - memStart;
		std::cout << "Subscriber Memory1: " << memDiff1 << std::endl;
	}
};


int main(int argc, char *argv[])
{
	lcm::LCM lcm;
	if(!lcm.good())
		return 1;

	Handler handlerObject;
	lcm.subscribe("benchmark", &Handler::handleMessage, &handlerObject);
	memStart = getMemoryUsage();

	while(0 == lcm.handle());

	return 0;
}


