/*
 * Copyright (C) 2025 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TestXMLMacroChain.C
 *    Tests calling macros from within macros.
 *
 * @author Adrian Kriegel
 * @date   Mon Feb 10 2025
 */
#include <boost/test/unit_test.hpp>

#include <geometry/Point.h>
#include <serialization/XMLSerializer.h>

#include <xml/macros/Utils.h>
#include <xml/macros/XMLMacroProcessor.h>

#include <xml/macros/TestUtils.h>

using namespace mira;
using namespace mira::xmlmacros;

BOOST_AUTO_TEST_CASE(TestXMLMacroChain)
{
	const std::string xml = wrapInRoot(R"(
		<macro:Define_MakePoint>
			<Parameters>
				<X />
				<Y />
			</Parameters>
			<Body>
				<X><macro:X /></X>
				<Y><macro:Y /></Y>
			</Body>
		</macro:Define_MakePoint>

		<macro:Define_MakeTransposedPoint>
			<Parameters>
				<X />
				<Y />
			</Parameters>
			<Body>
				<macro:MakePoint>
					<X><macro:Y /></X>
					<Y><macro:X /></Y>
				</macro:MakePoint>
			</Body>
		</macro:Define_MakeTransposedPoint>

		<macro:MakeTransposedPoint>
			<X>1</X>
			<Y>2</Y>
		</macro:MakeTransposedPoint>
	)");

	CopyableXMLDom dom;
	dom.loadFromString(xml);

	BOOST_CHECK_EQUAL(CopyableXMLDom(dom).saveToString(), dom.saveToString());

	XMLDomPreprocessor preprocessor;
	preprocessor.preprocessXML(dom);

	Point2i p;
	XMLDeserializer deserializer(dom);
	deserializer.deserializeFromNode("root", p);

	BOOST_CHECK_EQUAL(p.x(), 2);
	BOOST_CHECK_EQUAL(p.y(), 1);
}