/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file IteratorRangeContainerTest.C
 *    Test cases for IteratorRangeContainer.h.
 *
 * @author Erik Einhorn
 * @date   2010/12/05
 */

#include <vector>
#include <iostream>

#include <boost/iterator/transform_iterator.hpp>
#include <boost/test/unit_test.hpp>

#include <utils/IteratorRangeContainer.h>
#include <utils/Foreach.h>

struct GetValue
{
	typedef int result_type;
	int operator()(const int& p) const {
		return p+10;
	}
};


BOOST_AUTO_TEST_CASE( IteratorRangeContainerTest )
{
	std::vector<int> v;

	typedef mira::IteratorRangeContainer<std::vector<int>::iterator> View;

	v.push_back(1);
	v.push_back(2);
	v.push_back(3);
	v.push_back(4);
	v.push_back(5);

	View s(v.begin()+1, v.end()-1);
	BOOST_CHECK(s.size() == 3);
	BOOST_CHECK(*s.begin() == 2);
	BOOST_CHECK(s.front() == 2);
	BOOST_CHECK(s.back() == 4);

	auto begin=boost::make_transform_iterator(v.begin(),GetValue());
	auto end=boost::make_transform_iterator(v.end(),GetValue());
	typedef mira::IteratorRangeContainer<decltype(begin)> View2;

	View2 s2(begin+1,end-1);
	BOOST_CHECK(s2.size() == 3);
	BOOST_CHECK(*s2.begin() == 12);
	BOOST_CHECK(s2.front() == 12);
	BOOST_CHECK(s2.back() == 14);
}
