/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file HumanReadableEnumTest.C
 *    Test cases for HumanReadableEnum.h.
 *
 * @author Ronny Stricker
 * @date   2018/04/11
 */

#include <iostream>

#include <boost/test/unit_test.hpp>

#include <utils/EnumToFlags.h>

#include "HumanReadableEnumLib.h"

BOOST_TEST_DONT_PRINT_LOG_VALUE( Gender )
BOOST_TEST_DONT_PRINT_LOG_VALUE( ShoeSize )

BOOST_AUTO_TEST_CASE( HumanReadableEnum )
{
	BOOST_CHECK_EQUAL(toString(Gender::FEMALE),std::string("FEMALE"));
	BOOST_CHECK_THROW(toString(Gender(3)), mira::XInvalidParameter);

	BOOST_CHECK_EQUAL(int(ShoeSize::SMALL), 30);
	BOOST_CHECK_EQUAL(int(ShoeSize::LARGE), 50);

	BOOST_CHECK_EQUAL(toGender("MALE"), Gender::MALE);
	BOOST_CHECK_THROW(toShoeSize("EXTRALARGE"), mira::XInvalidParameter);
}

MIRA_HUMANREADABLE_ENUM_DECLARE(Side, NONE, LEFT, RIGHT);
MIRA_HUMANREADABLE_ENUM_DEFINE(Side, NONE, LEFT, RIGHT);
MIRA_ENUM_TO_FLAGS(Side);

BOOST_AUTO_TEST_CASE( HumanReadableEnumToFlags )
{
	Side active_sides = Side::LEFT /* | Side::RIGHT */;
	BOOST_CHECK_EQUAL(bool(active_sides & Side::LEFT), true);
	BOOST_CHECK_EQUAL(bool(active_sides & Side::RIGHT), false);
}

namespace mira::test {
	MIRA_HUMANREADABLE_ENUM_DECLARE(EnumInNamespace, VALUE1, VALUE2);
	MIRA_HUMANREADABLE_ENUM_DEFINE(EnumInNamespace, VALUE1, VALUE2);

BOOST_AUTO_TEST_CASE( ToString )
{
	BOOST_CHECK_EQUAL(toString(3), "3");
	BOOST_CHECK_EQUAL(toString(EnumInNamespace::VALUE1),std::string("VALUE1"));
	std::cout << EnumInNamespace::VALUE1 << std::endl;
}

} // namespace test
