/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file HasNonMemberTest.C
 *    Test cases for HasNonMember.h.
 *
 * @author Christof Schröter
 * @date   2021/02/19
 */

#include <boost/test/unit_test.hpp>

#include <utils/HasNonMember.h>


void fVoid(int) {}
void fVoid(int, int) {}
void fVoid(int, bool) {}

int fInt(int, int) { return 0; }
int fInt(float, float) { return 1; }

void fInt2(int, int) {}
int fInt3(int, int) { return 0; }

MIRA_NONMEMBER_FUNCTION1_DETECTOR(void, fVoid);

// Explicitly specify a different identifier for the created detector,
// else the internally created templates (with different param number) will clash
MIRA_NONMEMBER_FUNCTION2_DETECTOR_EX(fVoid2, void, fVoid);

MIRA_NONMEMBER_FUNCTION2_DETECTOR(int, fInt);
MIRA_NONMEMBER_FUNCTION2_DETECTOR(int, fInt2);
MIRA_NONMEMBER_FUNCTION2_DETECTOR(void, fInt3);

#define CHECK(x, val)  BOOST_CHECK_EQUAL((int)(x), val)

BOOST_AUTO_TEST_CASE( HasMemberFunction )
{
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION1(fVoid, int)::value, 1);
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION1(fVoid, bool)::value, 1);          // param cast ok
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION1(fVoid, void*)::value, 0);         // param cast invalid

	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fVoid2, int, int)::value, 1);
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fVoid2, int, bool)::value, 1);
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fVoid2, int, float)::value, 0);

	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt, int, int)::value, 1);
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt, float, float)::value, 1);
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt, void*, int)::value, 0);     // param cast invalid
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt, float, int)::value, 0);     // ambiguous
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt, double, double)::value, 0); // ambiguous
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt, int, double)::value, 1)   ; // unambiguous!

	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt2, int, int)::value, 0);      // wrong return type!
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt3, int, int)::value, 0);      // wrong return type!
}

struct Base {};
struct Derived : public Base {};

void fVoid(Base&) {}
int fInt(Derived&, Derived&) { return 0; }

BOOST_AUTO_TEST_CASE( ClassParamTest )
{
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION1(fVoid, Base&)::value, 1);
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION1(fVoid, Derived&)::value, 1);          // param cast ok
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt, Base&, Base&)::value, 0);       // param cast invalid
	CHECK(MIRA_HAS_NONMEMBER_FUNCTION2(fInt, Derived&, Derived&)::value, 1);
}
