/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file SHA1Test.C
 *    Test case for SHA1.
 *
 * @author Christian Martin
 * @date   2010/11/26
 */

#include <boost/test/unit_test.hpp>

#include <iostream>
#include <security/SHA1.h>

using namespace mira;
using namespace std;

///////////////////////////////////////////////////////////////////////////////

struct SHA1TestEntry {
	const char* mData;
	const char* mDigest;
};

// Test suite from FIPS 180-2
SHA1TestEntry sSHA1TestSuite[3] = {
	{ "abc", "a9993e364706816aba3e25717850c26c9cd0d89d" },
	{ "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq",
	  "84983e441c3bd26ebaae4aa1f95129e5e54670f1" },
	{ "", "34aa973cd4c4daa4f61eeb2bdbad27316534016f" }  // A million repetitions of "a"
};

///////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( SHA1Test_func )
{
	for(int i = 0; i < 3; i++) {
		SHA1 tSHA1;
		if (i == 2) {
			char tABuf[10000];
			for(int j = 0; j < 10000; j++)
				tABuf[j] = 'a';
			for(int j = 0; j < 100; j++)
				tSHA1.write((const char*)&tABuf, 10000);
		} else
			tSHA1.write(sSHA1TestSuite[i].mData,
			            strlen(sSHA1TestSuite[i].mData));

		HashDigest tDigest = tSHA1.getDigest();
		BOOST_CHECK_EQUAL(tDigest.toString(),
		                  string(sSHA1TestSuite[i].mDigest));
	}
}

BOOST_AUTO_TEST_CASE( SHA1Test_stream )
{
	for(int i = 0; i < 3; i++) {
		SHA1 tSHA1;
		if (i == 2) {
			char tABuf[10000];
			for(int j = 0; j < 10000; j++)
				tABuf[j] = 'a';
			for(int j = 0; j < 100; j++)
				tSHA1 << string((const char*)&tABuf, 10000);
		} else
			tSHA1 << sSHA1TestSuite[i].mData;

		HashDigest tDigest = tSHA1.getDigest();
		BOOST_CHECK_EQUAL(tDigest.toString(),
		                  string(sSHA1TestSuite[i].mDigest));
	}
}
