/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file DiamondClassStructure.h
 *    $Build diamond class structure$.
 *
 * @author Ronny Stricker
 * @date   2010/10/25
 */

#ifndef _MIRA_DIAMONDCLASSSTRUCTURE_H_
#define _MIRA_DIAMONDCLASSSTRUCTURE_H_

#include <factory/Factory.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

// Class Hierarchy:
//			----------------Object-----------
//			|								|
//	--------A--------						B
//	|				|						|
//	C				D				--------E--------
//					|				|				|
//					|				F				G
//					|								|
//					|								H
//					--------|------------------------
//							I

////////////////////////////////////////////////////////////////////////////////

class A : virtual public Object {
	MIRA_OBJECT( A )
};

////////////////////////////////////////////////////////////////////////////////

class B : virtual public Object {
	MIRA_OBJECT( B )
};

////////////////////////////////////////////////////////////////////////////////

class C : public A {
	MIRA_OBJECT( C )
};

////////////////////////////////////////////////////////////////////////////////

class D : public A {
	MIRA_OBJECT( D )
};

////////////////////////////////////////////////////////////////////////////////

class E : public B {
	MIRA_OBJECT( E )
};

////////////////////////////////////////////////////////////////////////////////

class F : public E {
	MIRA_OBJECT( F )
};

////////////////////////////////////////////////////////////////////////////////

class G : public E {
	MIRA_OBJECT( G )
};

////////////////////////////////////////////////////////////////////////////////

class H : public G {
	MIRA_OBJECT( H )
};

////////////////////////////////////////////////////////////////////////////////

class I : public D, public H {
	MIRA_OBJECT( I )
};

//////////////////////////////////////////////////////////////////////////////

} // namespace

MIRA_CLASS_REGISTER( mira::A, mira::Object );
MIRA_CLASS_REGISTER( mira::B, mira::Object );
MIRA_CLASS_REGISTER( mira::I, mira::D, mira::H );
MIRA_CLASS_REGISTER( mira::H, mira::G );
MIRA_CLASS_REGISTER( mira::F, mira::E );
MIRA_CLASS_REGISTER( mira::C, mira::A );
MIRA_CLASS_REGISTER( mira::D, mira::A );
MIRA_CLASS_REGISTER( mira::E, mira::B );
MIRA_CLASS_REGISTER( mira::G, mira::E );

#endif /* _MIRA_DIAMONDCLASSSTRUCTURE_H_ */

