/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file AbstractClassesTest.C
 *    $Test the construction of abstract classes and derived classes$.
 *
 * @author Ronny Stricker
 * @date   2010/10/25
 */

#include <boost/test/unit_test.hpp>
#include <factory/Factory.h>

using namespace std;

namespace mira {

//////////////////////////////////////////////////////////////////////////////

// abstract class
class VA : virtual public Object {
	MIRA_ABSTRACT_OBJECT( VA )

	virtual void test() = 0;
};

// test class which implements abstract function
class VB : public VA {
	MIRA_OBJECT( VB )

	virtual void test() { }
};

// test class which implements abstract function
class VC : public VA {
	MIRA_OBJECT( VC )

	virtual void test() { }
};

}

MIRA_CLASS_REGISTER(mira::VC,mira::VA)
MIRA_CLASS_REGISTER(mira::VB,mira::VA)
MIRA_CLASS_REGISTER(mira::VA,mira::Object)

//////////////////////////////////////////////////////////////////////////////

#define TEST_CREATION(pCLASS)                                                  \
	tObject = mira::ClassFactory::newInstance<pCLASS>( #pCLASS );              \
	if ( !tObject || tObject->getClass().getIdentifier() != #pCLASS ) {        \
		throw string("Error creating object ")+string(#pCLASS)+string("!");    \
	}                                                                          \
	else {                                                                     \
		delete tObject;                                                        \
	}

//#############################################################################
//##  AbstractClass Test
//#############################################################################

void registerAbstractClass() {
    mira::FactoryRegisterClass< mira::VA, mira::Object> tRegisterA;
    mira::FactoryRegisterClass< mira::VB, mira::VA> tRegisterB;
    mira::FactoryRegisterClass< mira::VC, mira::VA> tRegisterC;
}

BOOST_AUTO_TEST_CASE( AbstractClass )
{
	// Register the abstract classes
	BOOST_CHECK_NO_THROW( registerAbstractClass() );

	BOOST_CHECK( mira::VA::CLASS().isAbstract() );
	BOOST_CHECK( mira::VB::CLASS().isAbstract() == false );

	// Creation of abstract object should fail
	BOOST_CHECK_THROW(
			mira::ClassFactory::newInstance<mira::Object>( mira::VA::CLASS().getIdentifier() ),
			mira::XFactoryLogical );

	mira::Object* tObject = NULL;

	// It should be possible to create classes which implement the abstract
	// functions
	TEST_CREATION( mira::VB )
	TEST_CREATION( mira::VC )
}

//////////////////////////////////////////////////////////////////////////////

//} // namespace


