/*
 * Copyright (C) 2018 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RPCServer.C
 *    Implements RPCServer.
 *
 * @author Christof Schröter
 * @date   2018/11/30
 */

#include <rpc/RPCServer.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

std::string RPCServer::MethodInfo::extendedSignature() const
{
	{
		std::stringstream ss;
		const RPCSignature& sig = signature;
		if (parameterDesc.empty()) {
			ss << signature;
			return ss.str();
		}

		ss << sig.returnType << " " << sig.name << "(";
		ParameterDescriptions::const_iterator ip = parameterDesc.cbegin();
		for(RPCSignature::ParameterTypes::const_iterator is=sig.parameterTypes.cbegin();
			is!=sig.parameterTypes.cend(); ++is)
		{
			if(is!=sig.parameterTypes.cbegin())
				ss << ", ";
			ss << *is;

			assert(ip!=parameterDesc.cend());
			ss << " " << ip->name;
			++ip;
		}
		ss << ")";
		return ss.str();
	}
}

std::string RPCServer::MethodInfo::parameterDescriptions(const std::string& prefix) const
{
	std::stringstream ss;
	for (ParameterDescriptions::const_iterator i = parameterDesc.cbegin();
	     i!=parameterDesc.cend(); ++i)
	{
		if (i!=parameterDesc.cbegin())
			ss << std::endl;
		ss << prefix << *i;
	}
	return ss.str();
}

std::string RPCServer::MethodInfo::sampleParametersSet(bool formatted) const
{
	if ((!signature.parameterTypes.empty()) && (parameterSamples.empty()))
		return " -- Parameter samples not available -- ";

	std::stringstream ss;
	for(std::list<json::Value>::const_iterator i=parameterSamples.cbegin();
		i!=parameterSamples.cend(); ++i)
	{
		if(i!=parameterSamples.cbegin()) {
			if (formatted)
				ss << "," << std::endl;
			else
				ss << ", ";
		}
		json::write(*i, ss, formatted);
	}
	return ss.str();
}

///////////////////////////////////////////////////////////////////////////////

}

