/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ReflectMemberMeta.h
 *    Struct to take meta information for each reflected member.
 *
 * @author Erik Einhorn
 * @date   2010/09/24
 */
#ifndef _MIRA_REFLECTMEMBERMETA_H_
#define _MIRA_REFLECTMEMBERMETA_H_

#include <string>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * @ingroup SerializationModule
 *
 * Stores meta information for each member. These are:
 *   - the name (as specified in the XML file),
 *   - the id (used for containers where the name is identical,
 *     in all other cases the id usually is equal to the name),
 *   - additional comments for the user
 */
struct ReflectMemberMeta
{
	/// The name (as specified in the XML file).
	const char* name;

	/**
	 * The id (used for containers where the name is identical,
	 * in all other cases the id usually is equal to the name),
	 */
	const char* id;

	/// Additional user comments
	const char* comment;

	ReflectMemberMeta(const char* iName, const char* iId,
			const char* iComment) :
		name(iName), id(iId), comment(iComment) {}

	std::string getName() const {
		return name ? name : "_inline";
	}

	std::string getID() const {
		return id ? id : "_inline";
	}

};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif /* MIRA_REFLECTMEMBERMETA_H_ */
