/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ColormapTest.C
 *    An example how to use the Colormaps classes.
 *
 * @author Erik Einhorn
 */

#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>

#include <geometry/Point.h>
#include <image/Img.h>
#include <image/Colormap.h>

using namespace mira;

///////////////////////////////////////////////////////////////////////////////

int main()
{
	Img8U3 img(640,540);

	// iterate over discrete Complementary10Colormap
	Complementary10Colormap pal1;
	int x = 0;
	foreach(const Color::RGB& c, pal1)
	{
		cv::rectangle((cv::Mat&)img, Point2i(x,0),Point2i(x+20,20),c,-1);
		x+=20;
	}

	// loop over JetColormap
	JetColormap jet(256); // since the palette is continuous we can specify an arbitrary size here
	for(std::size_t i=0; i<jet.size(); ++i) {
		cv::line((cv::Mat&)img, Point2i(i,40),Point2i(i,60), jet.get(i));
	}
	// draw all available continuous palettes:

	// query all palette classes from the class factory:
	typedef std::map<std::string, ClassProxy> ClassMap;
	ClassMap continuousColormaps
		= ContinuousColormap::CLASS().getDerivedClasses( );

	int y = 100;
	foreach(ClassMap::value_type i, continuousColormaps)
	{
		if(i.second.isAbstract())
			continue;

		ContinuousColormap* palette = i.second.newInstance<ContinuousColormap>();
		assert(palette!=NULL);

		std::cout << i.first << std::endl;

		cv::putText((cv::Mat&)img, i.first+":", Point2i(5,y-5), cv::FONT_HERSHEY_SIMPLEX, 0.5f, Color::White);
		for(int x=0; x<img.width(); ++x)
		{
			Color::RGB c = palette->getf((float)x / img.width());
			cv::line((cv::Mat&)img, Point2i(x,y),Point2i(x,y+20),c);
		}
		y+=50;
	}

	cv::imshow("test", (cv::Mat&)img);
	cv::waitKey();

	return 0;
}

