/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Backend.h
 *
 * @author Erik Einhorn
 * @date   2011/09/17
 */

#ifndef _MIRA_BACKEND_H_
#define _MIRA_BACKEND_H_

#include <vector>
#include <boost/tuple/tuple.hpp>

#include <QString>

#include <utils/Path.h>

using namespace mira;

///////////////////////////////////////////////////////////////////////////////

class Backend
{
public:

	Backend();

public:

	void createExternalProject(const std::string& name, const Path& path);

	void createDomainToolbox(const std::string& name, const std::string& desc,
	                         const std::string& author, const std::string& tags,
	                         const std::string& includeDir, const Path& path,
	                         bool createMountDir, const std::string& mountDir,
	                         bool isToolbox=false);


	enum ComponentType {
		UNIT,
		MICROUNIT,
		VISUALIZATION2D,
		VISUALIZATION3D,
		VIEWPART,
		EDITORPART,
		PYTHON_UNIT
	};
	void createComponent(const std::string& componentname, const std::string& ns,
	                     const std::string& desc, const std::string& author,
	                     const Path& path, ComponentType type);

	typedef std::vector<std::pair<std::string,std::string>> EnvVars;
	EnvVars getMissingEnvVars(const Path& currentProjectPath="") const;

	std::pair<std::string, bool> getEnvVarsString(const EnvVars& vars) const;

	bool setEnvVarsAutomatically(const EnvVars& vars);

	boost::tuple<bool, std::string, std::string> svnAuth(const std::string& url);
	bool svn(const std::string& command, const std::string& username="",
	         const std::string& password="");



private:

	Path detectMIRARootDir();

	typedef std::vector<std::pair<std::string,std::string>> TemplateVars;
	void copyTemplate(const std::string& filename, const Path& targetDir,
	                  std::string targetName, const TemplateVars& vars=TemplateVars(),
	                  bool append=false);

	void copyTemplate(const std::string& filename, const Path& targetDir,
	                  const TemplateVars& vars=TemplateVars(), bool append=false)
	{
		copyTemplate(filename, targetDir, filename, vars, append);
	}

private:

	Path mMIRARootDir;
};

///////////////////////////////////////////////////////////////////////////////

#endif
