/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file CommonTapeRenderer.C
 *    Common renderer plugins.
 *
 * @author Tim Langner
 * @date   2011/12/30
 */

#include <geometry/Geometry.h>
#include <TapeTextRenderer.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

MIRA_REGISTER_TEXTRENDERER(TapePoint2iRenderer, Point2i)
MIRA_REGISTER_TEXTRENDERER(TapePoint2fRenderer, Point2f)
MIRA_REGISTER_TEXTRENDERER(TapePoint2dRenderer, Point2d)
MIRA_REGISTER_TEXTRENDERER(TapePoint3iRenderer, Point3i)
MIRA_REGISTER_TEXTRENDERER(TapePoint3fRenderer, Point3f)
MIRA_REGISTER_TEXTRENDERER(TapePoint3dRenderer, Point3d)

MIRA_REGISTER_TEXTRENDERER(TapeRect2iRenderer, Rect2i)
MIRA_REGISTER_TEXTRENDERER(TapeRect2fRenderer, Rect2f)
MIRA_REGISTER_TEXTRENDERER(TapeRect2dRenderer, Rect2d)
MIRA_REGISTER_TEXTRENDERER(TapeBox3iRenderer, Box3i)
MIRA_REGISTER_TEXTRENDERER(TapeBox3fRenderer, Box3f)
MIRA_REGISTER_TEXTRENDERER(TapeBox3dRenderer, Box3d)

//////////////////////////////////////////////////////////////////////////////

} // namespace

MIRA_CLASS_SERIALIZATION(mira::TapePoint2iRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapePoint2fRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapePoint2dRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapePoint3iRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapePoint3fRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapePoint3dRenderer, mira::TapeDataRenderer)

MIRA_CLASS_SERIALIZATION(mira::TapeRect2iRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapeRect2fRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapeRect2dRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapeBox3iRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapeBox3fRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapeBox3dRenderer, mira::TapeDataRenderer)
