/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PackageFilterModel.h
 *    The filter model for the package list widget.
 *
 * @author Ronny Stricker, Christian Martin
 * @date   2011-08-16
 */

#ifndef _MIRA_PACKAGESORTMODEL_H_
#define _MIRA_PACKAGESORTMODEL_H_

#include <QSortFilterProxyModel>

#include <core/Package.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * @brief Filter for the package tree model.
 * Provide filtering of tags and expressions (applied to name and/or author
 * and/or description).
 * Furthermore, the class provides an internal cache for speed up.
 */
class PackageSortModel : public QSortFilterProxyModel
{
	Q_OBJECT

public:

	PackageSortModel(QObject *parent = 0) :
		QSortFilterProxyModel(parent)
	{
	}

	virtual ~PackageSortModel()
	{
	}

protected:

	virtual bool lessThan(const QModelIndex& left, const QModelIndex& right) const
	{
		if ((left.column() == 4) && (right.column() == 4)) {
			// Handle comparison of two versions
			QVariant dataL = sourceModel()->data(left);
			Package::Version versionL;
			versionL.fromString(dataL.toString().toStdString());

			QVariant dataR = sourceModel()->data(right);
			Package::Version versionR;
			versionR.fromString(dataR.toString().toStdString());

			return versionL < versionR;
		}
		return QSortFilterProxyModel::lessThan(left, right);
	}
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
