#!/bin/bash

###############################################################################

cwd=`pwd`

for f in `find . -name "*.package"` ; do
	d=`dirname $f`
	p=`basename $f`

	echo $p

	# Skip non Git packages
	if [ ! -d $d/.git ] ; then
		echo "  --> Not a GIT repository. Skipping."
		continue
	fi

	# change to package directory
	cd $d

	# Get current remote URL of 'origin'
	# (We can't use 'git remote get-url', since this is not available on
	#  older clients before version2)
	r=`git remote -v | grep origin | head -n1 | awk '{print $2}'`

	# If the remote URL does not end with .git, we will add it.
	if [[ ! $r == *.git ]] ; then
		echo "  --> Change remote URL to $r.git"
		git remote set-url origin $r.git
	else
		echo "  --> No need to change remote URL"
	fi

	# change back to original directory
	cd $cwd
done
