###############################################################################
# libgit2
###############################################################################

# libgit2-v1.x need cmake3 to compile
if (${CMAKE_VERSION} VERSION_LESS "3.0.0")
	set(CMAKE3_CMD "cmake3")
else()
	set(CMAKE3_CMD ${CMAKE_COMMAND})
endif()

MIRA_EXTERNAL_PROJECT(LibGit2
	GIT_REPOSITORY https://github.com/libgit2/libgit2.git
	GIT_TAG "v1.1.0"

	PREFIX       ${MIRA_EXTERNAL_DIR}/libgit2
	STAMP_DIR    ${MIRA_EXTERNAL_DIR}/libgit2/cmake
	TMP_DIR      ${MIRA_EXTERNAL_DIR}/libgit2/cmake
	DOWNLOAD_DIR ${MIRA_EXTERNAL_DIR}/libgit2
	SOURCE_DIR   ${MIRA_EXTERNAL_DIR}/libgit2/libgit2-1.1.0
	BINARY_DIR   ${MIRA_EXTERNAL_DIR}/libgit2/build
	CMAKE_COMMAND ${CMAKE3_CMD}
	CMAKE_ARGS   -DCMAKE_INSTALL_PREFIX=${MIRA_EXTERNAL_DIR}/libgit2
	             -DCMAKE_INSTALL_LIBDIR=${MIRA_EXTERNAL_DIR}/libgit2/lib
	             -DCMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE}
	             -DCMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE}
	             -DBUILD_CLAR=OFF
	# -DURL=OFF -DBUILD_SHARED_LIBS=OFF -DCMAKE_C_FLAGS=-fPIC
)

SET(LIBGIT2_LIBRARY "git2")

###############################################################################

# Set the include dir
SET(LIBGIT2_INCLUDE_DIRS "${MIRA_EXTERNAL_DIR}/libgit2/include")
SET(LIBGIT2_LIBRARIES "${MIRA_EXTERNAL_DIR}/libgit2/lib")

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "LibGit2")
	MESSAGE(STATUS "   incdir = " ${LIBGIT2_INCLUDE_DIRS})
ENDIF (CMAKE_VERBOSE_MAKEFILE)

###############################################################################

MIRA_INSTALL(
	DIRECTORY ${MIRA_EXTERNAL_DIR}/libgit2/lib
	DESTINATION .
	PACKAGE     MIRAPackage
	FILES_MATCHING
	PATTERN "*.so*"
	PATTERN "*.lib"
)
