/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file AnglePropertyDelegate.C
 *    Implementation of AnglePropertyDelegate.h
 *
 * @author Tim Langner
 * @date   2011/03/29
 */

#include <math/Angle.h>

#include <serialization/PropertySerializer.h>

#include <gui/delegates/private/AnglePropertyDelegate.h>

namespace mira { namespace gui {

///////////////////////////////////////////////////////////////////////////////

MIRA_PROPERTY_ANGLE(SignedDegreei)
MIRA_PROPERTY_ANGLE(SignedDegreef)
MIRA_PROPERTY_ANGLE(SignedDegreed)
MIRA_PROPERTY_ANGLE(Degreei)
MIRA_PROPERTY_ANGLE(Degreef)
MIRA_PROPERTY_ANGLE(Degreed)
MIRA_PROPERTY_ANGLE(SignedRadianf)
MIRA_PROPERTY_ANGLE(SignedRadiand)
MIRA_PROPERTY_ANGLE(Radianf)
MIRA_PROPERTY_ANGLE(Radiand)
MIRA_PROPERTY_ANGLE(SignedAnglef)
MIRA_PROPERTY_ANGLE(SignedAngled)
MIRA_PROPERTY_ANGLE(Anglef)
MIRA_PROPERTY_ANGLE(Angled)

///////////////////////////////////////////////////////////////////////////////

}}

MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_SignedDegreei,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_SignedDegreef,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_SignedDegreed,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_Degreei,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_Degreef,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_Degreed,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_SignedRadianf,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_SignedRadiand,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_Radianf,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_Radiand,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_SignedAnglef,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_SignedAngled,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_Anglef,
                    mira::PropertyEditor::Delegate);
MIRA_CLASS_REGISTER(mira::gui::PropertyDelegate_Angled,
                    mira::PropertyEditor::Delegate);
