###############################################################################
# checks for sqlite3 and the corresponding headers
###############################################################################

FIND_PATH(SQLITE_INCLUDE_DIRS NAMES sqlite3.h)

FIND_LIBRARY(SQLITE_LIBRARY_PATH NAMES sqlite3)
GET_FILENAME_COMPONENT(SQLITE_LIBRARY_DIRS ${SQLITE_LIBRARY_PATH} PATH)

SET(HAVE_SQLITE OFF)

IF(NOT SQLITE_LIBRARY_DIRS STREQUAL SQLITE_LIBRARY_DIRS-NOTFOUND)
	IF(NOT ${SQLITE_INCLUDE_DIRS} STREQUAL SQLITE_INCLUDE_DIRS-NOTFOUND)
		SET(HAVE_SQLITE ON)
	ENDIF(NOT ${SQLITE_INCLUDE_DIRS} STREQUAL SQLITE_INCLUDE_DIRS-NOTFOUND)
ENDIF(NOT SQLITE_LIBRARY_DIRS STREQUAL SQLITE_LIBRARY_DIRS-NOTFOUND)

IF(NOT HAVE_SQLITE)
	MESSAGE(FATAL_ERROR "Could not find sqlite3 library")
ENDIF(NOT HAVE_SQLITE)

SET(SQLITE_LIBRARIES "sqlite3")

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "SQLITE")
	MESSAGE(STATUS "    have   = " ${HAVE_SQLITE})
	MESSAGE(STATUS "    incdir = " ${SQLITE_INCLUDE_DIRS})
	MESSAGE(STATUS "    libdir = " ${SQLITE_LIBRARY_DIRS})
	MESSAGE(STATUS "    libs   = " ${SQLITE_LIBRARIES})	
ENDIF (CMAKE_VERBOSE_MAKEFILE)

###############################################################################

