###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides to functions MIRA_INSTALL_PACKAGE_BASICS, MIRA_INSTALL and
# MIRA_INSTALL_DEVEL, which can be used instead of the standard cmake INSTALL
# macro.
#
# Both function use the same syntax as INSTALL. Please refer to the cmake
# documentation. The usage of COMPONENT is not allowed. Please use the
# keyword PACKAGE instead of COMPONENT.
#
# The function MIRA_INSTALL_PACKAGE_BASICS only needs a PACKAGE and DESTINATION
# parameter. It automatically installs package and changelog files.
#
# The function MIRA_INSTALL should be used of all binary and other
# non-development files of a specific package. 
#
# The function MIRA_INSTALL_DEVEL should only be used for development files.
#
# Author: Christian Martin
#
###############################################################################

function(MIRA_INSTALL_PACKAGE_BASICS)
	# Check if the install function is called from the project that contains
	# the package.
	GET_ASSOCIATED_MIRA_PATH( ${CMAKE_CURRENT_LIST_FILE} associatedMIRAPath )
	string(COMPARE EQUAL ${CMAKE_SOURCE_DIR} ${associatedMIRAPath} SameProject)

	# ignore the install macro if we ended up here from a depending project
	if (${SameProject})

		###########################################################################
		# Go through argument list and look for PACKAGE

		set(nextIsPkgName 0)
		set(pkgName       "")

		set(argIdx 0)
		while(argIdx LESS ${ARGC})
			list(GET ARGN ${argIdx} arg)
			math(EXPR argIdx ${argIdx}+1)
			if(arg STREQUAL "COMPONENT")

				# The use of COMPONENT is not allowed.
				message(FATAL_ERROR "Don't use COMPONENT in MIRA_INSTALL_PACKAGE_BASICS. Use PACKAGE instead!")

			elseif(arg STREQUAL "PACKAGE")

				# PACKAGE will be replaced by COMPONENT
				set(nextIsPkgName 1)
				set(nextIsFile 0)
				list(APPEND installCmd "COMPONENT")
			else()
				# Append the PACKAGE/COMPONENT name
				if(nextIsPkgName EQUAL 1)
					set(pkgName ${arg})
					list(APPEND installCmd ${pkgName})
					set(nextIsPkgName 0)
				else()
					list(APPEND installCmd ${arg})
				endif()
			endif()
		endwhile()

		if(pkgName STREQUAL "")
			message(FATAL_ERROR "Missing PACKAGE in MIRA_INSTALL_PACKAGE_BASICS command.")
		endif()

		# Add the package and changelog file to the list of installed files
		list(INSERT installCmd 0 FILES ${pkgName}.package ${pkgName}.changelog)

		###########################################################################
		# Doing the install, by invoking the INSTALL command

		INSTALL(${installCmd})

	endif()

endfunction()

function(MIRA_INSTALL)

	# Check if the install function is called from the project that contains
	# the package.
	GET_ASSOCIATED_MIRA_PATH( ${CMAKE_CURRENT_LIST_FILE} associatedMIRAPath )
	string(COMPARE EQUAL ${CMAKE_SOURCE_DIR} ${associatedMIRAPath} SameProject)

	# ignore the install macro if we ended up here from a depending project
	if (${SameProject})

		###########################################################################
		# Go through argument list and look for PACKAGE

		set(nextIsPkgName 0)
		set(pkgName       "")

		set(argIdx 0)
		while(argIdx LESS ${ARGC})
			list(GET ARGN ${argIdx} arg)
			math(EXPR argIdx ${argIdx}+1)
			if(arg STREQUAL "COMPONENT")

				# The use of COMPONENT is not allowed.
				message(FATAL_ERROR "Don't use COMPONENT in MIRA_INSTALL. Use PACKAGE instead!")

			elseif(arg STREQUAL "PACKAGE")

				# PACKAGE will be replaced by COMPONENT
				set(nextIsPkgName 1)
				set(nextIsFile 0)
				list(APPEND installCmd "COMPONENT")
			else()
				# Append the PACKAGE/COMPONENT name
				if(nextIsPkgName EQUAL 1)
					set(pkgName ${arg})
					list(APPEND installCmd ${pkgName})
					set(nextIsPkgName 0)
				else()
					list(APPEND installCmd ${arg})
				endif()
			endif()
		endwhile()

		if(pkgName STREQUAL "")
			message(FATAL_ERROR "Missing PACKAGE in MIRA_INSTALL command.")
		endif()

		###########################################################################
		# Doing the install, by invoking the INSTALL command

		INSTALL(${installCmd})

	endif()

endfunction()

###############################################################################

function(MIRA_INSTALL_DEVEL)

	message(FATAL_ERROR "MIRA_INSTALL_DEVEL is not supported at the moment "
	        "and is only reserved for future usage. Don't use it now!")

	###########################################################################
	# Go through argument list and look for PACKAGE and remove
	# obsolete COMPONENT from argument list.

	set(nextIsPkgName 0)
	set(pkgName       "")

	set(argIdx 0)
	while(argIdx LESS ${ARGC})
		list(GET ARGN ${argIdx} arg)
		math(EXPR argIdx ${argIdx}+1)

		if(arg STREQUAL "COMPONENT")

			# The use of COMPONENT is not allowed.
			message(FATAL_ERROR "Don't use COMPONENT in MIRA_INSTALL_DEVEL. Use PACKAGE instead!")

		elseif(arg STREQUAL "PACKAGE")
		
			# PACKAGE will be replaced by COMPONENT
			set(nextIsPkgName 1)
			list(APPEND installCmd "COMPONENT")

		else()
			# Append the PACKAGE/COMPONENT name
			if(nextIsPkgName EQUAL 1)
				set(pkgName ${arg})
				list(APPEND installCmd ${pkgName}-devel)
				set(nextIsPkgName 0)
			else()
				list(APPEND installCmd ${arg})
			endif()
		endif()
	endwhile()

	if(pkgName STREQUAL "")
		message(FATAL_ERROR "Missing PACKAGE in MIRA_INSTALL_DEVEL command.")
	endif()

	###########################################################################
	# Doing the install, by invoking the INSTALL command

	INSTALL(${installCmd})

endfunction()

###############################################################################
