/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Visualization3D.C
 *    Implemenation of Visualization3D.
 *
 * @author Erik Einhorn
 * @date   2010/12/19
 */

#include <serialization/Serialization.h>
#include <visualization/Visualization3D.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

IVisualization3DSite::Camera::Camera()
{
	distance = 10.0f;
	Point3f from(-1.0f,-1.0f,1.0f);
	from.normalize();
	from *= distance;
	lookAt(from, Point3f(0,0,0));
	roll  = 0.0f;
}

void IVisualization3DSite::Camera::lookAt(const Point3f& from, const Point3f& to)
{
	const float eps = 0.00001f;

	Eigen::Vector3f d = to - from;
	float l = d.norm();

	pitch = -asin( d.z() / l );

	Eigen::Vector2f newYawVector(d.x(), d.y());
	const float newYawVectorLength = newYawVector.norm();
	Eigen::Vector3f currentYawVector(newYawVectorLength* cos(yaw), newYawVectorLength * sin(yaw), d.z());

	// do we have to adjust yaw to recreate camera movement?
	if((currentYawVector-d).norm() > l * eps)
		yaw = atan2( d.y(), d.x());

	position = from;
}

///////////////////////////////////////////////////////////////////////////////

Visualization3D::Visualization3D() :
	mSite(NULL)
{
}

void Visualization3D::init(IVisualizationSite* site)
{
	mSite = dynamic_cast<IVisualization3DSite*>(site);
	assert(mSite!=NULL);
	setupScene(mSite);
	// call set enabled explicitly, to set the correct state after the
	// creation of the visualization
	setEnabled(isEnabled());
}

IVisualization3DSite* Visualization3D::getSite()
{
	return mSite;
}

///////////////////////////////////////////////////////////////////////////////

}

MIRA_CLASS_SERIALIZATION(mira::Visualization3D, mira::Visualization)
