/*
 * Copyright (C) 2016 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file IndexSelectorProperty.C
 *    Property to select an element from a set type.
 *
 * @author Christof Schröter
 * @date   2016/12/12
 */

#include <widgets/PropertyEditor.h>
#include <widgets/private/PropertyEditorCommonDelegates.h>

#include <visualization/IndexSelectorProperty.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

void IndexSelectorPropertyBase::wrapIndex()
{
	// looks weird but works for over- and underflow without conditionals
	mIndex = (mIndex % mWrapIndex + mWrapIndex) % mWrapIndex;
}

void IndexSelectorPropertyBase::setIndex(int index)
{
	mIndex = index;
	wrapIndex();
	mNotifyChange();
}

void IndexSelectorPropertyBase::setWrapIndex(unsigned int wrap)
{
	mWrapIndex = std::max(1u, wrap); // enforce > 0 !
	wrapIndex();
}

///////////////////////////////////////////////////////////////////////////////

class PropertyDelegate_IndexSelectorProperty : public PropertyEditor::Delegate
{
	MIRA_OBJECT(PropertyDelegate_IndexSelectorProperty)
public:

	virtual SupportedTypes supportedTypes() const {
		return
			makeSupportedType<IndexSelectorProperty<true>>(SupportedType::TEXT | SupportedType::EDITOR);
	}

	virtual std::string getText(const PropertyNode* property) {
		return property->getAsString();
	}

	virtual QWidget* createEditor(PropertyNode* property, QWidget* parent) {
		return new PropertyDelegate_SpinBoxSigned(property, parent);
	}
};

///////////////////////////////////////////////////////////////////////////////

}

MIRA_CLASS_REGISTER(mira::PropertyDelegate_IndexSelectorProperty, mira::PropertyEditor::Delegate);
