/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ArrowObject.C
 *    Implementation of ArrowObject.
 *
 * @author Tim Langner
 * @date   2011/01/09
 */

#include <visualization/3d/ArrowObject.h>
#include <visualization/3d/MeshObject.h>

#include <OGRE/OgreSceneManager.h>
#include <OGRE/OgreSceneNode.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

ArrowObject::ArrowObject(Ogre::SceneManager* sceneManager,
                         Ogre::SceneNode* parent) :
	VisualizationObject(sceneManager, parent),
	mShaft(NULL),
	mHead(NULL),
	mRadius(0.05f),
	mLength(1.0f),
	mShowHead(true)
{
	mShaft = new MeshObject("Cylinder.mesh", mSceneManager, mNode);
	mHead = new MeshObject("Cone.mesh", mSceneManager, mNode);
	updateScales();
}

ArrowObject::~ArrowObject()
{
	delete mShaft;
	delete mHead;
}

void ArrowObject::setColor(const Ogre::ColourValue& color)
{
	mShaft->setColor(color);
	mHead->setColor(color);
}

void ArrowObject::showHead(bool show)
{
	mShowHead = show;
	mHead->setVisible(show);
	updateScales();
}

void ArrowObject::setRadius(float radius)
{
	mRadius = radius;
	updateScales();
}

void ArrowObject::setLength(float length)
{
	mLength = length;
	updateScales();
}

void ArrowObject::updateScales()
{
	float length = mLength;
	float r4 = mRadius*4;
	float headLength = length < r4 ? 0.1 * length :  r4;
	float headRadius = mRadius*2;
	if (mShowHead)
		length -= headLength;
	mShaft->setScale(Ogre::Vector3(mRadius,length,mRadius));
	mShaft->setPosition(Ogre::Vector3(0,0,0));
	mHead->setScale(Ogre::Vector3(headRadius,headLength,headRadius));
	mHead->setPosition(Ogre::Vector3(0,length,0));
}

///////////////////////////////////////////////////////////////////////////////

}
