/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationObject.h
 *    Declaration of VisualizationObject.
 *
 * @author Tim Langner
 * @date   2011/01/04
 */

#ifndef _MIRA_VISUALIZATIONOBJECT_H_
#define _MIRA_VISUALIZATIONOBJECT_H_

#include <transform/RigidTransform.h>

#include <image/Color.h>

#ifndef Q_MOC_RUN
#include <OGRE/OgreVector3.h>
#include <OGRE/OgreColourValue.h>
#endif

namespace Ogre {
	class ManualObject;
	class Quaternion;
	class SceneManager;
	class SceneNode;
}

namespace mira {

//////////////////////////////////////////////////////////////////////////////

class VisualizationObject
{
public:
	VisualizationObject(Ogre::SceneManager* sceneManager, Ogre::SceneNode* parent=NULL);
	virtual ~VisualizationObject();

	virtual void setScale(const Ogre::Vector3& scale);
	virtual void setScale(const Eigen::Vector3f& scale);
	virtual void setPosition(const Ogre::Vector3& position);
	virtual void setPosition(const Eigen::Vector3f& position);
	virtual void setOrientation(const Ogre::Quaternion& orientation);
	virtual void setOrientation(const Eigen::Quaternionf& orientation);
	virtual void setColor(const Ogre::ColourValue& color) {}
	virtual void setColor(Color::RGBA color) {
		setColor(Ogre::ColourValue(color.r, color.g, color.b, color.a));
	}
	virtual void setTransform(const RigidTransform2f& transform);
	virtual void setTransform(const RigidTransform3f& transform);

	virtual void setVisible(bool visible, bool cascade = true);

	Ogre::SceneNode* getNode()
	{
		return mNode;
	}

protected:
	Ogre::SceneManager* mSceneManager;
	Ogre::SceneNode* mNode;
};

//////////////////////////////////////////////////////////////////////////////

}

#endif
