/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file CameraOrbitTool.h
 *
 * @author Erik Einhorn
 * @date   2013/03/13
 */

#ifndef _MIRA_CAMERAORBITTOOL_H_
#define _MIRA_CAMERAORBITTOOL_H_

#include <QtGui/QMouseEvent>

#include <math/Math.h>
#include <math/YawPitchRoll.h>

#include <visualization/VisualizationTool3D.h>
#include <visualization/3d/MeshObject.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class CameraOrbitTool3D : public VisualizationTool3D
{
	MIRA_META_OBJECT(CameraOrbitTool3D,
			("Name", "Orbit")
			("Description", "Moves the observer camera around")
			("Category", "Camera")
			("Order", "0"))

public:

	CameraOrbitTool3D();

	virtual QIcon getIcon();

	virtual void onMousePressed(QMouseEvent* e);

	virtual void onMouseReleased(QMouseEvent* e);

	static const float cMaxPitch;

	virtual void onMouseMoved(QMouseEvent* e);

	virtual void onMouseWheel(QWheelEvent * e);

	void setInteractionSpeed(float trans=0.001f, float rot=0.002f,
	                         float scale=0.005, float wheelScale=0.0003f, float acceleration=1.2f);

	virtual int getDisplaceShortCut() const;

	void activate();

	void deactivate();

	void setupScene(IVisualization3DSite* site);

	static const float cFadeDuration; // in [ms]
	static const float cFadeAlpha;

	void updatePivotIndicator();

	virtual void update(Duration dt);

	void updateOwnRepresentation();

	void updateCamera();

private:
	QPoint mOldMousePos;

	float mPitch;
	float mYaw;
	float mRoll;

	Eigen::Vector3f mFocal;

	// interaction settings
	float mMouseAcceleration;
	float mSpeedTrans;
	float mSpeedRot;
	float mSpeedScale;
	float mSpeedWheelScale;

	IVisualization3DSite::Camera mCamera;

	boost::shared_ptr<MeshObject> mPivotIndicator;

	enum PivotIndicatorState {
		NONE,
		FADE_IN,
		FADE_OUT,
	};

	PivotIndicatorState mPivotIndicatorState;
	float mPivotIndicatorAlpha;
};


///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
