/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file AxesVisualization.h
 *    Declaration of AxesVisualization.
 *
 * @author Tim Langner
 * @date   2011/01/04
 */

#ifndef _MIRA_AXESVISUALIZATION_H_
#define _MIRA_AXESVISUALIZATION_H_

#include <serialization/Serialization.h>
#include <serialization/GetterSetter.h>

#include <visualization/3d/AxesObject.h>
#include <visualization/Visualization3D.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

class AxesVisualization : public Visualization3D
{
	MIRA_META_OBJECT(AxesVisualization,
					("Name", "Axes")
					("Description", "Shows the three coordinate axes in the origin")
					//("Category"   , "Basic")
					)
public:

	AxesVisualization() :
		mAxes(NULL),
		mAxisLength(1.0f),
		mAxisRadius(0.025f),
		mShowArrows(true)
	{
	}

	virtual ~AxesVisualization()
	{
		delete mAxes;
	}

public:

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, Visualization3D);
		r.property("Length", mAxisLength, setter<float>(&AxesVisualization::setAxisLength, this),
		           "The length of the axes in m", 1.0f);
		r.property("Radius", mAxisRadius, setter<float>(&AxesVisualization::setAxisRadius, this),
		           "The radius of the axes in m", 0.025f);
		r.property("ShowArrows", mShowArrows, setter<bool>(&AxesVisualization::setShowArrows, this),
		           "Should arrows be shown", true);
	}

public:

	void setAxisLength(float length);
	void setAxisRadius(float radius);
	void setShowArrows(bool show);

public: // implementation of Visualization3D and Visualization

	virtual void setupScene(IVisualization3DSite* site);

	virtual Ogre::SceneNode* getNode()
	{
		if (!mAxes)
			return NULL;

		return mAxes->getNode();
	}

	virtual void setEnabled(bool enabled);
	AxesObject* getAxes()
	{
		return mAxes;
	}

protected:

	AxesObject* mAxes;
	float mAxisLength;
	float mAxisRadius;
	bool mShowArrows;
};

//////////////////////////////////////////////////////////////////////////////

}

#endif
